/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.JoinedRow;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.OffsetRow;

public abstract class VersionedObjectSerializer<T>
extends ObjectSerializer<T> {
    private static final long serialVersionUID = 1L;

    public VersionedObjectSerializer(RowType rowType) {
        super(VersionedObjectSerializer.versionType(rowType));
    }

    public static RowType versionType(RowType rowType) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(-1, "_VERSION", new IntType(false)));
        fields.addAll(rowType.getFields());
        return new RowType(false, fields);
    }

    public abstract int getVersion();

    public abstract InternalRow convertTo(T var1);

    public abstract T convertFrom(int var1, InternalRow var2);

    @Override
    public final InternalRow toRow(T record) {
        return new JoinedRow().replace(GenericRow.of(this.getVersion()), this.convertTo(record));
    }

    @Override
    public final T fromRow(InternalRow row) {
        return this.convertFrom(row.getInt(0), new OffsetRow(row.getFieldCount() - 1, 1).replace(row));
    }
}

