/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;

public class DDBPathMetadata
extends PathMetadata {
    private boolean isAuthoritativeDir;

    public DDBPathMetadata(PathMetadata pmd) {
        super(pmd.getFileStatus(), pmd.isEmptyDirectory(), pmd.isDeleted(), pmd.getLastUpdated());
        this.isAuthoritativeDir = false;
        this.setLastUpdated(pmd.getLastUpdated());
    }

    public DDBPathMetadata(S3AFileStatus fileStatus) {
        super(fileStatus);
        this.isAuthoritativeDir = false;
    }

    public DDBPathMetadata(S3AFileStatus fileStatus, Tristate isEmptyDir, boolean isDeleted, long lastUpdated) {
        super(fileStatus, isEmptyDir, isDeleted, lastUpdated);
        this.isAuthoritativeDir = false;
    }

    public DDBPathMetadata(S3AFileStatus fileStatus, Tristate isEmptyDir, boolean isDeleted, boolean isAuthoritativeDir, long lastUpdated) {
        super(fileStatus, isEmptyDir, isDeleted, lastUpdated);
        this.isAuthoritativeDir = isAuthoritativeDir;
    }

    public boolean isAuthoritativeDir() {
        return this.isAuthoritativeDir;
    }

    public void setAuthoritativeDir(boolean authoritativeDir) {
        this.isAuthoritativeDir = authoritativeDir;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "DDBPathMetadata{isAuthoritativeDir=" + this.isAuthoritativeDir + ", PathMetadata=" + super.toString() + '}';
    }
}

