/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.hdfs.utils;

import java.io.File;
import java.util.Collection;
import org.apache.fluss.config.ConfigBuilder;
import org.apache.fluss.utils.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    static final Text HDFS_DELEGATION_TOKEN_KIND = new Text("HDFS_DELEGATION_TOKEN");
    private static final String[] FLUSS_CONFIG_PREFIXES = new String[]{"fluss.hadoop."};

    public static Configuration getHadoopConfiguration(org.apache.fluss.config.Configuration flussConfiguration) {
        HdfsConfiguration result = new HdfsConfiguration();
        boolean foundHadoopConfiguration = false;
        String[] possibleHadoopConfPaths = new String[2];
        String hadoopHome = System.getenv("HADOOP_HOME");
        if (hadoopHome != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_HOME: {}", (Object)hadoopHome);
            possibleHadoopConfPaths[0] = hadoopHome + "/conf";
            possibleHadoopConfPaths[1] = hadoopHome + "/etc/hadoop";
        }
        for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
            if (possibleHadoopConfPath == null) continue;
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound(result, possibleHadoopConfPath);
        }
        String hadoopConfDir = System.getenv("HADOOP_CONF_DIR");
        if (hadoopConfDir != null) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_CONF_DIR: {}", (Object)hadoopConfDir);
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound(result, hadoopConfDir) || foundHadoopConfiguration;
        }
        for (String key : flussConfiguration.keySet()) {
            for (String prefix : FLUSS_CONFIG_PREFIXES) {
                if (!key.startsWith(prefix)) continue;
                String newKey = key.substring(prefix.length());
                String value = flussConfiguration.getString(ConfigBuilder.key((String)key).stringType().noDefaultValue(), null);
                result.set(newKey, value);
                LOG.debug("Adding Fluss config entry for {} as {}={} to Hadoop config", new Object[]{key, newKey, value});
                foundHadoopConfiguration = true;
            }
        }
        if (!foundHadoopConfiguration) {
            LOG.warn("Could not find Hadoop configuration via any of the supported methods (Fluss configuration, environment variables).");
        }
        return result;
    }

    public static boolean isKerberosSecurityEnabled(UserGroupInformation ugi) {
        return UserGroupInformation.isSecurityEnabled() && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.KERBEROS;
    }

    public static boolean areKerberosCredentialsValid(UserGroupInformation ugi, boolean useTicketCache) {
        Preconditions.checkState((boolean)HadoopUtils.isKerberosSecurityEnabled(ugi));
        if (useTicketCache && !ugi.hasKerberosCredentials()) {
            if (HadoopUtils.hasHDFSDelegationToken(ugi)) {
                LOG.warn("Hadoop security is enabled but current login user does not have Kerberos credentials, use delegation token instead. Fluss application will terminate after token expires.");
                return true;
            }
            LOG.error("Hadoop security is enabled, but current login user has neither Kerberos credentials nor delegation tokens!");
            return false;
        }
        return true;
    }

    public static boolean hasHDFSDelegationToken(UserGroupInformation ugi) {
        Collection<Token<? extends TokenIdentifier>> usrTok = ugi.getTokens();
        for (Token<? extends TokenIdentifier> token : usrTok) {
            if (!token.getKind().equals(HDFS_DELEGATION_TOKEN_KIND)) continue;
            return true;
        }
        return false;
    }

    private static boolean addHadoopConfIfFound(Configuration configuration, String possibleHadoopConfPath) {
        boolean foundHadoopConfiguration = false;
        if (new File(possibleHadoopConfPath).exists()) {
            if (new File(possibleHadoopConfPath + "/core-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/core-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/core-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
            if (new File(possibleHadoopConfPath + "/hdfs-site.xml").exists()) {
                configuration.addResource(new Path(possibleHadoopConfPath + "/hdfs-site.xml"));
                LOG.debug("Adding " + possibleHadoopConfPath + "/hdfs-site.xml to hadoop configuration");
                foundHadoopConfiguration = true;
            }
        }
        return foundHadoopConfiguration;
    }
}

