/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.socket.oio;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.socket.DatagramChannel;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.socket.DatagramChannelFactory;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.socket.oio.OioDatagramChannel;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.socket.oio.OioDatagramPipelineSink;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.util.internal.ExecutorUtil;

public class OioDatagramChannelFactory
implements DatagramChannelFactory {
    private final Executor workerExecutor;
    final OioDatagramPipelineSink sink;
    private boolean shutdownExecutor;

    public OioDatagramChannelFactory() {
        this(Executors.newCachedThreadPool());
        this.shutdownExecutor = true;
    }

    public OioDatagramChannelFactory(Executor workerExecutor) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new OioDatagramPipelineSink(workerExecutor);
    }

    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return new OioDatagramChannel(this, pipeline, this.sink);
    }

    public void shutdown() {
        if (this.shutdownExecutor) {
            ExecutorUtil.terminate(this.workerExecutor);
        }
    }

    public void releaseExternalResources() {
        this.shutdown();
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

