/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class ShellBasedUnixGroupsMapping
implements GroupMappingServiceProvider {
    private static final Log LOG = LogFactory.getLog(ShellBasedUnixGroupsMapping.class);

    @Override
    public List<String> getGroups(String userName) throws IOException {
        return this.getUnixGroups(userName);
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
        return new Shell.ShellCommandExecutor(Shell.getGroupsForUserCommand(userName), null, null, 0L);
    }

    protected Shell.ShellCommandExecutor createGroupIDExecutor(String userName) {
        return new Shell.ShellCommandExecutor(Shell.getGroupsIDForUserCommand(userName), null, null, 0L);
    }

    private List<String> getUnixGroups(String user) throws IOException {
        List<String> groups;
        Shell.ShellCommandExecutor executor = this.createGroupExecutor(user);
        try {
            executor.execute();
            groups = this.resolveFullGroupNames(executor.getOutput());
        }
        catch (Shell.ExitCodeException e) {
            try {
                groups = this.resolvePartialGroupNames(user, e.getMessage(), executor.getOutput());
            }
            catch (PartialGroupNameException pge) {
                LOG.warn("unable to return groups for user " + user, pge);
                return new LinkedList<String>();
            }
        }
        if (!Shell.WINDOWS) {
            for (int i = 1; i < groups.size(); ++i) {
                if (!groups.get(i).equals(groups.get(0))) continue;
                groups.remove(i);
                break;
            }
        }
        return groups;
    }

    private List<String> parsePartialGroupNames(String groupNames, String groupIDs) throws PartialGroupNameException {
        StringTokenizer nameTokenizer = new StringTokenizer(groupNames, Shell.TOKEN_SEPARATOR_REGEX);
        StringTokenizer idTokenizer = new StringTokenizer(groupIDs, Shell.TOKEN_SEPARATOR_REGEX);
        LinkedList<String> groups = new LinkedList<String>();
        while (nameTokenizer.hasMoreTokens()) {
            if (!idTokenizer.hasMoreTokens()) {
                throw new PartialGroupNameException("Number of group names and ids do not match. group name =" + groupNames + ", group id = " + groupIDs);
            }
            String groupName = nameTokenizer.nextToken();
            String groupID = idTokenizer.nextToken();
            if (StringUtils.isNumeric(groupName) && groupName.equals(groupID)) continue;
            groups.add(groupName);
        }
        return groups;
    }

    private List<String> resolvePartialGroupNames(String userName, String errMessage, String groupNames) throws PartialGroupNameException {
        if (Shell.WINDOWS) {
            throw new PartialGroupNameException("Does not support partial group name resolution on Windows. " + errMessage);
        }
        if (groupNames.isEmpty()) {
            throw new PartialGroupNameException("The user name '" + userName + "' is not found. " + errMessage);
        }
        LOG.warn("Some group names for '" + userName + "' are not resolvable. " + errMessage);
        try {
            Shell.ShellCommandExecutor exec2 = this.createGroupIDExecutor(userName);
            exec2.execute();
            return this.parsePartialGroupNames(groupNames, exec2.getOutput());
        }
        catch (Shell.ExitCodeException ece) {
            throw new PartialGroupNameException("failed to get group id list for user '" + userName + "'", ece);
        }
        catch (IOException ioe) {
            throw new PartialGroupNameException("can't execute the shell command to get the list of group id for user '" + userName + "'", ioe);
        }
    }

    private List<String> resolveFullGroupNames(String groupNames) {
        StringTokenizer tokenizer = new StringTokenizer(groupNames, Shell.TOKEN_SEPARATOR_REGEX);
        LinkedList<String> groups = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
        return groups;
    }

    private static class PartialGroupNameException
    extends IOException {
        public PartialGroupNameException(String message) {
            super(message);
        }

        public PartialGroupNameException(String message, Throwable err) {
            super(message, err);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("PartialGroupNameException ");
            sb.append(super.getMessage());
            return sb.toString();
        }
    }
}

