/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.shaded.hadoop2.com.google.common.collect.Sets;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class GetNodesToLabelsResponsePBImpl
extends GetNodesToLabelsResponse {
    YarnServiceProtos.GetNodesToLabelsResponseProto proto = YarnServiceProtos.GetNodesToLabelsResponseProto.getDefaultInstance();
    YarnServiceProtos.GetNodesToLabelsResponseProto.Builder builder = null;
    boolean viaProto = false;
    private Map<NodeId, Set<String>> nodeToLabels;

    public GetNodesToLabelsResponsePBImpl() {
        this.builder = YarnServiceProtos.GetNodesToLabelsResponseProto.newBuilder();
    }

    public GetNodesToLabelsResponsePBImpl(YarnServiceProtos.GetNodesToLabelsResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private void initNodeToLabels() {
        if (this.nodeToLabels != null) {
            return;
        }
        YarnServiceProtos.GetNodesToLabelsResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.NodeIdToLabelsProto> list = p.getNodeToLabelsList();
        this.nodeToLabels = new HashMap<NodeId, Set<String>>();
        for (YarnProtos.NodeIdToLabelsProto c : list) {
            this.nodeToLabels.put(new NodeIdPBImpl(c.getNodeId()), Sets.newHashSet(c.getNodeLabelsList()));
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetNodesToLabelsResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addNodeToLabelsToProto() {
        this.maybeInitBuilder();
        this.builder.clearNodeToLabels();
        if (this.nodeToLabels == null) {
            return;
        }
        Iterable<YarnProtos.NodeIdToLabelsProto> iterable = new Iterable<YarnProtos.NodeIdToLabelsProto>(){

            @Override
            public Iterator<YarnProtos.NodeIdToLabelsProto> iterator() {
                return new Iterator<YarnProtos.NodeIdToLabelsProto>(){
                    Iterator<Map.Entry<NodeId, Set<String>>> iter;
                    {
                        this.iter = GetNodesToLabelsResponsePBImpl.this.nodeToLabels.entrySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnProtos.NodeIdToLabelsProto next() {
                        Map.Entry<NodeId, Set<String>> now = this.iter.next();
                        return YarnProtos.NodeIdToLabelsProto.newBuilder().setNodeId(GetNodesToLabelsResponsePBImpl.this.convertToProtoFormat(now.getKey())).addAllNodeLabels((Iterable<String>)now.getValue()).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllNodeToLabels((Iterable<? extends YarnProtos.NodeIdToLabelsProto>)iterable);
    }

    private void mergeLocalToBuilder() {
        if (this.nodeToLabels != null) {
            this.addNodeToLabelsToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public YarnServiceProtos.GetNodesToLabelsResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    @Override
    public Map<NodeId, Set<String>> getNodeToLabels() {
        this.initNodeToLabels();
        return this.nodeToLabels;
    }

    @Override
    public void setNodeToLabels(Map<NodeId, Set<String>> map) {
        this.initNodeToLabels();
        this.nodeToLabels.clear();
        this.nodeToLabels.putAll(map);
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetNodesToLabelsResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }
}

