/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class UpdateContainerRequest {
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static UpdateContainerRequest newInstance(int version, ContainerId containerId, ContainerUpdateType updateType, Resource targetCapability) {
        UpdateContainerRequest request = Records.newRecord(UpdateContainerRequest.class);
        request.setContainerVersion(version);
        request.setContainerId(containerId);
        request.setContainerUpdateType(updateType);
        request.setCapability(targetCapability);
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getContainerVersion();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setContainerVersion(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ContainerUpdateType getContainerUpdateType();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setContainerUpdateType(ContainerUpdateType var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ContainerId getContainerId();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setContainerId(ContainerId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Resource getCapability();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setCapability(Resource var1);

    public int hashCode() {
        int prime = 2153;
        int result = 2459;
        ContainerId cId = this.getContainerId();
        Resource capability = this.getCapability();
        result = 2153 * result + (capability == null ? 0 : capability.hashCode());
        result = 2153 * result + (cId == null ? 0 : cId.hashCode());
        result = 2153 * result + this.getContainerVersion();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateContainerRequest other = (UpdateContainerRequest)obj;
        Resource capability = this.getCapability();
        if (capability == null ? other.getCapability() != null : !capability.equals(other.getCapability())) {
            return false;
        }
        ContainerId cId = this.getContainerId();
        if (cId == null ? other.getContainerId() != null : !cId.equals(other.getContainerId())) {
            return false;
        }
        return this.getContainerVersion() == other.getContainerVersion();
    }
}

