/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.model.StorageBucket;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.StorageOwner;
import org.jets3t.service.mx.MxDelegate;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.RestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StorageService {
    private static final Log log = LogFactory.getLog(StorageService.class);
    public static final int BUCKET_STATUS__MY_BUCKET = 0;
    public static final int BUCKET_STATUS__DOES_NOT_EXIST = 1;
    public static final int BUCKET_STATUS__ALREADY_CLAIMED = 2;
    protected Jets3tProperties jets3tProperties = null;
    protected ProviderCredentials credentials = null;
    private String invokingApplicationDescription = null;
    private boolean isHttpsOnly = true;
    private int internalErrorRetryMax = 5;
    private boolean isShutdown = false;
    protected long timeOffset = 0L;

    protected StorageService(ProviderCredentials credentials, String invokingApplicationDescription, Jets3tProperties jets3tProperties) {
        this.credentials = credentials;
        this.invokingApplicationDescription = invokingApplicationDescription;
        this.jets3tProperties = jets3tProperties;
        this.isHttpsOnly = this.getHttpsOnly();
        this.internalErrorRetryMax = jets3tProperties.getIntProperty("storage-service.internal-error-retry-max", 5);
        this.initializeDefaults();
    }

    protected void initializeDefaults() {
        System.setProperty("networkaddress.cache.ttl", "300");
        System.setProperty("networkaddress.cache.negative.ttl", "1");
        MxDelegate.getInstance().init();
        MxDelegate.getInstance().registerS3ServiceMBean();
        MxDelegate.getInstance().registerS3ServiceExceptionMBean();
    }

    protected StorageService(ProviderCredentials credentials, String invokingApplicationDescription) {
        this(credentials, invokingApplicationDescription, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    protected StorageService(ProviderCredentials credentials) {
        this(credentials, null);
    }

    public void shutdown() throws ServiceException {
        this.isShutdown = true;
        this.shutdownImpl();
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public boolean isAuthenticatedConnection() {
        return this.credentials != null;
    }

    public boolean isHttpsOnly() {
        return this.isHttpsOnly;
    }

    public int getInternalErrorRetryMax() {
        return this.internalErrorRetryMax;
    }

    public Jets3tProperties getJetS3tProperties() {
        return this.jets3tProperties;
    }

    protected abstract XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException;

    protected abstract StorageBucket newBucket();

    protected abstract StorageObject newObject();

    protected void sleepOnInternalError(int internalErrorCount) throws ServiceException, InterruptedException {
        long delayMs;
        if (internalErrorCount <= this.internalErrorRetryMax) {
            delayMs = 50L * (long)((int)Math.pow(internalErrorCount, 2.0));
            if (log.isWarnEnabled()) {
                log.warn("Encountered " + internalErrorCount + " Internal Server error(s), will retry in " + delayMs + "ms");
            }
        } else {
            throw new ServiceException("Encountered too many Internal Server errors (" + internalErrorCount + "), aborting request.");
        }
        Thread.sleep(delayMs);
    }

    public ProviderCredentials getProviderCredentials() {
        return this.credentials;
    }

    public String getInvokingApplicationDescription() {
        return this.invokingApplicationDescription;
    }

    protected void assertAuthenticatedConnection(String action) throws ServiceException {
        if (!this.isAuthenticatedConnection()) {
            throw new ServiceException("The requested action cannot be performed with a non-authenticated service: " + action);
        }
    }

    protected void assertValidBucket(StorageBucket bucket, String action) throws ServiceException {
        if (bucket == null || bucket.getName() == null || bucket.getName().length() == 0) {
            throw new ServiceException("The action " + action + " cannot be performed with an invalid bucket: " + bucket);
        }
    }

    protected void assertValidObject(StorageObject object, String action) throws ServiceException {
        if (object == null || object.getKey() == null || object.getKey().length() == 0) {
            throw new ServiceException("The action " + action + " cannot be performed with an invalid object: " + object);
        }
    }

    protected void assertValidObject(String key, String action) throws ServiceException {
        if (key == null || key.length() == 0) {
            throw new ServiceException("The action " + action + " cannot be performed with an invalid object key name: " + key);
        }
    }

    public StorageObject[] listObjects(String bucketName) throws ServiceException {
        return this.listObjects(bucketName, null, null, 1000L);
    }

    public StorageObject[] listObjects(String bucketName, String prefix, String delimiter) throws ServiceException {
        return this.listObjects(bucketName, prefix, delimiter, 1000L);
    }

    public StorageBucket createBucket(String bucketName) throws ServiceException {
        return this.createBucketImpl(bucketName, null, null);
    }

    public StorageBucket createBucket(StorageBucket bucket) throws ServiceException {
        return this.createBucketImpl(bucket.getName(), bucket.getLocation(), bucket.getAcl());
    }

    public boolean isObjectInBucket(String bucketName, String objectKey) throws ServiceException {
        try {
            this.getObjectDetails(bucketName, objectKey);
        }
        catch (ServiceException e) {
            if (404 == e.getResponseCode() || "NoSuchKey".equals(e.getErrorCode()) || "NoSuchBucket".equals(e.getErrorCode())) {
                return false;
            }
            if ("AccessDenied".equals(e.getErrorCode())) {
                return true;
            }
            throw e;
        }
        return true;
    }

    public StorageObject getObject(String bucketName, String objectKey) throws ServiceException {
        return this.getObject(bucketName, objectKey, null, null, null, null, null, null);
    }

    public StorageObject getObjectDetails(String bucketName, String objectKey) throws ServiceException {
        return this.getObjectDetails(bucketName, objectKey, null, null, null, null);
    }

    public StorageBucket[] listAllBuckets() throws ServiceException {
        this.assertAuthenticatedConnection("List all buckets");
        StorageBucket[] buckets = this.listAllBucketsImpl();
        MxDelegate.getInstance().registerStorageBucketMBeans(buckets);
        return buckets;
    }

    public StorageOwner getAccountOwner() throws ServiceException {
        this.assertAuthenticatedConnection("List all buckets to find account owner");
        return this.getAccountOwnerImpl();
    }

    public StorageObject[] listObjects(String bucketName, String prefix, String delimiter, long maxListingLength) throws ServiceException {
        MxDelegate.getInstance().registerStorageBucketListEvent(bucketName);
        StorageObject[] objects = this.listObjectsImpl(bucketName, prefix, delimiter, maxListingLength);
        MxDelegate.getInstance().registerStorageObjectMBean(bucketName, objects);
        return objects;
    }

    public StorageObjectsChunk listObjectsChunked(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey) throws ServiceException {
        MxDelegate.getInstance().registerStorageBucketListEvent(bucketName);
        StorageObjectsChunk chunk = this.listObjectsChunkedImpl(bucketName, prefix, delimiter, maxListingLength, priorLastKey, false);
        MxDelegate.getInstance().registerStorageObjectMBean(bucketName, chunk.getObjects());
        return chunk;
    }

    public StorageObjectsChunk listObjectsChunked(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, boolean completeListing) throws ServiceException {
        MxDelegate.getInstance().registerStorageBucketListEvent(bucketName);
        StorageObjectsChunk chunk = this.listObjectsChunkedImpl(bucketName, prefix, delimiter, maxListingLength, priorLastKey, completeListing);
        MxDelegate.getInstance().registerStorageObjectMBean(bucketName, chunk.getObjects());
        return chunk;
    }

    public StorageBucket getBucket(String bucketName) throws ServiceException {
        this.assertAuthenticatedConnection("Get Bucket");
        StorageBucket[] existingBuckets = this.listAllBuckets();
        for (int i = 0; i < existingBuckets.length; ++i) {
            if (!existingBuckets[i].getName().equals(bucketName)) continue;
            return existingBuckets[i];
        }
        return null;
    }

    public StorageBucket getOrCreateBucket(String bucketName) throws ServiceException {
        StorageBucket bucket = this.getBucket(bucketName);
        if (bucket == null) {
            bucket = this.createBucket(bucketName);
        }
        return bucket;
    }

    public void deleteBucket(StorageBucket bucket) throws ServiceException {
        this.assertValidBucket(bucket, "Delete bucket");
        this.deleteBucketImpl(bucket.getName());
    }

    public void deleteBucket(String bucketName) throws ServiceException {
        this.deleteBucketImpl(bucketName);
    }

    public StorageObject putObject(String bucketName, StorageObject object) throws ServiceException {
        this.assertValidObject(object, "Create Object in bucket " + bucketName);
        MxDelegate.getInstance().registerStorageObjectPutEvent(bucketName, object.getKey());
        return this.putObjectImpl(bucketName, object);
    }

    public Map<String, Object> copyObject(String sourceBucketName, String sourceObjectKey, String destinationBucketName, StorageObject destinationObject, boolean replaceMetadata, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws ServiceException {
        this.assertAuthenticatedConnection("copyObject");
        Map<String, Object> destinationMetadata = replaceMetadata ? destinationObject.getModifiableMetadata() : null;
        MxDelegate.getInstance().registerStorageObjectCopyEvent(sourceBucketName, sourceObjectKey);
        return this.copyObjectImpl(sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject.getKey(), destinationObject.getAcl(), destinationMetadata, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, null, destinationObject.getStorageClass(), destinationObject.getServerSideEncryptionAlgorithm());
    }

    public Map<String, Object> copyObject(String sourceBucketName, String sourceObjectKey, String destinationBucketName, StorageObject destinationObject, boolean replaceMetadata) throws ServiceException {
        return this.copyObject(sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject, replaceMetadata, null, null, null, null);
    }

    public Map<String, Object> moveObject(String sourceBucketName, String sourceObjectKey, String destinationBucketName, StorageObject destinationObject, boolean replaceMetadata) throws ServiceException {
        Map<String, Object> copyResult = this.copyObject(sourceBucketName, sourceObjectKey, destinationBucketName, destinationObject, replaceMetadata);
        try {
            this.deleteObject(sourceBucketName, sourceObjectKey);
        }
        catch (Exception e) {
            copyResult.put("DeleteException", e);
        }
        return copyResult;
    }

    public Map<String, Object> renameObject(String bucketName, String sourceObjectKey, StorageObject destinationObject) throws ServiceException {
        return this.moveObject(bucketName, sourceObjectKey, bucketName, destinationObject, false);
    }

    public Map<String, Object> updateObjectMetadata(String bucketName, StorageObject object) throws ServiceException {
        return this.copyObject(bucketName, object.getKey(), bucketName, object, true);
    }

    public void deleteObject(String bucketName, String objectKey) throws ServiceException {
        this.assertValidObject(objectKey, "deleteObject");
        MxDelegate.getInstance().registerStorageObjectDeleteEvent(bucketName, objectKey);
        this.deleteObjectImpl(bucketName, objectKey, null, null, null);
    }

    public StorageObject getObjectDetails(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws ServiceException {
        MxDelegate.getInstance().registerStorageObjectHeadEvent(bucketName, objectKey);
        return this.getObjectDetailsImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, null);
    }

    public StorageObject getObject(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws ServiceException {
        MxDelegate.getInstance().registerStorageObjectGetEvent(bucketName, objectKey);
        return this.getObjectImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, null);
    }

    public void putObjectAcl(String bucketName, StorageObject object) throws ServiceException {
        this.assertValidObject(object, "Put Object Access Control List");
        this.putObjectAcl(bucketName, object.getKey(), object.getAcl());
    }

    public void putObjectAcl(String bucketName, String objectKey, AccessControlList acl) throws ServiceException {
        if (acl == null) {
            throw new ServiceException("The object '" + objectKey + "' does not include ACL information");
        }
        this.putObjectAclImpl(bucketName, objectKey, acl, null);
    }

    public AccessControlList getObjectAcl(String bucketName, String objectKey) throws ServiceException {
        return this.getObjectAclImpl(bucketName, objectKey, null);
    }

    public void putBucketAcl(String bucketName, AccessControlList acl) throws ServiceException {
        if (acl == null) {
            throw new ServiceException("The bucket '" + bucketName + "' does not include ACL information");
        }
        this.putBucketAclImpl(bucketName, acl);
    }

    public void putBucketAcl(StorageBucket bucket) throws ServiceException {
        this.assertValidBucket(bucket, "Put Bucket Access Control List");
        this.putBucketAcl(bucket.getName(), bucket.getAcl());
    }

    public AccessControlList getBucketAcl(String bucketName) throws ServiceException {
        return this.getBucketAclImpl(bucketName);
    }

    public Date getCurrentTimeWithOffset() {
        return new Date(System.currentTimeMillis() + this.timeOffset);
    }

    public Map<String, Object> renameMetadataKeys(Map<String, Object> metadata) {
        HashMap<String, Object> convertedMetadata = new HashMap<String, Object>();
        if (metadata != null) {
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!RestUtils.HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase(Locale.getDefault())) && !key.startsWith(this.getRestHeaderPrefix())) {
                    key = this.getRestMetadataPrefix() + key;
                }
                convertedMetadata.put(key, value);
            }
        }
        return convertedMetadata;
    }

    public abstract boolean isBucketAccessible(String var1) throws ServiceException;

    public abstract int checkBucketStatus(String var1) throws ServiceException;

    protected StorageBucket[] listAllBucketsImpl() throws ServiceException {
        return this.listAllBucketsImpl(Collections.<String, Object>emptyMap());
    }

    protected abstract StorageBucket[] listAllBucketsImpl(Map<String, Object> var1) throws ServiceException;

    protected abstract StorageOwner getAccountOwnerImpl() throws ServiceException;

    protected abstract StorageObject[] listObjectsImpl(String var1, String var2, String var3, long var4) throws ServiceException;

    protected abstract StorageObjectsChunk listObjectsChunkedImpl(String var1, String var2, String var3, long var4, String var6, boolean var7) throws ServiceException;

    protected StorageBucket createBucketImpl(String bucketName, String location, AccessControlList acl) throws ServiceException {
        return this.createBucketImpl(bucketName, location, acl, Collections.<String, Object>emptyMap());
    }

    protected abstract StorageBucket createBucketImpl(String var1, String var2, AccessControlList var3, Map<String, Object> var4) throws ServiceException;

    protected abstract void deleteBucketImpl(String var1) throws ServiceException;

    protected abstract StorageObject putObjectImpl(String var1, StorageObject var2) throws ServiceException;

    protected abstract Map<String, Object> copyObjectImpl(String var1, String var2, String var3, String var4, AccessControlList var5, Map<String, Object> var6, Calendar var7, Calendar var8, String[] var9, String[] var10, String var11, String var12, String var13) throws ServiceException;

    protected abstract void deleteObjectImpl(String var1, String var2, String var3, String var4, String var5) throws ServiceException;

    protected abstract StorageObject getObjectDetailsImpl(String var1, String var2, Calendar var3, Calendar var4, String[] var5, String[] var6, String var7) throws ServiceException;

    protected abstract StorageObject getObjectImpl(String var1, String var2, Calendar var3, Calendar var4, String[] var5, String[] var6, Long var7, Long var8, String var9) throws ServiceException;

    protected abstract void putBucketAclImpl(String var1, AccessControlList var2) throws ServiceException;

    protected abstract void putObjectAclImpl(String var1, String var2, AccessControlList var3, String var4) throws ServiceException;

    protected abstract AccessControlList getObjectAclImpl(String var1, String var2, String var3) throws ServiceException;

    protected abstract AccessControlList getBucketAclImpl(String var1) throws ServiceException;

    protected abstract void shutdownImpl() throws ServiceException;

    public abstract String getEndpoint();

    protected abstract String getVirtualPath();

    protected abstract String getSignatureIdentifier();

    public abstract String getRestHeaderPrefix();

    public abstract List<String> getResourceParameterNames();

    public abstract String getRestMetadataPrefix();

    protected abstract int getHttpPort();

    protected abstract int getHttpsPort();

    protected abstract boolean getHttpsOnly();

    protected abstract boolean getDisableDnsBuckets();

    protected abstract boolean getEnableStorageClasses();

    protected abstract boolean getEnableServerSideEncryption();
}

