## Using SQL for Graph Queries

### Joining Vertices and Edges in a Graph with SQL

1. Run the shell to submit the pre-edited demo GQL:

```shell
bin/gql_submit.sh --gql geaflow/geaflow-examples/gql/sql_join_to_graph_demo.sql
```

Here, `sql_join_to_graph_demo.sql` is an SQL Join query in a simulated streaming graph. Its key content is as follows:

```sql
USE GRAPH dy_modern;

select u.name, friend.name
from person u, knows e, person friend
where u.id = e.srcId and e.targetId = friend.id
;
```

This DSL reads node and edge data from the **demo_job_data.txt** resource file within the project to construct the graph.

Then, it performs a join query on nodes and edges of the graph `dy_modern`. The engine automatically translates the join semantics into a graph query.

2. Output Results

You can print the contents of the result file by running the following command:

```shell
cat /tmp/geaflow/sql_join_to_graph_demo_result/partition_0  
```

The query results are written to `/tmp/geaflow/sql_join_to_graph_demo_result` by default. Users can also customize the output path by modifying the `geaflow.dsl.file.path` parameter.

```
jim,jim
kate,kate
lily,lily
lucy,lucy
jim,jim
lucy,lucy
lucy,lucy
jack,jack
``` 

## Using SQL to Perform Join and Aggregate Queries on Graph Vertices and Edges

1. Run the shell to submit the pre-edited demo GQL:

```shell
bin/gql_submit.sh --gql geaflow/geaflow-examples/gql/sql_join_to_graph_demo_02.sql
```

The key content of the `sql_join_to_graph_demo_02.sql` file is as follows:
```sql
USE GRAPH dy_modern;

SELECT    u.name,
          friend_num
FROM      person u,
          (
          SELECT    srcId AS pid,
                    COUNT(DISTINCT targetId) AS friend_num
          FROM      knows
          GROUP BY  srcId
          ) t_friend_num
WHERE     u.id = pid;
```


This DSL reads node and edge data from the **demo_job_data.txt** resource file within the project to construct the graph.

Then, it performs a join query on nodes and edges of the graph `dy_modern`. The engine automatically translates the join semantics into a graph query.

2. Output Results

You can print the contents of the result file by running the following command:

```shell
cat /tmp/geaflow/sql_join_to_graph_demo_02_result/partition_0  
```

The query results are written to `/tmp/geaflow/sql_join_to_graph_demo_02_result` by default. Users can also customize the output path by modifying the `geaflow.dsl.file.path` parameter.

The results show the number of friends recorded for each person in the graph:

```
lucy,2
jim,1
kate,1
lily,1
jack,1
```