/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

export default {
    // 主色调，主要用于各面板背景色
    '--primary-color': '#363b40',
    '--container-bg': '#171819',
    '--component-background': '#171819',
    '--hr-color': '#303030',
  
    // 主要文本颜色
    '--primary-text-color': 'rgba(255, 255, 255, 0.85)',
    // 描述文本颜色
    '--description-text-color': 'rgba(255, 255, 255, 0.45)',
    // shadow 颜色
    '--primary-shadow-color': 'rgba(0, 0, 0, 0.2)',
    // 和主色调搭配的 border 颜色
    '--primary-border-color': 'rgba(47, 47, 47)',
    // Canvas 画布背景色
    '--canvas-bg-color': '#202224',
    '--main-text-color': 'rgba(255, 255, 255, 0.65)',
    // Canvas ToolBar menu 主要颜色，包括透明度
    '--main-canvas-menu-color': 'rgba(54, 59, 64, 0)',
    '--main-canvas-menu-hover-color': 'rgba(54, 59, 64, 1)',
    '--main-canvas-menu-hover-shadow-color': 'rgba(0, 0, 0, 0.6)',
    '--main-contextmenu-bg-color': 'rgba(54, 59, 64, 0.5)',
    // tooltip 背景色
    '--main-toolTip-bg-color': 'rgb(67 ,67 ,67)',
    // input border 颜色
    '--main-input-border-color': 'rgba(67, 67, 67)',
    // menu selected bg color
    '--main-menu-selcected-bg-color': '#272A2D',
    // pre bg & border color
    '--main-pre-bg-color': '#303030',
    '--main-pre-border-color': '#303030',
    // divider border color & table td border color
    '--main-divider-border-color': '#202224',
    // editor bg color & border color
    '--main-editor-bg-color': '#191919',
    '--main-editor-border-color': '#191919',
    // logpanel bg color
    '--main-log-bg-color': '#3c3f41',
    // searchbar placeholder color
    '--main-searchbar-placeholder-color': 'rgba(255, 255, 255, 0.45)',
    // dataview radio border color
    '--main-radio-border-color': '#434343',
    // table
    '--main-table-thead-bg-color': '#43464a',
    // checkbox disabled
    '--main-checkbox-dis-color': 'rgba(255, 255, 255, 0.08)',
    // switch bg color
    '--main-switch-bg-color': 'rgba(255, 255, 255, 0.3)',
    // alert type info bg color
    '--main-alert-info-bg-color': '#111b26',
    // antd menu bg color
    '--main-dropdown-bg-color': '#1f1f1f',
    // slider
    '--main-step-bg-color': '#262626',
    '--main-step-track-color': '#153450',
    // publish
    '--main-publish-bg-color': '#2b2f33',
    '--main-collapse-bg-color': '#3E4347',
  };
  