/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <arrow/util/compression.h>

namespace gluten {

enum CodecBackend { NONE, QAT };

// BUFFER mode will preallocate max compressed buffer, and then compress each buffer to the max compressed buffer
// ROWVECTOR mode will copy the buffers to a big buffer and then compress the big buffer
enum CompressionMode { BUFFER, ROWVECTOR };

std::unique_ptr<arrow::util::Codec> createArrowIpcCodec(
    arrow::Compression::type compressedType,
    CodecBackend codecBackend,
    int32_t compressionLevel = arrow::util::kUseDefaultCompressionLevel);

} // namespace gluten
