# Agentic 工作流规范

本文档面向项目开发者与 AI 助手，定义了一个清晰、高效、迭代的协作框架，帮助双方将模糊的想法转化为经过验证、设计良好并可执行的软件功能。

⚠️ 目前仅规范了**简体中文**版本, 其他语言开发者可以自行翻译使用, 后续会维护 EN 版本, 也欢迎贡献翻译！

⭐️ 本 AI Coding 工作流仍在迭代和实践中，欢迎大家体验使用。这是一个开放且持续演进的工作流，我们非常欢迎并鼓励社区成员将自己的最佳实践和宝贵经验融入其中。如果您有任何改进建议，请通过提交 **Issue** 来发起讨论，或直接通过 **Pull Request** 贡献您的智慧。

## 快速启动(Quick Start)

- 将目录下的[basic.md](./basic.md)移至你使用的 AI Coding System 的 basic / system rule，如 CLAUDE.md, role.mdc(Always Apply), copilot-instructions.md 等

- 将本 README 附给 AI，让他明白工作流流程。每个流程开始前，需要确保已经阅读过相关指导文档。不要让 AI**自动执行流程**，如果出现该情况，需要及时 STOP 并告诉他(可以选择固化为 memory 的方式)

- STEP1~3 模型推荐 Think 类模型(o3, gemini-2.5-pro，Deepseek-R1), STEP4 模型推荐（Claude, gemini-2.5-pro, Kimi-K2, Qwen3-Coder 等）

- 为了保证上下文质量，最佳实践是 STEP4(execute)时新开一个 Chat

- ⭐️ 欢迎维护和补充各模块下的 AGENTS.md, 迭代为面向 AI 的最佳语料和规范

### 开发者阅读指南

> 如果你是使用本 AI Coding 助手的开发者，请注意以下要点：
>
> 1. **共同遵循流程**：本文档中所有对“AI 助手”的要求，都需要开发者配合才能发挥最大效果。请在每个阶段提供及时、明确的反馈与批准。
> 2. **文档驱动协作**：在需求、设计、任务规划和执行各阶段，开发者需要与 AI 共同维护对应的 `.md` 文档，这些文档是双方的唯一信息源。
> 3. **主动沟通**：当你发现需求变化或需调整计划时，立即与 AI 助手沟通，AI 将根据本工作流规范返回到合适的阶段重新迭代。
> 4. **最小可行变更**：遵循奥卡姆剃刀原则，优先重用现有代码和组件，减少不必要的复杂度。
> 5. **风险共担**：在执行任何影响生产的操作前，务必与 AI 助手共同完成风险评估和回滚方案设计。

## 核心原则

- **1. 阶段化推进 (Staged Progression)**: 工作流严格遵循“需求 -> 设计 -> 规划 -> 执行”的顺序。禁止跳过任何阶段，进入每阶段之前， 先检查自己是否主动阅读了相关指导文档，如[`execute.md`](./execute.md)等。

- **2. 明确批准 (Explicit Approval)**: 在每个阶段结束时，AI 助手必须暂停并获得用户的**明确批准**后，才能进入下一阶段。这是建立信任和确保方向正确的关键。

- **3. 调研优先 (Research First)**: **在提出任何设计、计划或代码实现之前，必须优先对现有代码库进行充分的调研。** 主动寻找可复用的组件、模式和配置，遵循奥卡姆剃刀原则，避免不必要地重复劳动。此原则是后续所有阶段的强制前置步骤。

- **4. 迭代循环 (Iterative Loop)**: 工作流并非严格线性。如果在后续阶段（如“规划”或“执行”）发现了足以影响架构决策的新信息，**必须主动暂停并返回到之前的“设计”或“需求”阶段**进行修订，以确保最终方案的质量。

- **5. 文档驱动 (Documentation-Driven)**: 每个阶段的核心产出都是一个明确的 `.md` 文档。这些文档是我们的共识，也是追踪和回溯所有决策的唯一依据。

---

## 工作流阶段

每个阶段都有其独立的、更详细的规范文档。本处仅做高级概述。如果你不清楚，请先阅读目录下的规范文档

### 阶段一：需求收集 (Requirements Gathering)

- **目标**: 准确、完整地定义功能需求。
- **关键产出**: `.workflow/{feature_name}/requirements.md`
- **详情**: 主动阅读并遵循 [`requirements.md`](./requirements.md)
- **禁止**: 不允许直接进入设计阶段

### 阶段二：功能设计 (Functional Design)

- **目标**: 基于已批准的需求，创建详细的技术设计方案。
- **关键产出**: `.workflow/{feature_name}/design.md`
- **详情**: 主动阅读并遵循 [`design.md`](./design.md)
- **禁止**: 不允许直接进入规划阶段

### 阶段三：任务规划 (Task Planning)

- **目标**: 将复杂的设计分解为一系列可执行的、具体的编码任务。
- **关键产出**: `.workflow/{feature_name}/tasks.md`
- **详情**: 主动阅读并遵循 [`plan.md`](./plan.md)
- **禁止**: 不允许直接进入执行阶段

### 阶段四：执行 (Execution)

- **目标**: 逐一完成任务规划阶段定义的编码任务。
- **关键产出**: `.workflow/{feature_name}/logs/` 目录下的执行日志。
- **详情**: 主动阅读并遵循 [`execute.md`](./execute.md)

## 项目规范

每个模块下的 `AGENTS.md`负责介绍各自模块的最核心的结构/概览（面向 AI），统一给 `LLM Coding`
作为指导文档 (./{module_name}/AGENTS.md)

- 命名参考[AGENTS.md](https://agents.md/)，也可重命名为 GEMINI/CLAUDE.md 等

## 测试规范

🚧ing.. (TBD)
