/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.1
// source: metaTask.proto

package metaTask

import (
	reflect "reflect"
	sync "sync"
	metapb "vermeer/apps/protos/hugegraph-pd-grpc/metapb"
	pulse "vermeer/apps/protos/hugegraph-pd-grpc/pulse"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type TaskType int32

const (
	TaskType_Unknown         TaskType = 0
	TaskType_Split_Partition TaskType = 1
	TaskType_Change_Shard    TaskType = 2
	TaskType_Move_Partition  TaskType = 3
	TaskType_Clean_Partition TaskType = 4
	TaskType_Change_KeyRange TaskType = 5
)

// Enum value maps for TaskType.
var (
	TaskType_name = map[int32]string{
		0: "Unknown",
		1: "Split_Partition",
		2: "Change_Shard",
		3: "Move_Partition",
		4: "Clean_Partition",
		5: "Change_KeyRange",
	}
	TaskType_value = map[string]int32{
		"Unknown":         0,
		"Split_Partition": 1,
		"Change_Shard":    2,
		"Move_Partition":  3,
		"Clean_Partition": 4,
		"Change_KeyRange": 5,
	}
)

func (x TaskType) Enum() *TaskType {
	p := new(TaskType)
	*p = x
	return p
}

func (x TaskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskType) Descriptor() protoreflect.EnumDescriptor {
	return file_metaTask_proto_enumTypes[0].Descriptor()
}

func (TaskType) Type() protoreflect.EnumType {
	return &file_metaTask_proto_enumTypes[0]
}

func (x TaskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskType.Descriptor instead.
func (TaskType) EnumDescriptor() ([]byte, []int) {
	return file_metaTask_proto_rawDescGZIP(), []int{0}
}

type TaskState int32

const (
	TaskState_Task_Unknown TaskState = 0
	TaskState_Task_Ready   TaskState = 1 //任务就绪
	TaskState_Task_Doing   TaskState = 2 //执行中
	TaskState_Task_Done    TaskState = 3 //完成
	TaskState_Task_Exit    TaskState = 4 //退出
	TaskState_Task_Stop    TaskState = 10
	TaskState_Task_Success TaskState = 11
	TaskState_Task_Failure TaskState = 12
)

// Enum value maps for TaskState.
var (
	TaskState_name = map[int32]string{
		0:  "Task_Unknown",
		1:  "Task_Ready",
		2:  "Task_Doing",
		3:  "Task_Done",
		4:  "Task_Exit",
		10: "Task_Stop",
		11: "Task_Success",
		12: "Task_Failure",
	}
	TaskState_value = map[string]int32{
		"Task_Unknown": 0,
		"Task_Ready":   1,
		"Task_Doing":   2,
		"Task_Done":    3,
		"Task_Exit":    4,
		"Task_Stop":    10,
		"Task_Success": 11,
		"Task_Failure": 12,
	}
)

func (x TaskState) Enum() *TaskState {
	p := new(TaskState)
	*p = x
	return p
}

func (x TaskState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskState) Descriptor() protoreflect.EnumDescriptor {
	return file_metaTask_proto_enumTypes[1].Descriptor()
}

func (TaskState) Type() protoreflect.EnumType {
	return &file_metaTask_proto_enumTypes[1]
}

func (x TaskState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskState.Descriptor instead.
func (TaskState) EnumDescriptor() ([]byte, []int) {
	return file_metaTask_proto_rawDescGZIP(), []int{1}
}

// 一条任务信息
type Task struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id             uint64            `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Type           TaskType          `protobuf:"varint,2,opt,name=type,proto3,enum=metaTask.TaskType" json:"type,omitempty"`
	State          TaskState         `protobuf:"varint,3,opt,name=state,proto3,enum=metaTask.TaskState" json:"state,omitempty"`
	StartTimestamp int64             `protobuf:"varint,4,opt,name=start_timestamp,json=startTimestamp,proto3" json:"start_timestamp,omitempty"`
	Partition      *metapb.Partition `protobuf:"bytes,5,opt,name=partition,proto3" json:"partition,omitempty"`
	Message        string            `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
	//每个shard执行的任务状态
	ShardState        []*ShardTaskState        `protobuf:"bytes,7,rep,name=shardState,proto3" json:"shardState,omitempty"`
	ChangeShard       *pulse.ChangeShard       `protobuf:"bytes,9,opt,name=changeShard,proto3" json:"changeShard,omitempty"`
	SplitPartition    *pulse.SplitPartition    `protobuf:"bytes,10,opt,name=splitPartition,proto3" json:"splitPartition,omitempty"`
	MovePartition     *pulse.MovePartition     `protobuf:"bytes,11,opt,name=movePartition,proto3" json:"movePartition,omitempty"`
	CleanPartition    *pulse.CleanPartition    `protobuf:"bytes,12,opt,name=cleanPartition,proto3" json:"cleanPartition,omitempty"`
	PartitionKeyRange *pulse.PartitionKeyRange `protobuf:"bytes,13,opt,name=partitionKeyRange,proto3" json:"partitionKeyRange,omitempty"`
}

func (x *Task) Reset() {
	*x = Task{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metaTask_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task) ProtoMessage() {}

func (x *Task) ProtoReflect() protoreflect.Message {
	mi := &file_metaTask_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task.ProtoReflect.Descriptor instead.
func (*Task) Descriptor() ([]byte, []int) {
	return file_metaTask_proto_rawDescGZIP(), []int{0}
}

func (x *Task) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Task) GetType() TaskType {
	if x != nil {
		return x.Type
	}
	return TaskType_Unknown
}

func (x *Task) GetState() TaskState {
	if x != nil {
		return x.State
	}
	return TaskState_Task_Unknown
}

func (x *Task) GetStartTimestamp() int64 {
	if x != nil {
		return x.StartTimestamp
	}
	return 0
}

func (x *Task) GetPartition() *metapb.Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

func (x *Task) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Task) GetShardState() []*ShardTaskState {
	if x != nil {
		return x.ShardState
	}
	return nil
}

func (x *Task) GetChangeShard() *pulse.ChangeShard {
	if x != nil {
		return x.ChangeShard
	}
	return nil
}

func (x *Task) GetSplitPartition() *pulse.SplitPartition {
	if x != nil {
		return x.SplitPartition
	}
	return nil
}

func (x *Task) GetMovePartition() *pulse.MovePartition {
	if x != nil {
		return x.MovePartition
	}
	return nil
}

func (x *Task) GetCleanPartition() *pulse.CleanPartition {
	if x != nil {
		return x.CleanPartition
	}
	return nil
}

func (x *Task) GetPartitionKeyRange() *pulse.PartitionKeyRange {
	if x != nil {
		return x.PartitionKeyRange
	}
	return nil
}

type ShardTaskState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StoreId uint64    `protobuf:"varint,1,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
	State   TaskState `protobuf:"varint,2,opt,name=state,proto3,enum=metaTask.TaskState" json:"state,omitempty"`
}

func (x *ShardTaskState) Reset() {
	*x = ShardTaskState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metaTask_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardTaskState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardTaskState) ProtoMessage() {}

func (x *ShardTaskState) ProtoReflect() protoreflect.Message {
	mi := &file_metaTask_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardTaskState.ProtoReflect.Descriptor instead.
func (*ShardTaskState) Descriptor() ([]byte, []int) {
	return file_metaTask_proto_rawDescGZIP(), []int{1}
}

func (x *ShardTaskState) GetStoreId() uint64 {
	if x != nil {
		return x.StoreId
	}
	return 0
}

func (x *ShardTaskState) GetState() TaskState {
	if x != nil {
		return x.State
	}
	return TaskState_Task_Unknown
}

var File_metaTask_proto protoreflect.FileDescriptor

var file_metaTask_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x54, 0x61, 0x73, 0x6b, 0x1a, 0x0c, 0x6d, 0x65, 0x74, 0x61,
	0x70, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0e, 0x70, 0x64, 0x5f, 0x70, 0x75, 0x6c,
	0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb1, 0x04, 0x0a, 0x04, 0x54, 0x61, 0x73,
	0x6b, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x26, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x29, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x54,
	0x61, 0x73, 0x6b, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2f, 0x0a,
	0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x38, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x54, 0x61, 0x73,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x2e, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x12, 0x37, 0x0a, 0x0e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x73, 0x70, 0x6c,
	0x69, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x0d, 0x6d,
	0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x37, 0x0a, 0x0e, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x43, 0x6c, 0x65, 0x61,
	0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x6c, 0x65, 0x61,
	0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x11, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x56, 0x0a, 0x0e,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x19,
	0x0a, 0x08, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x54,
	0x61, 0x73, 0x6b, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2a, 0x7c, 0x0a, 0x08, 0x54, 0x61, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x10, 0x00, 0x12, 0x13, 0x0a,
	0x0f, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4d, 0x6f, 0x76, 0x65, 0x5f, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x6c, 0x65, 0x61,
	0x6e, 0x5f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x10, 0x04, 0x12, 0x13, 0x0a,
	0x0f, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x4b, 0x65, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x10, 0x05, 0x2a, 0x8e, 0x01, 0x0a, 0x09, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x10, 0x0a, 0x0c, 0x54, 0x61, 0x73, 0x6b, 0x5f, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x61, 0x73, 0x6b, 0x5f, 0x52, 0x65, 0x61, 0x64, 0x79,
	0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x61, 0x73, 0x6b, 0x5f, 0x44, 0x6f, 0x69, 0x6e, 0x67,
	0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x61, 0x73, 0x6b, 0x5f, 0x44, 0x6f, 0x6e, 0x65, 0x10,
	0x03, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x61, 0x73, 0x6b, 0x5f, 0x45, 0x78, 0x69, 0x74, 0x10, 0x04,
	0x12, 0x0d, 0x0a, 0x09, 0x54, 0x61, 0x73, 0x6b, 0x5f, 0x53, 0x74, 0x6f, 0x70, 0x10, 0x0a, 0x12,
	0x10, 0x0a, 0x0c, 0x54, 0x61, 0x73, 0x6b, 0x5f, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x10,
	0x0b, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x61, 0x73, 0x6b, 0x5f, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x10, 0x0c, 0x42, 0x3a, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x61, 0x69, 0x64, 0x75,
	0x2e, 0x68, 0x75, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x70, 0x64, 0x2e, 0x67, 0x72,
	0x70, 0x63, 0x5a, 0x1b, 0x2f, 0x68, 0x75, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2d, 0x70,
	0x64, 0x2d, 0x67, 0x72, 0x70, 0x63, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x54, 0x61, 0x73, 0x6b, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_metaTask_proto_rawDescOnce sync.Once
	file_metaTask_proto_rawDescData = file_metaTask_proto_rawDesc
)

func file_metaTask_proto_rawDescGZIP() []byte {
	file_metaTask_proto_rawDescOnce.Do(func() {
		file_metaTask_proto_rawDescData = protoimpl.X.CompressGZIP(file_metaTask_proto_rawDescData)
	})
	return file_metaTask_proto_rawDescData
}

var file_metaTask_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_metaTask_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_metaTask_proto_goTypes = []interface{}{
	(TaskType)(0),                   // 0: metaTask.TaskType
	(TaskState)(0),                  // 1: metaTask.TaskState
	(*Task)(nil),                    // 2: metaTask.Task
	(*ShardTaskState)(nil),          // 3: metaTask.ShardTaskState
	(*metapb.Partition)(nil),        // 4: metapb.Partition
	(*pulse.ChangeShard)(nil),       // 5: ChangeShard
	(*pulse.SplitPartition)(nil),    // 6: SplitPartition
	(*pulse.MovePartition)(nil),     // 7: MovePartition
	(*pulse.CleanPartition)(nil),    // 8: CleanPartition
	(*pulse.PartitionKeyRange)(nil), // 9: PartitionKeyRange
}
var file_metaTask_proto_depIdxs = []int32{
	0,  // 0: metaTask.Task.type:type_name -> metaTask.TaskType
	1,  // 1: metaTask.Task.state:type_name -> metaTask.TaskState
	4,  // 2: metaTask.Task.partition:type_name -> metapb.Partition
	3,  // 3: metaTask.Task.shardState:type_name -> metaTask.ShardTaskState
	5,  // 4: metaTask.Task.changeShard:type_name -> ChangeShard
	6,  // 5: metaTask.Task.splitPartition:type_name -> SplitPartition
	7,  // 6: metaTask.Task.movePartition:type_name -> MovePartition
	8,  // 7: metaTask.Task.cleanPartition:type_name -> CleanPartition
	9,  // 8: metaTask.Task.partitionKeyRange:type_name -> PartitionKeyRange
	1,  // 9: metaTask.ShardTaskState.state:type_name -> metaTask.TaskState
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_metaTask_proto_init() }
func file_metaTask_proto_init() {
	if File_metaTask_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_metaTask_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metaTask_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardTaskState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_metaTask_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_metaTask_proto_goTypes,
		DependencyIndexes: file_metaTask_proto_depIdxs,
		EnumInfos:         file_metaTask_proto_enumTypes,
		MessageInfos:      file_metaTask_proto_msgTypes,
	}.Build()
	File_metaTask_proto = out.File
	file_metaTask_proto_rawDesc = nil
	file_metaTask_proto_goTypes = nil
	file_metaTask_proto_depIdxs = nil
}
