/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.1
// source: metapb.proto

package metapb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ClusterState int32

const (
	// 集群健康
	ClusterState_Cluster_OK ClusterState = 0
	// 分区警告，存在部分故障节点，短时间不影响读写
	ClusterState_Cluster_Warn ClusterState = 2
	// 分区下线，可以读，无法写
	ClusterState_Cluster_Offline ClusterState = 10
	// 分区故障，无法读写,需要尽快修复故障节点。
	ClusterState_Cluster_Fault     ClusterState = 11
	ClusterState_Cluster_Not_Ready ClusterState = -1
)

// Enum value maps for ClusterState.
var (
	ClusterState_name = map[int32]string{
		0:  "Cluster_OK",
		2:  "Cluster_Warn",
		10: "Cluster_Offline",
		11: "Cluster_Fault",
		-1: "Cluster_Not_Ready",
	}
	ClusterState_value = map[string]int32{
		"Cluster_OK":        0,
		"Cluster_Warn":      2,
		"Cluster_Offline":   10,
		"Cluster_Fault":     11,
		"Cluster_Not_Ready": -1,
	}
)

func (x ClusterState) Enum() *ClusterState {
	p := new(ClusterState)
	*p = x
	return p
}

func (x ClusterState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterState) Descriptor() protoreflect.EnumDescriptor {
	return file_metapb_proto_enumTypes[0].Descriptor()
}

func (ClusterState) Type() protoreflect.EnumType {
	return &file_metapb_proto_enumTypes[0]
}

func (x ClusterState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterState.Descriptor instead.
func (ClusterState) EnumDescriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{0}
}

type StoreState int32

const (
	StoreState_Unknown StoreState = 0
	// 未激活
	StoreState_Pending StoreState = 4
	// 在线
	StoreState_Up StoreState = 1
	// 离线
	StoreState_Offline StoreState = 2
	// 下线中
	StoreState_Exiting StoreState = 5
	// 已下线
	StoreState_Tombstone StoreState = 3
)

// Enum value maps for StoreState.
var (
	StoreState_name = map[int32]string{
		0: "Unknown",
		4: "Pending",
		1: "Up",
		2: "Offline",
		5: "Exiting",
		3: "Tombstone",
	}
	StoreState_value = map[string]int32{
		"Unknown":   0,
		"Pending":   4,
		"Up":        1,
		"Offline":   2,
		"Exiting":   5,
		"Tombstone": 3,
	}
)

func (x StoreState) Enum() *StoreState {
	p := new(StoreState)
	*p = x
	return p
}

func (x StoreState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StoreState) Descriptor() protoreflect.EnumDescriptor {
	return file_metapb_proto_enumTypes[1].Descriptor()
}

func (StoreState) Type() protoreflect.EnumType {
	return &file_metapb_proto_enumTypes[1]
}

func (x StoreState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StoreState.Descriptor instead.
func (StoreState) EnumDescriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{1}
}

type ShardRole int32

const (
	ShardRole_None     ShardRole = 0
	ShardRole_Leader   ShardRole = 1
	ShardRole_Follower ShardRole = 2
	// Learner/None -> Learner
	ShardRole_Learner ShardRole = 3
)

// Enum value maps for ShardRole.
var (
	ShardRole_name = map[int32]string{
		0: "None",
		1: "Leader",
		2: "Follower",
		3: "Learner",
	}
	ShardRole_value = map[string]int32{
		"None":     0,
		"Leader":   1,
		"Follower": 2,
		"Learner":  3,
	}
)

func (x ShardRole) Enum() *ShardRole {
	p := new(ShardRole)
	*p = x
	return p
}

func (x ShardRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShardRole) Descriptor() protoreflect.EnumDescriptor {
	return file_metapb_proto_enumTypes[2].Descriptor()
}

func (ShardRole) Type() protoreflect.EnumType {
	return &file_metapb_proto_enumTypes[2]
}

func (x ShardRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ShardRole.Descriptor instead.
func (ShardRole) EnumDescriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{2}
}

// 分区工作状态
type PartitionState int32

const (
	PartitionState_PState_None PartitionState = 0
	//
	PartitionState_PState_Normal PartitionState = 1
	// 分区警告，存在部分故障节点，短时间不影响读写
	PartitionState_PState_Warn PartitionState = 2
	// 分区下线，可以读，无法写
	PartitionState_PState_Offline PartitionState = 10
	// 分区故障，无法读写,需要尽快修复故障节点。
	PartitionState_PState_Fault PartitionState = 11
)

// Enum value maps for PartitionState.
var (
	PartitionState_name = map[int32]string{
		0:  "PState_None",
		1:  "PState_Normal",
		2:  "PState_Warn",
		10: "PState_Offline",
		11: "PState_Fault",
	}
	PartitionState_value = map[string]int32{
		"PState_None":    0,
		"PState_Normal":  1,
		"PState_Warn":    2,
		"PState_Offline": 10,
		"PState_Fault":   11,
	}
)

func (x PartitionState) Enum() *PartitionState {
	p := new(PartitionState)
	*p = x
	return p
}

func (x PartitionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartitionState) Descriptor() protoreflect.EnumDescriptor {
	return file_metapb_proto_enumTypes[3].Descriptor()
}

func (PartitionState) Type() protoreflect.EnumType {
	return &file_metapb_proto_enumTypes[3]
}

func (x PartitionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartitionState.Descriptor instead.
func (PartitionState) EnumDescriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{3}
}

type ShardState int32

const (
	ShardState_SState_None ShardState = 0
	// 正常
	ShardState_SState_Normal ShardState = 1
	// 安装快照
	ShardState_SState_Snapshot ShardState = 2
	// 离线
	ShardState_SState_Offline ShardState = 10
)

// Enum value maps for ShardState.
var (
	ShardState_name = map[int32]string{
		0:  "SState_None",
		1:  "SState_Normal",
		2:  "SState_Snapshot",
		10: "SState_Offline",
	}
	ShardState_value = map[string]int32{
		"SState_None":     0,
		"SState_Normal":   1,
		"SState_Snapshot": 2,
		"SState_Offline":  10,
	}
)

func (x ShardState) Enum() *ShardState {
	p := new(ShardState)
	*p = x
	return p
}

func (x ShardState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShardState) Descriptor() protoreflect.EnumDescriptor {
	return file_metapb_proto_enumTypes[4].Descriptor()
}

func (ShardState) Type() protoreflect.EnumType {
	return &file_metapb_proto_enumTypes[4]
}

func (x ShardState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ShardState.Descriptor instead.
func (ShardState) EnumDescriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{4}
}

type GraphMode int32

const (
	GraphMode_ReadWrite GraphMode = 0
	GraphMode_ReadOnly  GraphMode = 1
	GraphMode_WriteOnly GraphMode = 2
)

// Enum value maps for GraphMode.
var (
	GraphMode_name = map[int32]string{
		0: "ReadWrite",
		1: "ReadOnly",
		2: "WriteOnly",
	}
	GraphMode_value = map[string]int32{
		"ReadWrite": 0,
		"ReadOnly":  1,
		"WriteOnly": 2,
	}
)

func (x GraphMode) Enum() *GraphMode {
	p := new(GraphMode)
	*p = x
	return p
}

func (x GraphMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GraphMode) Descriptor() protoreflect.EnumDescriptor {
	return file_metapb_proto_enumTypes[5].Descriptor()
}

func (GraphMode) Type() protoreflect.EnumType {
	return &file_metapb_proto_enumTypes[5]
}

func (x GraphMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GraphMode.Descriptor instead.
func (GraphMode) EnumDescriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{5}
}

type GraphModeReason int32

const (
	GraphModeReason_Empty      GraphModeReason = 0 // 空
	GraphModeReason_Initiative GraphModeReason = 1 // 主动的状态设置
	GraphModeReason_Quota      GraphModeReason = 2 // 达到限额条件
)

// Enum value maps for GraphModeReason.
var (
	GraphModeReason_name = map[int32]string{
		0: "Empty",
		1: "Initiative",
		2: "Quota",
	}
	GraphModeReason_value = map[string]int32{
		"Empty":      0,
		"Initiative": 1,
		"Quota":      2,
	}
)

func (x GraphModeReason) Enum() *GraphModeReason {
	p := new(GraphModeReason)
	*p = x
	return p
}

func (x GraphModeReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GraphModeReason) Descriptor() protoreflect.EnumDescriptor {
	return file_metapb_proto_enumTypes[6].Descriptor()
}

func (GraphModeReason) Type() protoreflect.EnumType {
	return &file_metapb_proto_enumTypes[6]
}

func (x GraphModeReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GraphModeReason.Descriptor instead.
func (GraphModeReason) EnumDescriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{6}
}

// 集群状态
type ClusterStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	State     ClusterState `protobuf:"varint,1,opt,name=state,proto3,enum=metapb.ClusterState" json:"state,omitempty"`
	Message   string       `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	Timestamp uint64       `protobuf:"varint,16,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *ClusterStats) Reset() {
	*x = ClusterStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterStats) ProtoMessage() {}

func (x *ClusterStats) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterStats.ProtoReflect.Descriptor instead.
func (*ClusterStats) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{0}
}

func (x *ClusterStats) GetState() ClusterState {
	if x != nil {
		return x.State
	}
	return ClusterState_Cluster_OK
}

func (x *ClusterStats) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ClusterStats) GetTimestamp() uint64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

// Store label for Storage grouping.
type StoreLabel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *StoreLabel) Reset() {
	*x = StoreLabel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreLabel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreLabel) ProtoMessage() {}

func (x *StoreLabel) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreLabel.ProtoReflect.Descriptor instead.
func (*StoreLabel) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{1}
}

func (x *StoreLabel) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *StoreLabel) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type Store struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Address to handle client requests
	Address     string        `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	RaftAddress string        `protobuf:"bytes,3,opt,name=raft_address,json=raftAddress,proto3" json:"raft_address,omitempty"`
	Labels      []*StoreLabel `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty"`
	// Store软件版本号
	Version string     `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
	State   StoreState `protobuf:"varint,6,opt,name=state,proto3,enum=metapb.StoreState" json:"state,omitempty"`
	// The start timestamp of the current store
	StartTimestamp int64  `protobuf:"varint,7,opt,name=start_timestamp,json=startTimestamp,proto3" json:"start_timestamp,omitempty"`
	DeployPath     string `protobuf:"bytes,8,opt,name=deploy_path,json=deployPath,proto3" json:"deploy_path,omitempty"`
	// The last heartbeat timestamp of the store.
	LastHeartbeat int64       `protobuf:"varint,9,opt,name=last_heartbeat,json=lastHeartbeat,proto3" json:"last_heartbeat,omitempty"`
	Stats         *StoreStats `protobuf:"bytes,10,opt,name=stats,proto3" json:"stats,omitempty"`
	// 数据格式版本号
	DataVersion int32  `protobuf:"varint,11,opt,name=data_version,json=dataVersion,proto3" json:"data_version,omitempty"`
	Cores       int32  `protobuf:"varint,12,opt,name=cores,proto3" json:"cores,omitempty"`
	DataPath    string `protobuf:"bytes,13,opt,name=data_path,json=dataPath,proto3" json:"data_path,omitempty"`
}

func (x *Store) Reset() {
	*x = Store{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Store) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Store) ProtoMessage() {}

func (x *Store) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Store.ProtoReflect.Descriptor instead.
func (*Store) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{2}
}

func (x *Store) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Store) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Store) GetRaftAddress() string {
	if x != nil {
		return x.RaftAddress
	}
	return ""
}

func (x *Store) GetLabels() []*StoreLabel {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Store) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Store) GetState() StoreState {
	if x != nil {
		return x.State
	}
	return StoreState_Unknown
}

func (x *Store) GetStartTimestamp() int64 {
	if x != nil {
		return x.StartTimestamp
	}
	return 0
}

func (x *Store) GetDeployPath() string {
	if x != nil {
		return x.DeployPath
	}
	return ""
}

func (x *Store) GetLastHeartbeat() int64 {
	if x != nil {
		return x.LastHeartbeat
	}
	return 0
}

func (x *Store) GetStats() *StoreStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *Store) GetDataVersion() int32 {
	if x != nil {
		return x.DataVersion
	}
	return 0
}

func (x *Store) GetCores() int32 {
	if x != nil {
		return x.Cores
	}
	return 0
}

func (x *Store) GetDataPath() string {
	if x != nil {
		return x.DataPath
	}
	return ""
}

type Shard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StoreId uint64    `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
	Role    ShardRole `protobuf:"varint,3,opt,name=role,proto3,enum=metapb.ShardRole" json:"role,omitempty"`
}

func (x *Shard) Reset() {
	*x = Shard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard) ProtoMessage() {}

func (x *Shard) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard.ProtoReflect.Descriptor instead.
func (*Shard) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{3}
}

func (x *Shard) GetStoreId() uint64 {
	if x != nil {
		return x.StoreId
	}
	return 0
}

func (x *Shard) GetRole() ShardRole {
	if x != nil {
		return x.Role
	}
	return ShardRole_None
}

type ShardGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id      uint32         `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Version uint64         `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	ConfVer uint64         `protobuf:"varint,3,opt,name=conf_ver,json=confVer,proto3" json:"conf_ver,omitempty"`
	Shards  []*Shard       `protobuf:"bytes,6,rep,name=shards,proto3" json:"shards,omitempty"`
	State   PartitionState `protobuf:"varint,10,opt,name=state,proto3,enum=metapb.PartitionState" json:"state,omitempty"`
	Message string         `protobuf:"bytes,11,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *ShardGroup) Reset() {
	*x = ShardGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardGroup) ProtoMessage() {}

func (x *ShardGroup) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardGroup.ProtoReflect.Descriptor instead.
func (*ShardGroup) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{4}
}

func (x *ShardGroup) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ShardGroup) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ShardGroup) GetConfVer() uint64 {
	if x != nil {
		return x.ConfVer
	}
	return 0
}

func (x *ShardGroup) GetShards() []*Shard {
	if x != nil {
		return x.Shards
	}
	return nil
}

func (x *ShardGroup) GetState() PartitionState {
	if x != nil {
		return x.State
	}
	return PartitionState_PState_None
}

func (x *ShardGroup) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type Graph struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GraphName string `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	// 分区数量，0表示无效，不能大于raft分组总数
	PartitionCount int32 `protobuf:"varint,3,opt,name=partition_count,json=partitionCount,proto3" json:"partition_count,omitempty"`
	// 当前工作状态
	State      PartitionState `protobuf:"varint,10,opt,name=state,proto3,enum=metapb.PartitionState" json:"state,omitempty"`
	Message    string         `protobuf:"bytes,11,opt,name=message,proto3" json:"message,omitempty"`
	GraphState *GraphState    `protobuf:"bytes,12,opt,name=graph_state,json=graphState,proto3" json:"graph_state,omitempty"`
}

func (x *Graph) Reset() {
	*x = Graph{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Graph) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Graph) ProtoMessage() {}

func (x *Graph) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Graph.ProtoReflect.Descriptor instead.
func (*Graph) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{5}
}

func (x *Graph) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *Graph) GetPartitionCount() int32 {
	if x != nil {
		return x.PartitionCount
	}
	return 0
}

func (x *Graph) GetState() PartitionState {
	if x != nil {
		return x.State
	}
	return PartitionState_PState_None
}

func (x *Graph) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Graph) GetGraphState() *GraphState {
	if x != nil {
		return x.GraphState
	}
	return nil
}

type PartitionV36 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id        uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	GraphName string `protobuf:"bytes,3,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	// 分区范围 [start_key, end_key).
	StartKey uint64   `protobuf:"varint,4,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   uint64   `protobuf:"varint,5,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	Shards   []*Shard `protobuf:"bytes,6,rep,name=shards,proto3" json:"shards,omitempty"`
	// Leader任期，leader切换后递增
	Version uint64 `protobuf:"varint,7,opt,name=version,proto3" json:"version,omitempty"`
	// shards版本号，每次改变后递增
	ConfVer uint64 `protobuf:"varint,8,opt,name=conf_ver,json=confVer,proto3" json:"conf_ver,omitempty"`
	// 当前工作状态
	State   PartitionState `protobuf:"varint,10,opt,name=state,proto3,enum=metapb.PartitionState" json:"state,omitempty"`
	Message string         `protobuf:"bytes,11,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *PartitionV36) Reset() {
	*x = PartitionV36{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionV36) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionV36) ProtoMessage() {}

func (x *PartitionV36) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionV36.ProtoReflect.Descriptor instead.
func (*PartitionV36) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{6}
}

func (x *PartitionV36) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *PartitionV36) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *PartitionV36) GetStartKey() uint64 {
	if x != nil {
		return x.StartKey
	}
	return 0
}

func (x *PartitionV36) GetEndKey() uint64 {
	if x != nil {
		return x.EndKey
	}
	return 0
}

func (x *PartitionV36) GetShards() []*Shard {
	if x != nil {
		return x.Shards
	}
	return nil
}

func (x *PartitionV36) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *PartitionV36) GetConfVer() uint64 {
	if x != nil {
		return x.ConfVer
	}
	return 0
}

func (x *PartitionV36) GetState() PartitionState {
	if x != nil {
		return x.State
	}
	return PartitionState_PState_None
}

func (x *PartitionV36) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type Partition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id        uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	GraphName string `protobuf:"bytes,3,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	// 分区范围 [start_key, end_key).
	StartKey uint64 `protobuf:"varint,4,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   uint64 `protobuf:"varint,5,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	// Partition 对象不在保存 shard list（根据对应的shard group 去查询), version 和 conf version不再有实际的意义
	// repeated Shard shards = 6;
	// key range 每次改变后递增
	Version uint64 `protobuf:"varint,7,opt,name=version,proto3" json:"version,omitempty"`
	// shards版本号，每次改变后递增
	// uint64 conf_ver = 8;
	// 当前工作状态
	State   PartitionState `protobuf:"varint,10,opt,name=state,proto3,enum=metapb.PartitionState" json:"state,omitempty"`
	Message string         `protobuf:"bytes,11,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *Partition) Reset() {
	*x = Partition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition) ProtoMessage() {}

func (x *Partition) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition.ProtoReflect.Descriptor instead.
func (*Partition) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{7}
}

func (x *Partition) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Partition) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *Partition) GetStartKey() uint64 {
	if x != nil {
		return x.StartKey
	}
	return 0
}

func (x *Partition) GetEndKey() uint64 {
	if x != nil {
		return x.EndKey
	}
	return 0
}

func (x *Partition) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Partition) GetState() PartitionState {
	if x != nil {
		return x.State
	}
	return PartitionState_PState_None
}

func (x *Partition) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type PartitionShard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Partition *Partition `protobuf:"bytes,1,opt,name=partition,proto3" json:"partition,omitempty"`
	Leader    *Shard     `protobuf:"bytes,2,opt,name=leader,proto3" json:"leader,omitempty"`
	// 离线的Shard
	OfflineShards []*Shard `protobuf:"bytes,3,rep,name=offline_shards,json=offlineShards,proto3" json:"offline_shards,omitempty"`
}

func (x *PartitionShard) Reset() {
	*x = PartitionShard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionShard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionShard) ProtoMessage() {}

func (x *PartitionShard) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionShard.ProtoReflect.Descriptor instead.
func (*PartitionShard) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{8}
}

func (x *PartitionShard) GetPartition() *Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

func (x *PartitionShard) GetLeader() *Shard {
	if x != nil {
		return x.Leader
	}
	return nil
}

func (x *PartitionShard) GetOfflineShards() []*Shard {
	if x != nil {
		return x.OfflineShards
	}
	return nil
}

// 记录分区所在的存储位置
type PartitionStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PartitionId uint32 `protobuf:"varint,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	GraphName   string `protobuf:"bytes,3,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	// 存储位置
	StoreLocation string `protobuf:"bytes,4,opt,name=store_location,json=storeLocation,proto3" json:"store_location,omitempty"`
}

func (x *PartitionStore) Reset() {
	*x = PartitionStore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionStore) ProtoMessage() {}

func (x *PartitionStore) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionStore.ProtoReflect.Descriptor instead.
func (*PartitionStore) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{9}
}

func (x *PartitionStore) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *PartitionStore) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *PartitionStore) GetStoreLocation() string {
	if x != nil {
		return x.StoreLocation
	}
	return ""
}

type PartitionRaft struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PartitionId uint32 `protobuf:"varint,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	GraphName   string `protobuf:"bytes,3,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	// 存储位置
	RaftLocation string `protobuf:"bytes,4,opt,name=raft_location,json=raftLocation,proto3" json:"raft_location,omitempty"`
}

func (x *PartitionRaft) Reset() {
	*x = PartitionRaft{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionRaft) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionRaft) ProtoMessage() {}

func (x *PartitionRaft) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionRaft.ProtoReflect.Descriptor instead.
func (*PartitionRaft) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{10}
}

func (x *PartitionRaft) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *PartitionRaft) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *PartitionRaft) GetRaftLocation() string {
	if x != nil {
		return x.RaftLocation
	}
	return ""
}

type ShardStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StoreId uint64     `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
	Role    ShardRole  `protobuf:"varint,3,opt,name=role,proto3,enum=metapb.ShardRole" json:"role,omitempty"`
	State   ShardState `protobuf:"varint,4,opt,name=state,proto3,enum=metapb.ShardState" json:"state,omitempty"`
	// 安装快照的进度
	Progress uint32 `protobuf:"varint,5,opt,name=progress,proto3" json:"progress,omitempty"`
}

func (x *ShardStats) Reset() {
	*x = ShardStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShardStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardStats) ProtoMessage() {}

func (x *ShardStats) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardStats.ProtoReflect.Descriptor instead.
func (*ShardStats) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{11}
}

func (x *ShardStats) GetStoreId() uint64 {
	if x != nil {
		return x.StoreId
	}
	return 0
}

func (x *ShardStats) GetRole() ShardRole {
	if x != nil {
		return x.Role
	}
	return ShardRole_None
}

func (x *ShardStats) GetState() ShardState {
	if x != nil {
		return x.State
	}
	return ShardState_SState_None
}

func (x *ShardStats) GetProgress() uint32 {
	if x != nil {
		return x.Progress
	}
	return 0
}

type PartitionStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// raft分组的任期.
	LeaderTerm uint64   `protobuf:"varint,2,opt,name=leader_term,json=leaderTerm,proto3" json:"leader_term,omitempty"`
	GraphName  []string `protobuf:"bytes,3,rep,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	Leader     *Shard   `protobuf:"bytes,4,opt,name=leader,proto3" json:"leader,omitempty"`
	// 离线 shards
	Shard   []*Shard `protobuf:"bytes,5,rep,name=shard,proto3" json:"shard,omitempty"`
	Learner []*Shard `protobuf:"bytes,6,rep,name=learner,proto3" json:"learner,omitempty"`
	ConfVer uint64   `protobuf:"varint,7,opt,name=conf_ver,json=confVer,proto3" json:"conf_ver,omitempty"`
	// 分区状态
	State      PartitionState `protobuf:"varint,8,opt,name=state,proto3,enum=metapb.PartitionState" json:"state,omitempty"`
	ShardStats []*ShardStats  `protobuf:"bytes,9,rep,name=shardStats,proto3" json:"shardStats,omitempty"`
	// 分区近似大小
	ApproximateSize uint64 `protobuf:"varint,10,opt,name=approximate_size,json=approximateSize,proto3" json:"approximate_size,omitempty"`
	// 分区key的近似数量
	ApproximateKeys uint64 `protobuf:"varint,13,opt,name=approximate_keys,json=approximateKeys,proto3" json:"approximate_keys,omitempty"`
	// heartbeat timestamp
	Timestamp int64 `protobuf:"varint,16,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *PartitionStats) Reset() {
	*x = PartitionStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionStats) ProtoMessage() {}

func (x *PartitionStats) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionStats.ProtoReflect.Descriptor instead.
func (*PartitionStats) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{12}
}

func (x *PartitionStats) GetId() uint32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *PartitionStats) GetLeaderTerm() uint64 {
	if x != nil {
		return x.LeaderTerm
	}
	return 0
}

func (x *PartitionStats) GetGraphName() []string {
	if x != nil {
		return x.GraphName
	}
	return nil
}

func (x *PartitionStats) GetLeader() *Shard {
	if x != nil {
		return x.Leader
	}
	return nil
}

func (x *PartitionStats) GetShard() []*Shard {
	if x != nil {
		return x.Shard
	}
	return nil
}

func (x *PartitionStats) GetLearner() []*Shard {
	if x != nil {
		return x.Learner
	}
	return nil
}

func (x *PartitionStats) GetConfVer() uint64 {
	if x != nil {
		return x.ConfVer
	}
	return 0
}

func (x *PartitionStats) GetState() PartitionState {
	if x != nil {
		return x.State
	}
	return PartitionState_PState_None
}

func (x *PartitionStats) GetShardStats() []*ShardStats {
	if x != nil {
		return x.ShardStats
	}
	return nil
}

func (x *PartitionStats) GetApproximateSize() uint64 {
	if x != nil {
		return x.ApproximateSize
	}
	return 0
}

func (x *PartitionStats) GetApproximateKeys() uint64 {
	if x != nil {
		return x.ApproximateKeys
	}
	return 0
}

func (x *PartitionStats) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type GraphStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// 图名
	GraphName string `protobuf:"bytes,1,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	// 分区近似大小
	ApproximateSize uint64 `protobuf:"varint,2,opt,name=approximate_size,json=approximateSize,proto3" json:"approximate_size,omitempty"`
	// 分区key的近似数量
	ApproximateKeys uint64 `protobuf:"varint,3,opt,name=approximate_keys,json=approximateKeys,proto3" json:"approximate_keys,omitempty"`
	//  // committed index
	//  uint64 committed_index = 4;
	PartitionId uint32    `protobuf:"varint,5,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	Role        ShardRole `protobuf:"varint,6,opt,name=role,proto3,enum=metapb.ShardRole" json:"role,omitempty"`
	// 当前工作状态
	WorkState PartitionState `protobuf:"varint,8,opt,name=work_state,json=workState,proto3,enum=metapb.PartitionState" json:"work_state,omitempty"`
}

func (x *GraphStats) Reset() {
	*x = GraphStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GraphStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GraphStats) ProtoMessage() {}

func (x *GraphStats) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GraphStats.ProtoReflect.Descriptor instead.
func (*GraphStats) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{13}
}

func (x *GraphStats) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *GraphStats) GetApproximateSize() uint64 {
	if x != nil {
		return x.ApproximateSize
	}
	return 0
}

func (x *GraphStats) GetApproximateKeys() uint64 {
	if x != nil {
		return x.ApproximateKeys
	}
	return 0
}

func (x *GraphStats) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *GraphStats) GetRole() ShardRole {
	if x != nil {
		return x.Role
	}
	return ShardRole_None
}

func (x *GraphStats) GetWorkState() PartitionState {
	if x != nil {
		return x.WorkState
	}
	return PartitionState_PState_None
}

type RaftStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// partition id
	PartitionId uint32 `protobuf:"varint,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// committed index
	CommittedIndex uint64 `protobuf:"varint,2,opt,name=committed_index,json=committedIndex,proto3" json:"committed_index,omitempty"`
}

func (x *RaftStats) Reset() {
	*x = RaftStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RaftStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaftStats) ProtoMessage() {}

func (x *RaftStats) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaftStats.ProtoReflect.Descriptor instead.
func (*RaftStats) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{14}
}

func (x *RaftStats) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *RaftStats) GetCommittedIndex() uint64 {
	if x != nil {
		return x.CommittedIndex
	}
	return 0
}

type TimeInterval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unix timestamp in seconds of the start of this period.
	StartTimestamp uint64 `protobuf:"varint,1,opt,name=start_timestamp,json=startTimestamp,proto3" json:"start_timestamp,omitempty"`
	// The unix timestamp in seconds of the end of this period.
	EndTimestamp uint64 `protobuf:"varint,2,opt,name=end_timestamp,json=endTimestamp,proto3" json:"end_timestamp,omitempty"`
}

func (x *TimeInterval) Reset() {
	*x = TimeInterval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeInterval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeInterval) ProtoMessage() {}

func (x *TimeInterval) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeInterval.ProtoReflect.Descriptor instead.
func (*TimeInterval) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{15}
}

func (x *TimeInterval) GetStartTimestamp() uint64 {
	if x != nil {
		return x.StartTimestamp
	}
	return 0
}

func (x *TimeInterval) GetEndTimestamp() uint64 {
	if x != nil {
		return x.EndTimestamp
	}
	return 0
}

type RecordPair struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value uint64 `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *RecordPair) Reset() {
	*x = RecordPair{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecordPair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecordPair) ProtoMessage() {}

func (x *RecordPair) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecordPair.ProtoReflect.Descriptor instead.
func (*RecordPair) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{16}
}

func (x *RecordPair) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *RecordPair) GetValue() uint64 {
	if x != nil {
		return x.Value
	}
	return 0
}

type QueryStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	GC          uint64 `protobuf:"varint,1,opt,name=GC,proto3" json:"GC,omitempty"`
	Get         uint64 `protobuf:"varint,2,opt,name=Get,proto3" json:"Get,omitempty"`
	Scan        uint64 `protobuf:"varint,3,opt,name=Scan,proto3" json:"Scan,omitempty"`
	Coprocessor uint64 `protobuf:"varint,4,opt,name=Coprocessor,proto3" json:"Coprocessor,omitempty"`
	Delete      uint64 `protobuf:"varint,5,opt,name=Delete,proto3" json:"Delete,omitempty"`
	DeleteRange uint64 `protobuf:"varint,6,opt,name=DeleteRange,proto3" json:"DeleteRange,omitempty"`
	Put         uint64 `protobuf:"varint,7,opt,name=Put,proto3" json:"Put,omitempty"`
}

func (x *QueryStats) Reset() {
	*x = QueryStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryStats) ProtoMessage() {}

func (x *QueryStats) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryStats.ProtoReflect.Descriptor instead.
func (*QueryStats) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{17}
}

func (x *QueryStats) GetGC() uint64 {
	if x != nil {
		return x.GC
	}
	return 0
}

func (x *QueryStats) GetGet() uint64 {
	if x != nil {
		return x.Get
	}
	return 0
}

func (x *QueryStats) GetScan() uint64 {
	if x != nil {
		return x.Scan
	}
	return 0
}

func (x *QueryStats) GetCoprocessor() uint64 {
	if x != nil {
		return x.Coprocessor
	}
	return 0
}

func (x *QueryStats) GetDelete() uint64 {
	if x != nil {
		return x.Delete
	}
	return 0
}

func (x *QueryStats) GetDeleteRange() uint64 {
	if x != nil {
		return x.DeleteRange
	}
	return 0
}

func (x *QueryStats) GetPut() uint64 {
	if x != nil {
		return x.Put
	}
	return 0
}

type StoreStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StoreId uint64 `protobuf:"varint,1,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
	// Capacity for the store.
	Capacity uint64 `protobuf:"varint,2,opt,name=capacity,proto3" json:"capacity,omitempty"`
	// Available size for the store.
	Available uint64 `protobuf:"varint,3,opt,name=available,proto3" json:"available,omitempty"`
	// Total partition count in this store.
	PartitionCount uint32 `protobuf:"varint,4,opt,name=partition_count,json=partitionCount,proto3" json:"partition_count,omitempty"`
	// Current sending snapshot count.
	SendingSnapCount uint32 `protobuf:"varint,5,opt,name=sending_snap_count,json=sendingSnapCount,proto3" json:"sending_snap_count,omitempty"`
	// Current receiving snapshot count.
	ReceivingSnapCount uint32 `protobuf:"varint,6,opt,name=receiving_snap_count,json=receivingSnapCount,proto3" json:"receiving_snap_count,omitempty"`
	// When the store is started (unix timestamp in seconds).
	StartTime uint32 `protobuf:"varint,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// How many partition is applying snapshot.
	ApplyingSnapCount uint32 `protobuf:"varint,8,opt,name=applying_snap_count,json=applyingSnapCount,proto3" json:"applying_snap_count,omitempty"`
	// If the store is busy
	IsBusy bool `protobuf:"varint,9,opt,name=is_busy,json=isBusy,proto3" json:"is_busy,omitempty"`
	// Actually used space by db
	UsedSize uint64 `protobuf:"varint,10,opt,name=used_size,json=usedSize,proto3" json:"used_size,omitempty"`
	// Bytes written for the store during this period.
	BytesWritten uint64 `protobuf:"varint,11,opt,name=bytes_written,json=bytesWritten,proto3" json:"bytes_written,omitempty"`
	// Keys written for the store during this period.
	KeysWritten uint64 `protobuf:"varint,12,opt,name=keys_written,json=keysWritten,proto3" json:"keys_written,omitempty"`
	// Bytes read for the store during this period.
	BytesRead uint64 `protobuf:"varint,13,opt,name=bytes_read,json=bytesRead,proto3" json:"bytes_read,omitempty"`
	// Keys read for the store during this period.
	KeysRead uint64 `protobuf:"varint,14,opt,name=keys_read,json=keysRead,proto3" json:"keys_read,omitempty"`
	// Actually reported time interval
	Interval *TimeInterval `protobuf:"bytes,15,opt,name=interval,proto3" json:"interval,omitempty"`
	// Threads' CPU usages in the store
	CpuUsages []*RecordPair `protobuf:"bytes,16,rep,name=cpu_usages,json=cpuUsages,proto3" json:"cpu_usages,omitempty"`
	// Threads' read disk I/O rates in the store
	ReadIoRates []*RecordPair `protobuf:"bytes,17,rep,name=read_io_rates,json=readIoRates,proto3" json:"read_io_rates,omitempty"`
	// Threads' write disk I/O rates in the store
	WriteIoRates []*RecordPair `protobuf:"bytes,18,rep,name=write_io_rates,json=writeIoRates,proto3" json:"write_io_rates,omitempty"`
	// Operations' latencies in the store
	OpLatencies []*RecordPair `protobuf:"bytes,19,rep,name=op_latencies,json=opLatencies,proto3" json:"op_latencies,omitempty"`
	// Store query stats
	QueryStats *QueryStats `protobuf:"bytes,21,opt,name=query_stats,json=queryStats,proto3" json:"query_stats,omitempty"`
	// graph stats
	GraphStats []*GraphStats `protobuf:"bytes,22,rep,name=graph_stats,json=graphStats,proto3" json:"graph_stats,omitempty"`
	// raft stats
	RaftStats []*RaftStats `protobuf:"bytes,23,rep,name=raft_stats,json=raftStats,proto3" json:"raft_stats,omitempty"`
	Cores     int32        `protobuf:"varint,24,opt,name=cores,proto3" json:"cores,omitempty"`
	// system metrics
	SystemMetrics []*RecordPair `protobuf:"bytes,25,rep,name=system_metrics,json=systemMetrics,proto3" json:"system_metrics,omitempty"`
}

func (x *StoreStats) Reset() {
	*x = StoreStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreStats) ProtoMessage() {}

func (x *StoreStats) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreStats.ProtoReflect.Descriptor instead.
func (*StoreStats) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{18}
}

func (x *StoreStats) GetStoreId() uint64 {
	if x != nil {
		return x.StoreId
	}
	return 0
}

func (x *StoreStats) GetCapacity() uint64 {
	if x != nil {
		return x.Capacity
	}
	return 0
}

func (x *StoreStats) GetAvailable() uint64 {
	if x != nil {
		return x.Available
	}
	return 0
}

func (x *StoreStats) GetPartitionCount() uint32 {
	if x != nil {
		return x.PartitionCount
	}
	return 0
}

func (x *StoreStats) GetSendingSnapCount() uint32 {
	if x != nil {
		return x.SendingSnapCount
	}
	return 0
}

func (x *StoreStats) GetReceivingSnapCount() uint32 {
	if x != nil {
		return x.ReceivingSnapCount
	}
	return 0
}

func (x *StoreStats) GetStartTime() uint32 {
	if x != nil {
		return x.StartTime
	}
	return 0
}

func (x *StoreStats) GetApplyingSnapCount() uint32 {
	if x != nil {
		return x.ApplyingSnapCount
	}
	return 0
}

func (x *StoreStats) GetIsBusy() bool {
	if x != nil {
		return x.IsBusy
	}
	return false
}

func (x *StoreStats) GetUsedSize() uint64 {
	if x != nil {
		return x.UsedSize
	}
	return 0
}

func (x *StoreStats) GetBytesWritten() uint64 {
	if x != nil {
		return x.BytesWritten
	}
	return 0
}

func (x *StoreStats) GetKeysWritten() uint64 {
	if x != nil {
		return x.KeysWritten
	}
	return 0
}

func (x *StoreStats) GetBytesRead() uint64 {
	if x != nil {
		return x.BytesRead
	}
	return 0
}

func (x *StoreStats) GetKeysRead() uint64 {
	if x != nil {
		return x.KeysRead
	}
	return 0
}

func (x *StoreStats) GetInterval() *TimeInterval {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *StoreStats) GetCpuUsages() []*RecordPair {
	if x != nil {
		return x.CpuUsages
	}
	return nil
}

func (x *StoreStats) GetReadIoRates() []*RecordPair {
	if x != nil {
		return x.ReadIoRates
	}
	return nil
}

func (x *StoreStats) GetWriteIoRates() []*RecordPair {
	if x != nil {
		return x.WriteIoRates
	}
	return nil
}

func (x *StoreStats) GetOpLatencies() []*RecordPair {
	if x != nil {
		return x.OpLatencies
	}
	return nil
}

func (x *StoreStats) GetQueryStats() *QueryStats {
	if x != nil {
		return x.QueryStats
	}
	return nil
}

func (x *StoreStats) GetGraphStats() []*GraphStats {
	if x != nil {
		return x.GraphStats
	}
	return nil
}

func (x *StoreStats) GetRaftStats() []*RaftStats {
	if x != nil {
		return x.RaftStats
	}
	return nil
}

func (x *StoreStats) GetCores() int32 {
	if x != nil {
		return x.Cores
	}
	return 0
}

func (x *StoreStats) GetSystemMetrics() []*RecordPair {
	if x != nil {
		return x.SystemMetrics
	}
	return nil
}

// 分区查询条件
type PartitionQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StoreId     *uint64 `protobuf:"varint,1,opt,name=store_id,json=storeId,proto3,oneof" json:"store_id,omitempty"` // 0 表示查询条件不包含store_id
	GraphName   *string `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3,oneof" json:"graph_name,omitempty"`
	PartitionId *uint32 `protobuf:"varint,4,opt,name=partition_id,json=partitionId,proto3,oneof" json:"partition_id,omitempty"`
}

func (x *PartitionQuery) Reset() {
	*x = PartitionQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionQuery) ProtoMessage() {}

func (x *PartitionQuery) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionQuery.ProtoReflect.Descriptor instead.
func (*PartitionQuery) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{19}
}

func (x *PartitionQuery) GetStoreId() uint64 {
	if x != nil && x.StoreId != nil {
		return *x.StoreId
	}
	return 0
}

func (x *PartitionQuery) GetGraphName() string {
	if x != nil && x.GraphName != nil {
		return *x.GraphName
	}
	return ""
}

func (x *PartitionQuery) GetPartitionId() uint32 {
	if x != nil && x.PartitionId != nil {
		return *x.PartitionId
	}
	return 0
}

//PD 节点信息
type Member struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClusterId uint64     `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	RaftUrl   string     `protobuf:"bytes,3,opt,name=raft_url,json=raftUrl,proto3" json:"raft_url,omitempty"`
	GrpcUrl   string     `protobuf:"bytes,4,opt,name=grpc_url,json=grpcUrl,proto3" json:"grpc_url,omitempty"`
	RestUrl   string     `protobuf:"bytes,5,opt,name=rest_url,json=restUrl,proto3" json:"rest_url,omitempty"`
	DataPath  string     `protobuf:"bytes,6,opt,name=data_path,json=dataPath,proto3" json:"data_path,omitempty"`
	State     StoreState `protobuf:"varint,7,opt,name=state,proto3,enum=metapb.StoreState" json:"state,omitempty"`
}

func (x *Member) Reset() {
	*x = Member{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Member) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Member) ProtoMessage() {}

func (x *Member) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Member.ProtoReflect.Descriptor instead.
func (*Member) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{20}
}

func (x *Member) GetClusterId() uint64 {
	if x != nil {
		return x.ClusterId
	}
	return 0
}

func (x *Member) GetRaftUrl() string {
	if x != nil {
		return x.RaftUrl
	}
	return ""
}

func (x *Member) GetGrpcUrl() string {
	if x != nil {
		return x.GrpcUrl
	}
	return ""
}

func (x *Member) GetRestUrl() string {
	if x != nil {
		return x.RestUrl
	}
	return ""
}

func (x *Member) GetDataPath() string {
	if x != nil {
		return x.DataPath
	}
	return ""
}

func (x *Member) GetState() StoreState {
	if x != nil {
		return x.State
	}
	return StoreState_Unknown
}

// 图空间配置
type GraphSpace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// 最大占用存储
	StorageLimit uint64 `protobuf:"varint,2,opt,name=storage_limit,json=storageLimit,proto3" json:"storage_limit,omitempty"`
	// 已使用空间
	UsedSize uint64 `protobuf:"varint,3,opt,name=used_size,json=usedSize,proto3" json:"used_size,omitempty"`
	// 修改时间
	Timestamp uint64 `protobuf:"varint,10,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *GraphSpace) Reset() {
	*x = GraphSpace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GraphSpace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GraphSpace) ProtoMessage() {}

func (x *GraphSpace) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GraphSpace.ProtoReflect.Descriptor instead.
func (*GraphSpace) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{21}
}

func (x *GraphSpace) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GraphSpace) GetStorageLimit() uint64 {
	if x != nil {
		return x.StorageLimit
	}
	return 0
}

func (x *GraphSpace) GetUsedSize() uint64 {
	if x != nil {
		return x.UsedSize
	}
	return 0
}

func (x *GraphSpace) GetTimestamp() uint64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

// PD 配置
type PDConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version uint64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// 分区数量, 初始化根据Store数量动态计算，分裂后进行修改
	PartitionCount int32 `protobuf:"varint,2,opt,name=partition_count,json=partitionCount,proto3" json:"partition_count,omitempty"`
	// 每分区副本数量
	ShardCount int32 `protobuf:"varint,3,opt,name=shard_count,json=shardCount,proto3" json:"shard_count,omitempty"`
	// pd集群列表
	PeersList string `protobuf:"bytes,4,opt,name=peers_list,json=peersList,proto3" json:"peers_list,omitempty"`
	// 集群中最少store数量
	MinStoreCount int32 `protobuf:"varint,6,opt,name=min_store_count,json=minStoreCount,proto3" json:"min_store_count,omitempty"`
	// 每个store最大副本数
	Max_Shards_Per_Store int32 `protobuf:"varint,7,opt,name=max_Shards_Per_Store,json=maxShardsPerStore,proto3" json:"max_Shards_Per_Store,omitempty"`
	// 修改时间
	Timestamp uint64 `protobuf:"varint,10,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *PDConfig) Reset() {
	*x = PDConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PDConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PDConfig) ProtoMessage() {}

func (x *PDConfig) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PDConfig.ProtoReflect.Descriptor instead.
func (*PDConfig) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{22}
}

func (x *PDConfig) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *PDConfig) GetPartitionCount() int32 {
	if x != nil {
		return x.PartitionCount
	}
	return 0
}

func (x *PDConfig) GetShardCount() int32 {
	if x != nil {
		return x.ShardCount
	}
	return 0
}

func (x *PDConfig) GetPeersList() string {
	if x != nil {
		return x.PeersList
	}
	return ""
}

func (x *PDConfig) GetMinStoreCount() int32 {
	if x != nil {
		return x.MinStoreCount
	}
	return 0
}

func (x *PDConfig) GetMax_Shards_Per_Store() int32 {
	if x != nil {
		return x.Max_Shards_Per_Store
	}
	return 0
}

func (x *PDConfig) GetTimestamp() uint64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

//消息持久化
type QueueItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ItemId      string `protobuf:"bytes,1,opt,name=item_id,json=itemId,proto3" json:"item_id,omitempty"`
	ItemClass   string `protobuf:"bytes,2,opt,name=item_class,json=itemClass,proto3" json:"item_class,omitempty"`
	ItemContent []byte `protobuf:"bytes,3,opt,name=item_content,json=itemContent,proto3" json:"item_content,omitempty"`
	Timestamp   int64  `protobuf:"varint,10,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *QueueItem) Reset() {
	*x = QueueItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueueItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueueItem) ProtoMessage() {}

func (x *QueueItem) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueueItem.ProtoReflect.Descriptor instead.
func (*QueueItem) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{23}
}

func (x *QueueItem) GetItemId() string {
	if x != nil {
		return x.ItemId
	}
	return ""
}

func (x *QueueItem) GetItemClass() string {
	if x != nil {
		return x.ItemClass
	}
	return ""
}

func (x *QueueItem) GetItemContent() []byte {
	if x != nil {
		return x.ItemContent
	}
	return nil
}

func (x *QueueItem) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

type LogRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Action    string            `protobuf:"bytes,1,opt,name=action,proto3" json:"action,omitempty"`
	Timestamp int64             `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Labels    map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Object    *anypb.Any        `protobuf:"bytes,4,opt,name=object,proto3" json:"object,omitempty"`
	Message   string            `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *LogRecord) Reset() {
	*x = LogRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogRecord) ProtoMessage() {}

func (x *LogRecord) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogRecord.ProtoReflect.Descriptor instead.
func (*LogRecord) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{24}
}

func (x *LogRecord) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *LogRecord) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *LogRecord) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LogRecord) GetObject() *anypb.Any {
	if x != nil {
		return x.Object
	}
	return nil
}

func (x *LogRecord) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type GraphState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mode   GraphMode       `protobuf:"varint,1,opt,name=mode,proto3,enum=metapb.GraphMode" json:"mode,omitempty"`
	Reason GraphModeReason `protobuf:"varint,2,opt,name=reason,proto3,enum=metapb.GraphModeReason" json:"reason,omitempty"`
}

func (x *GraphState) Reset() {
	*x = GraphState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_metapb_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GraphState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GraphState) ProtoMessage() {}

func (x *GraphState) ProtoReflect() protoreflect.Message {
	mi := &file_metapb_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GraphState.ProtoReflect.Descriptor instead.
func (*GraphState) Descriptor() ([]byte, []int) {
	return file_metapb_proto_rawDescGZIP(), []int{25}
}

func (x *GraphState) GetMode() GraphMode {
	if x != nil {
		return x.Mode
	}
	return GraphMode_ReadWrite
}

func (x *GraphState) GetReason() GraphModeReason {
	if x != nil {
		return x.Reason
	}
	return GraphModeReason_Empty
}

var File_metapb_proto protoreflect.FileDescriptor

var file_metapb_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06,
	0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x72, 0x0a, 0x0c, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x2a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x14, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x10, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x34, 0x0a, 0x0a, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xb5, 0x03, 0x0a, 0x05,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x02, 0x69, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x61, 0x66, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x2a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62,
	0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x61, 0x74, 0x68, 0x12, 0x25, 0x0a, 0x0e,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6c, 0x61, 0x73, 0x74, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62,
	0x65, 0x61, 0x74, 0x12, 0x28, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x05, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x50,
	0x61, 0x74, 0x68, 0x22, 0x49, 0x0a, 0x05, 0x53, 0x68, 0x61, 0x72, 0x64, 0x12, 0x19, 0x0a, 0x08,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53,
	0x68, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x22, 0xc0,
	0x01, 0x0a, 0x0a, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x5f,
	0x76, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x56,
	0x65, 0x72, 0x12, 0x25, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x52, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x12, 0x2c, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70,
	0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x22, 0xcc, 0x01, 0x0a, 0x05, 0x47, 0x72, 0x61, 0x70, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x16, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x33, 0x0a, 0x0b, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x22, 0x97, 0x02, 0x0a, 0x0c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x33,
	0x36, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a,
	0x07, 0x65, 0x6e, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06,
	0x65, 0x6e, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x25, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x5f,
	0x76, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x56,
	0x65, 0x72, 0x12, 0x2c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x16, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xd2, 0x01, 0x0a, 0x09, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x65, 0x6e, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x65, 0x6e, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x9e, 0x01, 0x0a, 0x0e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x12, 0x2f, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x0e, 0x6f, 0x66,
	0x66, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x52, 0x0d, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73,
	0x22, 0x79, 0x0a, 0x0e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x76, 0x0a, 0x0d, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x66, 0x74, 0x12, 0x21, 0x0a, 0x0c,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x61, 0x66, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x0a, 0x53, 0x68, 0x61, 0x72, 0x64, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x25, 0x0a,
	0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x11, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04,
	0x72, 0x6f, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0xc6, 0x03, 0x0a, 0x0e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1f, 0x0a,
	0x0b, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0a, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x54, 0x65, 0x72, 0x6d, 0x12, 0x1d,
	0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x06, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x06, 0x6c, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x52, 0x05, 0x73, 0x68, 0x61, 0x72, 0x64, 0x12, 0x27, 0x0a, 0x07, 0x6c, 0x65, 0x61,
	0x72, 0x6e, 0x65, 0x72, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x07, 0x6c, 0x65, 0x61, 0x72, 0x6e,
	0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x66, 0x5f, 0x76, 0x65, 0x72, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x56, 0x65, 0x72, 0x12, 0x2c, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x32, 0x0a, 0x0a, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12,
	0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70,
	0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74,
	0x65, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x22, 0x82, 0x02, 0x0a, 0x0a, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x29, 0x0a, 0x10,
	0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d,
	0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x04, 0x72, 0x6f,
	0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70,
	0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c,
	0x65, 0x12, 0x35, 0x0a, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x09, 0x77,
	0x6f, 0x72, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0x57, 0x0a, 0x09, 0x52, 0x61, 0x66, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x22, 0x5c, 0x0a, 0x0c, 0x54, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22,
	0x34, 0x0a, 0x0a, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x50, 0x61, 0x69, 0x72, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xb0, 0x01, 0x0a, 0x0a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x47, 0x43, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x02, 0x47, 0x43, 0x12, 0x10, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x03, 0x47, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x53, 0x63, 0x61, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x53, 0x63, 0x61, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x43, 0x6f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0b, 0x43, 0x6f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x50, 0x75, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x03, 0x50, 0x75, 0x74, 0x22, 0xee, 0x07, 0x0a, 0x0a, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x12, 0x1c,
	0x0a, 0x09, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x09, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x6e, 0x61, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x10, 0x73, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x6e, 0x61, 0x70, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x6e, 0x61, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x12, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x6e, 0x61, 0x70,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x6e, 0x61, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x11, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x53, 0x6e, 0x61, 0x70, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x62, 0x75, 0x73, 0x79, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x69, 0x73, 0x42, 0x75, 0x73, 0x79, 0x12, 0x1b, 0x0a,
	0x09, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x08, 0x75, 0x73, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0c, 0x62, 0x79, 0x74, 0x65, 0x73, 0x57, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x12,
	0x21, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x73, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x73, 0x57, 0x72, 0x69, 0x74, 0x74,
	0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x64,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x52, 0x65, 0x61,
	0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x73, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x6b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x61, 0x64, 0x12, 0x30,
	0x0a, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x12, 0x31, 0x0a, 0x0a, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x10,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x50, 0x61, 0x69, 0x72, 0x52, 0x09, 0x63, 0x70, 0x75, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x0d, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x69, 0x6f, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x50, 0x61, 0x69, 0x72, 0x52, 0x0b,
	0x72, 0x65, 0x61, 0x64, 0x49, 0x6f, 0x52, 0x61, 0x74, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x0e, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x5f, 0x69, 0x6f, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x73, 0x18, 0x12, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x50, 0x61, 0x69, 0x72, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x49, 0x6f,
	0x52, 0x61, 0x74, 0x65, 0x73, 0x12, 0x35, 0x0a, 0x0c, 0x6f, 0x70, 0x5f, 0x6c, 0x61, 0x74, 0x65,
	0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x50, 0x61, 0x69, 0x72, 0x52,
	0x0b, 0x6f, 0x70, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x0b,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x12, 0x33, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73,
	0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e,
	0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0a, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x30, 0x0a, 0x0a, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x70, 0x62, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x09, 0x72,
	0x61, 0x66, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x72, 0x65,
	0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x39,
	0x0a, 0x0e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x18, 0x19, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x50, 0x61, 0x69, 0x72, 0x52, 0x0d, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xa9, 0x01, 0x0a, 0x0e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1e, 0x0a, 0x08,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x48, 0x00,
	0x52, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x01, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x02, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x5f, 0x69, 0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x22, 0xbf, 0x01, 0x0a, 0x06, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x19, 0x0a, 0x08, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x72, 0x61, 0x66, 0x74, 0x55, 0x72, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x72,
	0x70, 0x63, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x72,
	0x70, 0x63, 0x55, 0x72, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x74, 0x5f, 0x75, 0x72,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x65, 0x73, 0x74, 0x55, 0x72, 0x6c,
	0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x50, 0x61, 0x74, 0x68, 0x12, 0x28, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x0a, 0x47, 0x72, 0x61, 0x70,
	0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x08, 0x75, 0x73, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1c, 0x0a, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x84, 0x02, 0x0a, 0x08, 0x50,
	0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x65, 0x65, 0x72, 0x73, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x65, 0x65, 0x72, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x6d, 0x69,
	0x6e, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x14, 0x6d, 0x61, 0x78, 0x5f, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73,
	0x5f, 0x50, 0x65, 0x72, 0x5f, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x11, 0x6d, 0x61, 0x78, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x50, 0x65, 0x72, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x22, 0x84, 0x01, 0x0a, 0x09, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x12,
	0x17, 0x0a, 0x07, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x69, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x74, 0x65, 0x6d,
	0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x74,
	0x65, 0x6d, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x74, 0x65, 0x6d, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x69,
	0x74, 0x65, 0x6d, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0xfb, 0x01, 0x0a, 0x09, 0x4c, 0x6f, 0x67,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x35, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x2c, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x64, 0x0a, 0x0a, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x47, 0x72, 0x61, 0x70,
	0x68, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x70, 0x62, 0x2e, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x2a, 0x78, 0x0a, 0x0c,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0e, 0x0a, 0x0a,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x4f, 0x4b, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x57, 0x61, 0x72, 0x6e, 0x10, 0x02, 0x12, 0x13,
	0x0a, 0x0f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e,
	0x65, 0x10, 0x0a, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x46,
	0x61, 0x75, 0x6c, 0x74, 0x10, 0x0b, 0x12, 0x1e, 0x0a, 0x11, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x4e, 0x6f, 0x74, 0x5f, 0x52, 0x65, 0x61, 0x64, 0x79, 0x10, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x2a, 0x57, 0x0a, 0x0a, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x10, 0x04, 0x12, 0x06,
	0x0a, 0x02, 0x55, 0x70, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x66, 0x66, 0x6c, 0x69, 0x6e,
	0x65, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x78, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x10, 0x05,
	0x12, 0x0d, 0x0a, 0x09, 0x54, 0x6f, 0x6d, 0x62, 0x73, 0x74, 0x6f, 0x6e, 0x65, 0x10, 0x03, 0x2a,
	0x3c, 0x0a, 0x09, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x6f, 0x6e, 0x65, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x4c, 0x65, 0x61, 0x72, 0x6e, 0x65, 0x72, 0x10, 0x03, 0x2a, 0x6b, 0x0a,
	0x0e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x0f, 0x0a, 0x0b, 0x50, 0x53, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x4e, 0x6f, 0x6e, 0x65, 0x10, 0x00,
	0x12, 0x11, 0x0a, 0x0d, 0x50, 0x53, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x4e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x53, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x57, 0x61,
	0x72, 0x6e, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x53, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x4f,
	0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x10, 0x0a, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x10, 0x0b, 0x2a, 0x59, 0x0a, 0x0a, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x4e, 0x6f, 0x6e, 0x65, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x53, 0x53, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x10,
	0x02, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x53, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x4f, 0x66, 0x66, 0x6c,
	0x69, 0x6e, 0x65, 0x10, 0x0a, 0x2a, 0x37, 0x0a, 0x09, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x10, 0x02, 0x2a, 0x37,
	0x0a, 0x0f, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a,
	0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x69, 0x76, 0x65, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x10, 0x02, 0x42, 0x38, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x62,
	0x61, 0x69, 0x64, 0x75, 0x2e, 0x68, 0x75, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x70,
	0x64, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x5a, 0x19, 0x2f, 0x68, 0x75, 0x67, 0x65, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x2d, 0x70, 0x64, 0x2d, 0x67, 0x72, 0x70, 0x63, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_metapb_proto_rawDescOnce sync.Once
	file_metapb_proto_rawDescData = file_metapb_proto_rawDesc
)

func file_metapb_proto_rawDescGZIP() []byte {
	file_metapb_proto_rawDescOnce.Do(func() {
		file_metapb_proto_rawDescData = protoimpl.X.CompressGZIP(file_metapb_proto_rawDescData)
	})
	return file_metapb_proto_rawDescData
}

var file_metapb_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_metapb_proto_msgTypes = make([]protoimpl.MessageInfo, 27)
var file_metapb_proto_goTypes = []interface{}{
	(ClusterState)(0),      // 0: metapb.ClusterState
	(StoreState)(0),        // 1: metapb.StoreState
	(ShardRole)(0),         // 2: metapb.ShardRole
	(PartitionState)(0),    // 3: metapb.PartitionState
	(ShardState)(0),        // 4: metapb.ShardState
	(GraphMode)(0),         // 5: metapb.GraphMode
	(GraphModeReason)(0),   // 6: metapb.GraphModeReason
	(*ClusterStats)(nil),   // 7: metapb.ClusterStats
	(*StoreLabel)(nil),     // 8: metapb.StoreLabel
	(*Store)(nil),          // 9: metapb.Store
	(*Shard)(nil),          // 10: metapb.Shard
	(*ShardGroup)(nil),     // 11: metapb.ShardGroup
	(*Graph)(nil),          // 12: metapb.Graph
	(*PartitionV36)(nil),   // 13: metapb.PartitionV36
	(*Partition)(nil),      // 14: metapb.Partition
	(*PartitionShard)(nil), // 15: metapb.PartitionShard
	(*PartitionStore)(nil), // 16: metapb.PartitionStore
	(*PartitionRaft)(nil),  // 17: metapb.PartitionRaft
	(*ShardStats)(nil),     // 18: metapb.ShardStats
	(*PartitionStats)(nil), // 19: metapb.PartitionStats
	(*GraphStats)(nil),     // 20: metapb.GraphStats
	(*RaftStats)(nil),      // 21: metapb.RaftStats
	(*TimeInterval)(nil),   // 22: metapb.TimeInterval
	(*RecordPair)(nil),     // 23: metapb.RecordPair
	(*QueryStats)(nil),     // 24: metapb.QueryStats
	(*StoreStats)(nil),     // 25: metapb.StoreStats
	(*PartitionQuery)(nil), // 26: metapb.PartitionQuery
	(*Member)(nil),         // 27: metapb.Member
	(*GraphSpace)(nil),     // 28: metapb.GraphSpace
	(*PDConfig)(nil),       // 29: metapb.PDConfig
	(*QueueItem)(nil),      // 30: metapb.QueueItem
	(*LogRecord)(nil),      // 31: metapb.LogRecord
	(*GraphState)(nil),     // 32: metapb.GraphState
	nil,                    // 33: metapb.LogRecord.LabelsEntry
	(*anypb.Any)(nil),      // 34: google.protobuf.Any
}
var file_metapb_proto_depIdxs = []int32{
	0,  // 0: metapb.ClusterStats.state:type_name -> metapb.ClusterState
	8,  // 1: metapb.Store.labels:type_name -> metapb.StoreLabel
	1,  // 2: metapb.Store.state:type_name -> metapb.StoreState
	25, // 3: metapb.Store.stats:type_name -> metapb.StoreStats
	2,  // 4: metapb.Shard.role:type_name -> metapb.ShardRole
	10, // 5: metapb.ShardGroup.shards:type_name -> metapb.Shard
	3,  // 6: metapb.ShardGroup.state:type_name -> metapb.PartitionState
	3,  // 7: metapb.Graph.state:type_name -> metapb.PartitionState
	32, // 8: metapb.Graph.graph_state:type_name -> metapb.GraphState
	10, // 9: metapb.PartitionV36.shards:type_name -> metapb.Shard
	3,  // 10: metapb.PartitionV36.state:type_name -> metapb.PartitionState
	3,  // 11: metapb.Partition.state:type_name -> metapb.PartitionState
	14, // 12: metapb.PartitionShard.partition:type_name -> metapb.Partition
	10, // 13: metapb.PartitionShard.leader:type_name -> metapb.Shard
	10, // 14: metapb.PartitionShard.offline_shards:type_name -> metapb.Shard
	2,  // 15: metapb.ShardStats.role:type_name -> metapb.ShardRole
	4,  // 16: metapb.ShardStats.state:type_name -> metapb.ShardState
	10, // 17: metapb.PartitionStats.leader:type_name -> metapb.Shard
	10, // 18: metapb.PartitionStats.shard:type_name -> metapb.Shard
	10, // 19: metapb.PartitionStats.learner:type_name -> metapb.Shard
	3,  // 20: metapb.PartitionStats.state:type_name -> metapb.PartitionState
	18, // 21: metapb.PartitionStats.shardStats:type_name -> metapb.ShardStats
	2,  // 22: metapb.GraphStats.role:type_name -> metapb.ShardRole
	3,  // 23: metapb.GraphStats.work_state:type_name -> metapb.PartitionState
	22, // 24: metapb.StoreStats.interval:type_name -> metapb.TimeInterval
	23, // 25: metapb.StoreStats.cpu_usages:type_name -> metapb.RecordPair
	23, // 26: metapb.StoreStats.read_io_rates:type_name -> metapb.RecordPair
	23, // 27: metapb.StoreStats.write_io_rates:type_name -> metapb.RecordPair
	23, // 28: metapb.StoreStats.op_latencies:type_name -> metapb.RecordPair
	24, // 29: metapb.StoreStats.query_stats:type_name -> metapb.QueryStats
	20, // 30: metapb.StoreStats.graph_stats:type_name -> metapb.GraphStats
	21, // 31: metapb.StoreStats.raft_stats:type_name -> metapb.RaftStats
	23, // 32: metapb.StoreStats.system_metrics:type_name -> metapb.RecordPair
	1,  // 33: metapb.Member.state:type_name -> metapb.StoreState
	33, // 34: metapb.LogRecord.labels:type_name -> metapb.LogRecord.LabelsEntry
	34, // 35: metapb.LogRecord.object:type_name -> google.protobuf.Any
	5,  // 36: metapb.GraphState.mode:type_name -> metapb.GraphMode
	6,  // 37: metapb.GraphState.reason:type_name -> metapb.GraphModeReason
	38, // [38:38] is the sub-list for method output_type
	38, // [38:38] is the sub-list for method input_type
	38, // [38:38] is the sub-list for extension type_name
	38, // [38:38] is the sub-list for extension extendee
	0,  // [0:38] is the sub-list for field type_name
}

func init() { file_metapb_proto_init() }
func file_metapb_proto_init() {
	if File_metapb_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_metapb_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClusterStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreLabel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Store); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Graph); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionV36); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionShard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionStore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionRaft); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShardStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GraphStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RaftStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeInterval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RecordPair); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Member); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GraphSpace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PDConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueueItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_metapb_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GraphState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_metapb_proto_msgTypes[19].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_metapb_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   27,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_metapb_proto_goTypes,
		DependencyIndexes: file_metapb_proto_depIdxs,
		EnumInfos:         file_metapb_proto_enumTypes,
		MessageInfos:      file_metapb_proto_msgTypes,
	}.Build()
	File_metapb_proto = out.File
	file_metapb_proto_rawDesc = nil
	file_metapb_proto_goTypes = nil
	file_metapb_proto_depIdxs = nil
}
