/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.1
// source: graphpb.proto

package hugegraph_store_grpc

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type VariantType int32

const (
	VariantType_VT_UNKNOWN  VariantType = 0
	VariantType_VT_BOOLEAN  VariantType = 1
	VariantType_VT_INT      VariantType = 2
	VariantType_VT_LONG     VariantType = 3
	VariantType_VT_FLOAT    VariantType = 4
	VariantType_VT_DOUBLE   VariantType = 7
	VariantType_VT_STRING   VariantType = 8
	VariantType_VT_BYTES    VariantType = 9
	VariantType_VT_DATETIME VariantType = 10
)

// Enum value maps for VariantType.
var (
	VariantType_name = map[int32]string{
		0:  "VT_UNKNOWN",
		1:  "VT_BOOLEAN",
		2:  "VT_INT",
		3:  "VT_LONG",
		4:  "VT_FLOAT",
		7:  "VT_DOUBLE",
		8:  "VT_STRING",
		9:  "VT_BYTES",
		10: "VT_DATETIME",
	}
	VariantType_value = map[string]int32{
		"VT_UNKNOWN":  0,
		"VT_BOOLEAN":  1,
		"VT_INT":      2,
		"VT_LONG":     3,
		"VT_FLOAT":    4,
		"VT_DOUBLE":   7,
		"VT_STRING":   8,
		"VT_BYTES":    9,
		"VT_DATETIME": 10,
	}
)

func (x VariantType) Enum() *VariantType {
	p := new(VariantType)
	*p = x
	return p
}

func (x VariantType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VariantType) Descriptor() protoreflect.EnumDescriptor {
	return file_graphpb_proto_enumTypes[0].Descriptor()
}

func (VariantType) Type() protoreflect.EnumType {
	return &file_graphpb_proto_enumTypes[0]
}

func (x VariantType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VariantType.Descriptor instead.
func (VariantType) EnumDescriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{0}
}

type ErrorType int32

const (
	ErrorType_OK      ErrorType = 0
	ErrorType_UNKNOWN ErrorType = 1
)

// Enum value maps for ErrorType.
var (
	ErrorType_name = map[int32]string{
		0: "OK",
		1: "UNKNOWN",
	}
	ErrorType_value = map[string]int32{
		"OK":      0,
		"UNKNOWN": 1,
	}
)

func (x ErrorType) Enum() *ErrorType {
	p := new(ErrorType)
	*p = x
	return p
}

func (x ErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_graphpb_proto_enumTypes[1].Descriptor()
}

func (ErrorType) Type() protoreflect.EnumType {
	return &file_graphpb_proto_enumTypes[1]
}

func (x ErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ErrorType.Descriptor instead.
func (ErrorType) EnumDescriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{1}
}

type ScanPartitionRequest_ScanType int32

const (
	ScanPartitionRequest_SCAN_UNKNOWN ScanPartitionRequest_ScanType = 0
	ScanPartitionRequest_SCAN_VERTEX  ScanPartitionRequest_ScanType = 1
	ScanPartitionRequest_SCAN_EDGE    ScanPartitionRequest_ScanType = 2
)

// Enum value maps for ScanPartitionRequest_ScanType.
var (
	ScanPartitionRequest_ScanType_name = map[int32]string{
		0: "SCAN_UNKNOWN",
		1: "SCAN_VERTEX",
		2: "SCAN_EDGE",
	}
	ScanPartitionRequest_ScanType_value = map[string]int32{
		"SCAN_UNKNOWN": 0,
		"SCAN_VERTEX":  1,
		"SCAN_EDGE":    2,
	}
)

func (x ScanPartitionRequest_ScanType) Enum() *ScanPartitionRequest_ScanType {
	p := new(ScanPartitionRequest_ScanType)
	*p = x
	return p
}

func (x ScanPartitionRequest_ScanType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScanPartitionRequest_ScanType) Descriptor() protoreflect.EnumDescriptor {
	return file_graphpb_proto_enumTypes[2].Descriptor()
}

func (ScanPartitionRequest_ScanType) Type() protoreflect.EnumType {
	return &file_graphpb_proto_enumTypes[2]
}

func (x ScanPartitionRequest_ScanType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ScanPartitionRequest_ScanType.Descriptor instead.
func (ScanPartitionRequest_ScanType) EnumDescriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{0, 0}
}

type ScanPartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Types that are assignable to Request:
	//	*ScanPartitionRequest_ScanRequest
	//	*ScanPartitionRequest_ReplyRequest
	Request isScanPartitionRequest_Request `protobuf_oneof:"request"`
}

func (x *ScanPartitionRequest) Reset() {
	*x = ScanPartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScanPartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScanPartitionRequest) ProtoMessage() {}

func (x *ScanPartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScanPartitionRequest.ProtoReflect.Descriptor instead.
func (*ScanPartitionRequest) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{0}
}

func (x *ScanPartitionRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (m *ScanPartitionRequest) GetRequest() isScanPartitionRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *ScanPartitionRequest) GetScanRequest() *ScanPartitionRequest_Request {
	if x, ok := x.GetRequest().(*ScanPartitionRequest_ScanRequest); ok {
		return x.ScanRequest
	}
	return nil
}

func (x *ScanPartitionRequest) GetReplyRequest() *ScanPartitionRequest_Reply {
	if x, ok := x.GetRequest().(*ScanPartitionRequest_ReplyRequest); ok {
		return x.ReplyRequest
	}
	return nil
}

type isScanPartitionRequest_Request interface {
	isScanPartitionRequest_Request()
}

type ScanPartitionRequest_ScanRequest struct {
	ScanRequest *ScanPartitionRequest_Request `protobuf:"bytes,2,opt,name=scan_request,json=scanRequest,proto3,oneof"`
}

type ScanPartitionRequest_ReplyRequest struct {
	// 每消费一个数据包，通知服务端一次，返回消息序号
	ReplyRequest *ScanPartitionRequest_Reply `protobuf:"bytes,4,opt,name=reply_request,json=replyRequest,proto3,oneof"`
}

func (*ScanPartitionRequest_ScanRequest) isScanPartitionRequest_Request() {}

func (*ScanPartitionRequest_ReplyRequest) isScanPartitionRequest_Request() {}

type ScanResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// 消息序号
	SeqNo  int32     `protobuf:"varint,2,opt,name=seq_no,json=seqNo,proto3" json:"seq_no,omitempty"`
	Vertex []*Vertex `protobuf:"bytes,3,rep,name=vertex,proto3" json:"vertex,omitempty"`
	Edge   []*Edge   `protobuf:"bytes,4,rep,name=edge,proto3" json:"edge,omitempty"`
}

func (x *ScanResponse) Reset() {
	*x = ScanResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScanResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScanResponse) ProtoMessage() {}

func (x *ScanResponse) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScanResponse.ProtoReflect.Descriptor instead.
func (*ScanResponse) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{1}
}

func (x *ScanResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ScanResponse) GetSeqNo() int32 {
	if x != nil {
		return x.SeqNo
	}
	return 0
}

func (x *ScanResponse) GetVertex() []*Vertex {
	if x != nil {
		return x.Vertex
	}
	return nil
}

func (x *ScanResponse) GetEdge() []*Edge {
	if x != nil {
		return x.Edge
	}
	return nil
}

type Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Label uint64   `protobuf:"varint,1,opt,name=label,proto3" json:"label,omitempty"`
	Value *Variant `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Property) Reset() {
	*x = Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Property) ProtoMessage() {}

func (x *Property) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Property.ProtoReflect.Descriptor instead.
func (*Property) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{2}
}

func (x *Property) GetLabel() uint64 {
	if x != nil {
		return x.Label
	}
	return 0
}

func (x *Property) GetValue() *Variant {
	if x != nil {
		return x.Value
	}
	return nil
}

type Vertex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Label      int64       `protobuf:"varint,1,opt,name=label,proto3" json:"label,omitempty"`          // 点类型
	Id         *Variant    `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`                 // 点ID
	Properties []*Property `protobuf:"bytes,3,rep,name=properties,proto3" json:"properties,omitempty"` //点属性
}

func (x *Vertex) Reset() {
	*x = Vertex{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vertex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vertex) ProtoMessage() {}

func (x *Vertex) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vertex.ProtoReflect.Descriptor instead.
func (*Vertex) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{3}
}

func (x *Vertex) GetLabel() int64 {
	if x != nil {
		return x.Label
	}
	return 0
}

func (x *Vertex) GetId() *Variant {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *Vertex) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

type Edge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Label       int64       `protobuf:"varint,1,opt,name=label,proto3" json:"label,omitempty"` // 边类型
	SourceLabel int64       `protobuf:"varint,2,opt,name=sourceLabel,proto3" json:"sourceLabel,omitempty"`
	TargetLabel int64       `protobuf:"varint,3,opt,name=targetLabel,proto3" json:"targetLabel,omitempty"`
	SourceId    *Variant    `protobuf:"bytes,4,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"` // 源点ID
	TargetId    *Variant    `protobuf:"bytes,5,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"` // 目标点ID
	Properties  []*Property `protobuf:"bytes,6,rep,name=properties,proto3" json:"properties,omitempty"`             //边属性
}

func (x *Edge) Reset() {
	*x = Edge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Edge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Edge) ProtoMessage() {}

func (x *Edge) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Edge.ProtoReflect.Descriptor instead.
func (*Edge) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{4}
}

func (x *Edge) GetLabel() int64 {
	if x != nil {
		return x.Label
	}
	return 0
}

func (x *Edge) GetSourceLabel() int64 {
	if x != nil {
		return x.SourceLabel
	}
	return 0
}

func (x *Edge) GetTargetLabel() int64 {
	if x != nil {
		return x.TargetLabel
	}
	return 0
}

func (x *Edge) GetSourceId() *Variant {
	if x != nil {
		return x.SourceId
	}
	return nil
}

func (x *Edge) GetTargetId() *Variant {
	if x != nil {
		return x.TargetId
	}
	return nil
}

func (x *Edge) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

type Variant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type          *VariantType `protobuf:"varint,1,opt,name=type,proto3,enum=graph_pb.VariantType,oneof" json:"type,omitempty"`
	ValueInt32    *int32       `protobuf:"varint,2,opt,name=value_int32,json=valueInt32,proto3,oneof" json:"value_int32,omitempty"`
	ValueInt64    *int64       `protobuf:"varint,3,opt,name=value_int64,json=valueInt64,proto3,oneof" json:"value_int64,omitempty"`
	ValueFloat    *float32     `protobuf:"fixed32,4,opt,name=value_float,json=valueFloat,proto3,oneof" json:"value_float,omitempty"`
	ValueDouble   *float64     `protobuf:"fixed64,5,opt,name=value_double,json=valueDouble,proto3,oneof" json:"value_double,omitempty"`
	ValueString   *string      `protobuf:"bytes,6,opt,name=value_string,json=valueString,proto3,oneof" json:"value_string,omitempty"`
	ValueBytes    []byte       `protobuf:"bytes,7,opt,name=value_bytes,json=valueBytes,proto3,oneof" json:"value_bytes,omitempty"`
	ValueDatetime *string      `protobuf:"bytes,8,opt,name=value_datetime,json=valueDatetime,proto3,oneof" json:"value_datetime,omitempty"`
	ValueBoolean  *bool        `protobuf:"varint,9,opt,name=value_boolean,json=valueBoolean,proto3,oneof" json:"value_boolean,omitempty"`
}

func (x *Variant) Reset() {
	*x = Variant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Variant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Variant) ProtoMessage() {}

func (x *Variant) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Variant.ProtoReflect.Descriptor instead.
func (*Variant) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{5}
}

func (x *Variant) GetType() VariantType {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return VariantType_VT_UNKNOWN
}

func (x *Variant) GetValueInt32() int32 {
	if x != nil && x.ValueInt32 != nil {
		return *x.ValueInt32
	}
	return 0
}

func (x *Variant) GetValueInt64() int64 {
	if x != nil && x.ValueInt64 != nil {
		return *x.ValueInt64
	}
	return 0
}

func (x *Variant) GetValueFloat() float32 {
	if x != nil && x.ValueFloat != nil {
		return *x.ValueFloat
	}
	return 0
}

func (x *Variant) GetValueDouble() float64 {
	if x != nil && x.ValueDouble != nil {
		return *x.ValueDouble
	}
	return 0
}

func (x *Variant) GetValueString() string {
	if x != nil && x.ValueString != nil {
		return *x.ValueString
	}
	return ""
}

func (x *Variant) GetValueBytes() []byte {
	if x != nil {
		return x.ValueBytes
	}
	return nil
}

func (x *Variant) GetValueDatetime() string {
	if x != nil && x.ValueDatetime != nil {
		return *x.ValueDatetime
	}
	return ""
}

func (x *Variant) GetValueBoolean() bool {
	if x != nil && x.ValueBoolean != nil {
		return *x.ValueBoolean
	}
	return false
}

type RequestHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// 发送者 ID.
	SenderId uint64 `protobuf:"varint,2,opt,name=sender_id,json=senderId,proto3" json:"sender_id,omitempty"`
}

func (x *RequestHeader) Reset() {
	*x = RequestHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestHeader) ProtoMessage() {}

func (x *RequestHeader) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestHeader.ProtoReflect.Descriptor instead.
func (*RequestHeader) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{6}
}

func (x *RequestHeader) GetSenderId() uint64 {
	if x != nil {
		return x.SenderId
	}
	return 0
}

type ResponseHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SenderId uint64 `protobuf:"varint,1,opt,name=sender_id,json=senderId,proto3" json:"sender_id,omitempty"`
	Error    *Error `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ResponseHeader) Reset() {
	*x = ResponseHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseHeader) ProtoMessage() {}

func (x *ResponseHeader) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseHeader.ProtoReflect.Descriptor instead.
func (*ResponseHeader) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{7}
}

func (x *ResponseHeader) GetSenderId() uint64 {
	if x != nil {
		return x.SenderId
	}
	return 0
}

func (x *ResponseHeader) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type    ErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=graph_pb.ErrorType" json:"type,omitempty"`
	Message string    `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{8}
}

func (x *Error) GetType() ErrorType {
	if x != nil {
		return x.Type
	}
	return ErrorType_OK
}

func (x *Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// 请求参数
type ScanPartitionRequest_Request struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ScanType    ScanPartitionRequest_ScanType `protobuf:"varint,1,opt,name=scan_type,json=scanType,proto3,enum=graph_pb.ScanPartitionRequest_ScanType" json:"scan_type,omitempty"`
	GraphName   string                        `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	PartitionId uint32                        `protobuf:"varint,3,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	StartCode   uint32                        `protobuf:"varint,4,opt,name=start_code,json=startCode,proto3" json:"start_code,omitempty"`
	EndCode     uint32                        `protobuf:"varint,5,opt,name=end_code,json=endCode,proto3" json:"end_code,omitempty"`
	// 过滤条件
	Condition string `protobuf:"bytes,6,opt,name=condition,proto3" json:"condition,omitempty"`
	Table     string `protobuf:"bytes,7,opt,name=table,proto3" json:"table,omitempty"`
	Limit     int64  `protobuf:"varint,8,opt,name=limit,proto3" json:"limit,omitempty"`
	Boundary  int32  `protobuf:"varint,9,opt,name=boundary,proto3" json:"boundary,omitempty"`
	Position  []byte `protobuf:"bytes,10,opt,name=position,proto3" json:"position,omitempty"`
	// 返回条件
	Properties []int64 `protobuf:"varint,11,rep,packed,name=properties,proto3" json:"properties,omitempty"`
	BatchSize  int32   `protobuf:"varint,12,opt,name=batchSize,proto3" json:"batchSize,omitempty"`
}

func (x *ScanPartitionRequest_Request) Reset() {
	*x = ScanPartitionRequest_Request{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScanPartitionRequest_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScanPartitionRequest_Request) ProtoMessage() {}

func (x *ScanPartitionRequest_Request) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScanPartitionRequest_Request.ProtoReflect.Descriptor instead.
func (*ScanPartitionRequest_Request) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ScanPartitionRequest_Request) GetScanType() ScanPartitionRequest_ScanType {
	if x != nil {
		return x.ScanType
	}
	return ScanPartitionRequest_SCAN_UNKNOWN
}

func (x *ScanPartitionRequest_Request) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *ScanPartitionRequest_Request) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *ScanPartitionRequest_Request) GetStartCode() uint32 {
	if x != nil {
		return x.StartCode
	}
	return 0
}

func (x *ScanPartitionRequest_Request) GetEndCode() uint32 {
	if x != nil {
		return x.EndCode
	}
	return 0
}

func (x *ScanPartitionRequest_Request) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *ScanPartitionRequest_Request) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *ScanPartitionRequest_Request) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ScanPartitionRequest_Request) GetBoundary() int32 {
	if x != nil {
		return x.Boundary
	}
	return 0
}

func (x *ScanPartitionRequest_Request) GetPosition() []byte {
	if x != nil {
		return x.Position
	}
	return nil
}

func (x *ScanPartitionRequest_Request) GetProperties() []int64 {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *ScanPartitionRequest_Request) GetBatchSize() int32 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

type ScanPartitionRequest_Reply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SeqNo int32 `protobuf:"varint,1,opt,name=seq_no,json=seqNo,proto3" json:"seq_no,omitempty"`
}

func (x *ScanPartitionRequest_Reply) Reset() {
	*x = ScanPartitionRequest_Reply{}
	if protoimpl.UnsafeEnabled {
		mi := &file_graphpb_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScanPartitionRequest_Reply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScanPartitionRequest_Reply) ProtoMessage() {}

func (x *ScanPartitionRequest_Reply) ProtoReflect() protoreflect.Message {
	mi := &file_graphpb_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScanPartitionRequest_Reply.ProtoReflect.Descriptor instead.
func (*ScanPartitionRequest_Reply) Descriptor() ([]byte, []int) {
	return file_graphpb_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ScanPartitionRequest_Reply) GetSeqNo() int32 {
	if x != nil {
		return x.SeqNo
	}
	return 0
}

var File_graphpb_proto protoreflect.FileDescriptor

var file_graphpb_proto_rawDesc = []byte{
	0x0a, 0x0d, 0x67, 0x72, 0x61, 0x70, 0x68, 0x70, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x08, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x22, 0xd8, 0x05, 0x0a, 0x14, 0x53, 0x63,
	0x61, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x2f, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x0c, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x5f, 0x70, 0x62, 0x2e, 0x53, 0x63, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f,
	0x70, 0x62, 0x2e, 0x53, 0x63, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x48, 0x00, 0x52,
	0x0c, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x8b, 0x03,
	0x0a, 0x07, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x09, 0x73, 0x63, 0x61,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e, 0x53, 0x63, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x63, 0x61,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x73, 0x63, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28,
	0x03, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1c, 0x0a,
	0x09, 0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x1e, 0x0a, 0x05, 0x52,
	0x65, 0x70, 0x6c, 0x79, 0x12, 0x15, 0x0a, 0x06, 0x73, 0x65, 0x71, 0x5f, 0x6e, 0x6f, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x65, 0x71, 0x4e, 0x6f, 0x22, 0x3c, 0x0a, 0x08, 0x53,
	0x63, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x43, 0x41, 0x4e, 0x5f,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x43, 0x41,
	0x4e, 0x5f, 0x56, 0x45, 0x52, 0x54, 0x45, 0x58, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43,
	0x41, 0x4e, 0x5f, 0x45, 0x44, 0x47, 0x45, 0x10, 0x02, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x22, 0xa5, 0x01, 0x0a, 0x0c, 0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x06, 0x73, 0x65, 0x71, 0x5f, 0x6e,
	0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x65, 0x71, 0x4e, 0x6f, 0x12, 0x28,
	0x0a, 0x06, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x52, 0x06, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x12, 0x22, 0x0a, 0x04, 0x65, 0x64, 0x67, 0x65,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70,
	0x62, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x52, 0x04, 0x65, 0x64, 0x67, 0x65, 0x22, 0x49, 0x0a, 0x08,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x27,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x75, 0x0a, 0x06, 0x56, 0x65, 0x72, 0x74, 0x65,
	0x78, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x21, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x02, 0x69, 0x64, 0x12, 0x32, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0xf4,
	0x01, 0x0a, 0x04, 0x45, 0x64, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x20, 0x0a,
	0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12,
	0x20, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0x2e, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x2e, 0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49,
	0x64, 0x12, 0x32, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62,
	0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0x87, 0x04, 0x0a, 0x07, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x15, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x24, 0x0a, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x33, 0x32,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x49,
	0x6e, 0x74, 0x33, 0x32, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x02, 0x52, 0x0a,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a,
	0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x02, 0x48, 0x03, 0x52, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x6c, 0x6f, 0x61, 0x74,
	0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x64, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x48, 0x04, 0x52, 0x0b, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x05, 0x52, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x06, 0x52, 0x0a, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x07, 0x52, 0x0d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x44, 0x61, 0x74, 0x65, 0x74, 0x69,
	0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x62,
	0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x08, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x88, 0x01, 0x01, 0x42,
	0x07, 0x0a, 0x05, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x33, 0x32, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x22,
	0x2c, 0x0a, 0x0d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0x54, 0x0a,
	0x0e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12,
	0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x22, 0x4a, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x27, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2a,
	0x91, 0x01, 0x0a, 0x0b, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x0e, 0x0a, 0x0a, 0x56, 0x54, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x0e, 0x0a, 0x0a, 0x56, 0x54, 0x5f, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x56, 0x54, 0x5f, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x56,
	0x54, 0x5f, 0x4c, 0x4f, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x54, 0x5f, 0x46,
	0x4c, 0x4f, 0x41, 0x54, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x54, 0x5f, 0x44, 0x4f, 0x55,
	0x42, 0x4c, 0x45, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x54, 0x5f, 0x53, 0x54, 0x52, 0x49,
	0x4e, 0x47, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x54, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53,
	0x10, 0x09, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x54, 0x5f, 0x44, 0x41, 0x54, 0x45, 0x54, 0x49, 0x4d,
	0x45, 0x10, 0x0a, 0x2a, 0x20, 0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x10, 0x01, 0x32, 0x5b, 0x0a, 0x0a, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x4d, 0x0a, 0x0d, 0x53, 0x63, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e,
	0x53, 0x63, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x70, 0x62, 0x2e,
	0x53, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01,
	0x30, 0x01, 0x42, 0x37, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x62, 0x61, 0x69, 0x64, 0x75, 0x2e,
	0x68, 0x75, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x67, 0x72, 0x70, 0x63, 0x5a, 0x15, 0x2f, 0x68, 0x75, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x2d, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2d, 0x67, 0x72, 0x70, 0x63, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_graphpb_proto_rawDescOnce sync.Once
	file_graphpb_proto_rawDescData = file_graphpb_proto_rawDesc
)

func file_graphpb_proto_rawDescGZIP() []byte {
	file_graphpb_proto_rawDescOnce.Do(func() {
		file_graphpb_proto_rawDescData = protoimpl.X.CompressGZIP(file_graphpb_proto_rawDescData)
	})
	return file_graphpb_proto_rawDescData
}

var file_graphpb_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_graphpb_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_graphpb_proto_goTypes = []interface{}{
	(VariantType)(0),                     // 0: graph_pb.VariantType
	(ErrorType)(0),                       // 1: graph_pb.ErrorType
	(ScanPartitionRequest_ScanType)(0),   // 2: graph_pb.ScanPartitionRequest.ScanType
	(*ScanPartitionRequest)(nil),         // 3: graph_pb.ScanPartitionRequest
	(*ScanResponse)(nil),                 // 4: graph_pb.ScanResponse
	(*Property)(nil),                     // 5: graph_pb.Property
	(*Vertex)(nil),                       // 6: graph_pb.Vertex
	(*Edge)(nil),                         // 7: graph_pb.Edge
	(*Variant)(nil),                      // 8: graph_pb.Variant
	(*RequestHeader)(nil),                // 9: graph_pb.RequestHeader
	(*ResponseHeader)(nil),               // 10: graph_pb.ResponseHeader
	(*Error)(nil),                        // 11: graph_pb.Error
	(*ScanPartitionRequest_Request)(nil), // 12: graph_pb.ScanPartitionRequest.Request
	(*ScanPartitionRequest_Reply)(nil),   // 13: graph_pb.ScanPartitionRequest.Reply
}
var file_graphpb_proto_depIdxs = []int32{
	9,  // 0: graph_pb.ScanPartitionRequest.header:type_name -> graph_pb.RequestHeader
	12, // 1: graph_pb.ScanPartitionRequest.scan_request:type_name -> graph_pb.ScanPartitionRequest.Request
	13, // 2: graph_pb.ScanPartitionRequest.reply_request:type_name -> graph_pb.ScanPartitionRequest.Reply
	10, // 3: graph_pb.ScanResponse.header:type_name -> graph_pb.ResponseHeader
	6,  // 4: graph_pb.ScanResponse.vertex:type_name -> graph_pb.Vertex
	7,  // 5: graph_pb.ScanResponse.edge:type_name -> graph_pb.Edge
	8,  // 6: graph_pb.Property.value:type_name -> graph_pb.Variant
	8,  // 7: graph_pb.Vertex.id:type_name -> graph_pb.Variant
	5,  // 8: graph_pb.Vertex.properties:type_name -> graph_pb.Property
	8,  // 9: graph_pb.Edge.source_id:type_name -> graph_pb.Variant
	8,  // 10: graph_pb.Edge.target_id:type_name -> graph_pb.Variant
	5,  // 11: graph_pb.Edge.properties:type_name -> graph_pb.Property
	0,  // 12: graph_pb.Variant.type:type_name -> graph_pb.VariantType
	11, // 13: graph_pb.ResponseHeader.error:type_name -> graph_pb.Error
	1,  // 14: graph_pb.Error.type:type_name -> graph_pb.ErrorType
	2,  // 15: graph_pb.ScanPartitionRequest.Request.scan_type:type_name -> graph_pb.ScanPartitionRequest.ScanType
	3,  // 16: graph_pb.GraphStore.ScanPartition:input_type -> graph_pb.ScanPartitionRequest
	4,  // 17: graph_pb.GraphStore.ScanPartition:output_type -> graph_pb.ScanResponse
	17, // [17:18] is the sub-list for method output_type
	16, // [16:17] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_graphpb_proto_init() }
func file_graphpb_proto_init() {
	if File_graphpb_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_graphpb_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScanPartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScanResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vertex); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Edge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Variant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScanPartitionRequest_Request); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_graphpb_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScanPartitionRequest_Reply); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_graphpb_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ScanPartitionRequest_ScanRequest)(nil),
		(*ScanPartitionRequest_ReplyRequest)(nil),
	}
	file_graphpb_proto_msgTypes[5].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_graphpb_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_graphpb_proto_goTypes,
		DependencyIndexes: file_graphpb_proto_depIdxs,
		EnumInfos:         file_graphpb_proto_enumTypes,
		MessageInfos:      file_graphpb_proto_msgTypes,
	}.Build()
	File_graphpb_proto = out.File
	file_graphpb_proto_rawDesc = nil
	file_graphpb_proto_goTypes = nil
	file_graphpb_proto_depIdxs = nil
}
