/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBProxyEndpoint;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse;

public class DescribeDBProxyEndpointsIterable
implements SdkIterable<DescribeDbProxyEndpointsResponse> {
    private final RdsClient client;
    private final DescribeDbProxyEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBProxyEndpointsIterable(RdsClient client, DescribeDbProxyEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbProxyEndpointsResponseFetcher();
    }

    public Iterator<DescribeDbProxyEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBProxyEndpoint> dbProxyEndpoints() {
        Function<DescribeDbProxyEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbProxyEndpoints() != null) {
                return response.dbProxyEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbProxyEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeDbProxyEndpointsResponse> {
        private DescribeDbProxyEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbProxyEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbProxyEndpointsResponse nextPage(DescribeDbProxyEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBProxyEndpointsIterable.this.client.describeDBProxyEndpoints(DescribeDBProxyEndpointsIterable.this.firstRequest);
            }
            return DescribeDBProxyEndpointsIterable.this.client.describeDBProxyEndpoints((DescribeDbProxyEndpointsRequest)((Object)DescribeDBProxyEndpointsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

