/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.service.auth.Authenticator;
import org.apache.polaris.service.auth.PolarisCredential;

@ApplicationScoped
public class AuthenticatingAugmentor
implements SecurityIdentityAugmentor {
    public static final int PRIORITY = 1000;
    private final Authenticator authenticator;

    @Inject
    public AuthenticatingAugmentor(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public int priority() {
        return 1000;
    }

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        if (identity.isAnonymous()) {
            return Uni.createFrom().item((Object)identity);
        }
        PolarisCredential authInfo = this.extractPolarisCredential(identity);
        return context.runBlocking(() -> this.authenticatePolarisPrincipal(identity, authInfo));
    }

    private PolarisCredential extractPolarisCredential(SecurityIdentity identity) {
        PolarisCredential credential = (PolarisCredential)identity.getCredential(PolarisCredential.class);
        if (credential == null) {
            throw new AuthenticationFailedException("No token credential available");
        }
        return credential;
    }

    private SecurityIdentity authenticatePolarisPrincipal(SecurityIdentity identity, PolarisCredential polarisCredential) {
        try {
            PolarisPrincipal polarisPrincipal = this.authenticator.authenticate(polarisCredential);
            QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder().setAnonymous(false).setPrincipal((Principal)polarisPrincipal).addRoles(polarisPrincipal.getRoles()).addCredentials(identity.getCredentials()).addAttributes(identity.getAttributes()).addPermissionChecker(arg_0 -> ((SecurityIdentity)identity).checkPermission(arg_0));
            polarisPrincipal.getProperties().forEach((arg_0, arg_1) -> ((QuarkusSecurityIdentity.Builder)builder).addAttribute(arg_0, arg_1));
            return builder.build();
        }
        catch (ServiceFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new AuthenticationFailedException((Throwable)e);
        }
    }

    public AuthenticatingAugmentor() {
    }
}

