/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.variants.LogicalType;

public enum PhysicalType {
    NULL(LogicalType.NULL, Void.class),
    BOOLEAN_TRUE(LogicalType.BOOLEAN, Boolean.class),
    BOOLEAN_FALSE(LogicalType.BOOLEAN, Boolean.class),
    INT8(LogicalType.EXACT_NUMERIC, Byte.class),
    INT16(LogicalType.EXACT_NUMERIC, Short.class),
    INT32(LogicalType.EXACT_NUMERIC, Integer.class),
    INT64(LogicalType.EXACT_NUMERIC, Long.class),
    DOUBLE(LogicalType.DOUBLE, Double.class),
    DECIMAL4(LogicalType.EXACT_NUMERIC, BigDecimal.class),
    DECIMAL8(LogicalType.EXACT_NUMERIC, BigDecimal.class),
    DECIMAL16(LogicalType.EXACT_NUMERIC, BigDecimal.class),
    DATE(LogicalType.DATE, Integer.class),
    TIMESTAMPTZ(LogicalType.TIMESTAMPTZ, Long.class),
    TIMESTAMPNTZ(LogicalType.TIMESTAMPNTZ, Long.class),
    FLOAT(LogicalType.FLOAT, Float.class),
    BINARY(LogicalType.BINARY, ByteBuffer.class),
    STRING(LogicalType.STRING, String.class),
    TIME(LogicalType.TIME, Long.class),
    TIMESTAMPTZ_NANOS(LogicalType.TIMESTAMPTZ, Long.class),
    TIMESTAMPNTZ_NANOS(LogicalType.TIMESTAMPNTZ, Long.class),
    UUID(LogicalType.UUID, String.class),
    ARRAY(LogicalType.ARRAY, List.class),
    OBJECT(LogicalType.OBJECT, Map.class);

    private final LogicalType logicalType;
    private final Class<?> javaClass;

    private PhysicalType(LogicalType logicalType, Class<?> javaClass) {
        this.logicalType = logicalType;
        this.javaClass = javaClass;
    }

    LogicalType toLogicalType() {
        return this.logicalType;
    }

    public Class<?> javaClass() {
        return this.javaClass;
    }

    public static PhysicalType from(int primitiveType) {
        switch (primitiveType) {
            case 0: {
                return NULL;
            }
            case 1: {
                return BOOLEAN_TRUE;
            }
            case 2: {
                return BOOLEAN_FALSE;
            }
            case 3: {
                return INT8;
            }
            case 4: {
                return INT16;
            }
            case 5: {
                return INT32;
            }
            case 6: {
                return INT64;
            }
            case 11: {
                return DATE;
            }
            case 12: {
                return TIMESTAMPTZ;
            }
            case 13: {
                return TIMESTAMPNTZ;
            }
            case 14: {
                return FLOAT;
            }
            case 7: {
                return DOUBLE;
            }
            case 8: {
                return DECIMAL4;
            }
            case 9: {
                return DECIMAL8;
            }
            case 10: {
                return DECIMAL16;
            }
            case 15: {
                return BINARY;
            }
            case 16: {
                return STRING;
            }
            case 17: {
                return TIME;
            }
            case 18: {
                return TIMESTAMPTZ_NANOS;
            }
            case 19: {
                return TIMESTAMPNTZ_NANOS;
            }
            case 20: {
                return UUID;
            }
        }
        throw new UnsupportedOperationException("Unknown primitive physical type: " + primitiveType);
    }
}

