/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.types;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum NotificationType {
    UNKNOWN(0, "UNKNOWN"),
    CREATE(1, "CREATE"),
    UPDATE(2, "UPDATE"),
    DROP(3, "DROP"),
    VALIDATE(4, "VALIDATE");

    private final int id;
    private final String displayName;
    private static final Map<Integer, NotificationType> idToNotificationTypeMap;

    private NotificationType(int id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public static Optional<NotificationType> lookupById(int id) {
        return Optional.ofNullable(idToNotificationTypeMap.get(id));
    }

    public int getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Optional<NotificationType> lookupByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        for (NotificationType notificationType : NotificationType.values()) {
            if (!name.equalsIgnoreCase(notificationType.name())) continue;
            return Optional.of(notificationType);
        }
        return Optional.empty();
    }

    static {
        idToNotificationTypeMap = Arrays.stream(NotificationType.values()).collect(Collectors.toMap(NotificationType::getId, tf -> tf));
    }
}

