/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.rest.RESTSerializers;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PolarisObjectMapperUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisObjectMapperUtil.class);
    private static final ObjectMapper MAPPER = PolarisObjectMapperUtil.configureMapper();

    private static ObjectMapper configureMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        RESTSerializers.registerAll((ObjectMapper)mapper);
        return mapper;
    }

    private PolarisObjectMapperUtil() {
    }

    public static String serializeProperties(Map<String, String> properties) {
        try {
            return MAPPER.writeValueAsString(properties);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("serializeProperties failed: " + ex.getMessage(), ex);
        }
    }

    public static String serialize(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("serialize failed: " + e.getMessage(), e);
        }
    }

    public static <T> T deserialize(String text, Class<T> klass) {
        try {
            return (T)MAPPER.readValue(text, klass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("deserialize failed: " + e.getMessage(), e);
        }
    }

    public static Map<String, String> deserializeProperties(String properties) {
        try {
            return (Map)MAPPER.readValue(properties, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("deserializeProperties failed: " + ex.getMessage(), ex);
        }
    }

    @Nullable
    public static TaskExecutionState parseTaskState(PolarisBaseEntity entity) {
        TaskExecutionState taskExecutionState;
        block19: {
            JsonFactory jfactory = new JsonFactory();
            JsonParser jParser = jfactory.createParser(entity.getProperties());
            try {
                String executorId = null;
                long lastAttemptStartTime = 0L;
                int attemptCount = 0;
                block17: while (jParser.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName;
                    if (jParser.getCurrentToken() != JsonToken.FIELD_NAME) continue;
                    switch (fieldName = jParser.currentName()) {
                        case "lastAttemptExecutorId": {
                            jParser.nextToken();
                            executorId = jParser.getText();
                            continue block17;
                        }
                        case "lastAttemptStartTime": {
                            jParser.nextToken();
                            lastAttemptStartTime = Long.parseLong(jParser.getText());
                            continue block17;
                        }
                        case "attemptCount": {
                            jParser.nextToken();
                            attemptCount = Integer.parseInt(jParser.getText());
                            continue block17;
                        }
                    }
                    JsonToken next = jParser.nextToken();
                    if (next != JsonToken.START_OBJECT && next != JsonToken.START_ARRAY) continue;
                    jParser.skipChildren();
                }
                taskExecutionState = new TaskExecutionState(executorId, lastAttemptStartTime, attemptCount);
                if (jParser == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (jParser != null) {
                        try {
                            jParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.atWarn().addKeyValue("json", (Object)entity.getProperties()).addKeyValue("error", (Object)e.getMessage()).log("Unable to parse task properties");
                    return null;
                }
            }
            jParser.close();
        }
        return taskExecutionState;
    }

    public static class TaskExecutionState {
        public final String executor;
        public final long lastAttemptStartTime;
        final int attemptCount;

        TaskExecutionState(String executor, long lastAttemptStartTime, int attemptCount) {
            this.executor = executor;
            this.lastAttemptStartTime = lastAttemptStartTime;
            this.attemptCount = attemptCount;
        }

        public String getExecutor() {
            return this.executor;
        }

        public long getLastAttemptStartTime() {
            return this.lastAttemptStartTime;
        }

        public int getAttemptCount() {
            return this.attemptCount;
        }
    }
}

