/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import io.quarkiverse.amazon.common.runtime.TlsKeyManagersProviderConfig;
import io.quarkiverse.amazon.common.runtime.TlsTrustManagersProviderConfig;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.configuration.DurationConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import software.amazon.awssdk.http.Protocol;

@ConfigGroup
public interface AsyncHttpClientConfig {
    @WithDefault(value="50")
    public int maxConcurrency();

    @WithDefault(value="10000")
    public int maxPendingConnectionAcquires();

    @WithDefault(value="30S")
    @WithConverter(value=DurationConverter.class)
    public Duration readTimeout();

    @WithDefault(value="30S")
    @WithConverter(value=DurationConverter.class)
    public Duration writeTimeout();

    @WithDefault(value="10S")
    @WithConverter(value=DurationConverter.class)
    public Duration connectionTimeout();

    @WithDefault(value="2S")
    @WithConverter(value=DurationConverter.class)
    public Duration connectionAcquisitionTimeout();

    @WithConverter(value=DurationConverter.class)
    public Optional<Duration> connectionTimeToLive();

    @WithDefault(value="5S")
    @WithConverter(value=DurationConverter.class)
    public Duration connectionMaxIdleTime();

    @WithDefault(value="true")
    public boolean useIdleConnectionReaper();

    @WithDefault(value="false")
    public Boolean tcpKeepAlive();

    @WithDefault(value="http1-1")
    public Protocol protocol();

    public Optional<SslProviderType> sslProvider();

    public Http2Config http2();

    public NettyProxyConfiguration proxy();

    public TlsKeyManagersProviderConfig tlsKeyManagersProvider();

    public TlsTrustManagersProviderConfig tlsTrustManagersProvider();

    public SdkEventLoopGroupConfig eventLoop();

    public Advanced advanced();

    public static enum SslProviderType {
        JDK,
        OPENSSL,
        OPENSSL_REFCNT;

    }

    @ConfigGroup
    public static interface Advanced {
        @WithDefault(value="true")
        public boolean useFutureCompletionThreadPool();
    }

    @ConfigGroup
    public static interface NettyProxyConfiguration {
        @WithDefault(value="false")
        public boolean enabled();

        public Optional<URI> endpoint();

        public Optional<List<String>> nonProxyHosts();
    }

    @ConfigGroup
    public static interface SdkEventLoopGroupConfig {
        @WithDefault(value="false")
        public boolean override();

        public OptionalInt numberOfThreads();

        public Optional<String> threadNamePrefix();
    }

    @ConfigGroup
    public static interface Http2Config {
        @ConfigDocDefault(value="4294967295")
        public Optional<Long> maxStreams();

        @ConfigDocDefault(value="1048576")
        public OptionalInt initialWindowSize();

        @ConfigDocDefault(value="5")
        @WithConverter(value=DurationConverter.class)
        public Optional<Duration> healthCheckPingPeriod();
    }
}

