/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection.hadoop;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.HadoopConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import org.apache.polaris.core.connection.AuthenticationParametersDpo;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.ConnectionType;
import org.apache.polaris.core.identity.dpo.ServiceIdentityInfoDpo;
import org.apache.polaris.core.identity.provider.ServiceIdentityProvider;
import org.apache.polaris.core.secrets.UserSecretsManager;

public class HadoopConnectionConfigInfoDpo
extends ConnectionConfigInfoDpo {
    private final String warehouse;

    public HadoopConnectionConfigInfoDpo(@JsonProperty(value="uri", required=true) @Nonnull String uri, @JsonProperty(value="authenticationParameters", required=true) @Nonnull AuthenticationParametersDpo authenticationParameters, @JsonProperty(value="serviceIdentity", required=false) @Nullable ServiceIdentityInfoDpo serviceIdentityInfo, @JsonProperty(value="warehouse", required=false) @Nullable String remoteCatalogName) {
        super(ConnectionType.HADOOP.getCode(), uri, authenticationParameters, serviceIdentityInfo);
        this.warehouse = remoteCatalogName;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectionTypeCode", this.getConnectionTypeCode()).add("uri", (Object)this.getUri()).add("warehouse", (Object)this.getWarehouse()).add("authenticationParameters", (Object)this.getAuthenticationParameters().toString()).add("serviceIdentity", (Object)this.getServiceIdentity()).toString();
    }

    @Override
    @Nonnull
    public Map<String, String> asIcebergCatalogProperties(UserSecretsManager secretsManager) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("uri", this.getUri());
        if (this.getWarehouse() != null) {
            properties.put("warehouse", this.getWarehouse());
        }
        properties.putAll(this.getAuthenticationParameters().asIcebergCatalogProperties(secretsManager));
        return properties;
    }

    @Override
    public ConnectionConfigInfoDpo withServiceIdentity(@Nonnull ServiceIdentityInfoDpo serviceIdentityInfo) {
        return new HadoopConnectionConfigInfoDpo(this.getUri(), this.getAuthenticationParameters(), serviceIdentityInfo, this.getWarehouse());
    }

    @Override
    public ConnectionConfigInfo asConnectionConfigInfoModel(ServiceIdentityProvider serviceIdentityProvider) {
        return HadoopConnectionConfigInfo.builder().setConnectionType(ConnectionConfigInfo.ConnectionTypeEnum.HADOOP).setUri(this.getUri()).setWarehouse(this.getWarehouse()).setAuthenticationParameters(this.getAuthenticationParameters().asAuthenticationParametersModel()).setServiceIdentity((ServiceIdentityInfo)Optional.ofNullable(this.getServiceIdentity()).map(serviceIdentityInfoDpo -> serviceIdentityInfoDpo.asServiceIdentityInfoModel(serviceIdentityProvider)).orElse(null)).build();
    }
}

