/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.PositionDeletesTable;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.FileRewritePlan;
import org.apache.iceberg.actions.ImmutableRewritePositionDeleteFiles;
import org.apache.iceberg.actions.RewritePositionDeleteFiles;
import org.apache.iceberg.actions.RewritePositionDeletesGroup;
import org.apache.iceberg.actions.SizeBasedFileRewritePlanner;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PartitionUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.StructLikeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinPackRewritePositionDeletePlanner
extends SizeBasedFileRewritePlanner<RewritePositionDeleteFiles.FileGroupInfo, PositionDeletesScanTask, DeleteFile, RewritePositionDeletesGroup> {
    private static final Logger LOG = LoggerFactory.getLogger(BinPackRewritePositionDeletePlanner.class);
    private final Expression filter;
    private final boolean caseSensitive;
    private RewriteJobOrder rewriteJobOrder;

    public BinPackRewritePositionDeletePlanner(Table table) {
        this(table, (Expression)Expressions.alwaysTrue(), false);
    }

    public BinPackRewritePositionDeletePlanner(Table table, Expression filter, boolean caseSensitive) {
        super(table);
        this.caseSensitive = caseSensitive;
        this.filter = filter;
    }

    @Override
    public Set<String> validOptions() {
        return ImmutableSet.builder().addAll(super.validOptions()).add((Object)"rewrite-job-order").build();
    }

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.rewriteJobOrder = RewriteJobOrder.fromName((String)PropertyUtil.propertyAsString(options, "rewrite-job-order", RewritePositionDeleteFiles.REWRITE_JOB_ORDER_DEFAULT));
    }

    @Override
    public FileRewritePlan<RewritePositionDeleteFiles.FileGroupInfo, PositionDeletesScanTask, DeleteFile, RewritePositionDeletesGroup> plan() {
        StructLikeMap<List<List<PositionDeletesScanTask>>> plan = this.planFileGroups();
        SizeBasedFileRewritePlanner.RewriteExecutionContext ctx = new SizeBasedFileRewritePlanner.RewriteExecutionContext();
        Stream<RewritePositionDeletesGroup> groups = plan.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).flatMap(e -> {
            StructLike partition = (StructLike)e.getKey();
            List scanGroups = (List)e.getValue();
            return scanGroups.stream().map(tasks -> {
                long inputSize = this.inputSize(tasks);
                return this.newRewriteGroup(ctx, partition, (List<PositionDeletesScanTask>)tasks, this.inputSplitSize(inputSize), this.expectedOutputFiles(inputSize));
            });
        }).sorted(RewritePositionDeletesGroup.comparator(this.rewriteJobOrder));
        StructLikeMap<Integer> groupsInPartition = plan.transformValues(List::size);
        int totalGroupCount = groupsInPartition.values().stream().reduce(Integer::sum).orElse(0);
        return new FileRewritePlan<RewritePositionDeleteFiles.FileGroupInfo, PositionDeletesScanTask, DeleteFile, RewritePositionDeletesGroup>(CloseableIterable.of((Iterable)groups.collect(Collectors.toList())), totalGroupCount, groupsInPartition);
    }

    @Override
    protected Iterable<PositionDeletesScanTask> filterFiles(Iterable<PositionDeletesScanTask> tasks) {
        return Iterables.filter(tasks, this::outsideDesiredFileSizeRange);
    }

    @Override
    protected Iterable<List<PositionDeletesScanTask>> filterFileGroups(List<List<PositionDeletesScanTask>> groups) {
        return Iterables.filter(groups, group -> this.enoughInputFiles(group) || this.enoughContent(group) || this.tooMuchContent(group));
    }

    @Override
    protected long defaultTargetFileSize() {
        return PropertyUtil.propertyAsLong(this.table().properties(), "write.delete.target-file-size-bytes", 0x4000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructLikeMap<List<List<PositionDeletesScanTask>>> planFileGroups() {
        Table deletesTable = MetadataTableUtils.createMetadataTableInstance(this.table(), MetadataTableType.POSITION_DELETES);
        CloseableIterable<PositionDeletesScanTask> fileTasks = this.planFiles(deletesTable);
        try {
            Types.StructType partitionType = Partitioning.partitionType(deletesTable);
            StructLikeMap<List<PositionDeletesScanTask>> fileTasksByPartition = this.groupByPartition(partitionType, (Iterable<PositionDeletesScanTask>)fileTasks);
            StructLikeMap<List<List<PositionDeletesScanTask>>> structLikeMap = fileTasksByPartition.transformValues(tasks -> ImmutableList.copyOf(this.planFileGroups(tasks)));
            return structLikeMap;
        }
        finally {
            try {
                fileTasks.close();
            }
            catch (IOException io) {
                LOG.error("Cannot properly close file iterable while planning for rewrite", (Throwable)io);
            }
        }
    }

    private CloseableIterable<PositionDeletesScanTask> planFiles(Table deletesTable) {
        PositionDeletesTable.PositionDeletesBatchScan scan = (PositionDeletesTable.PositionDeletesBatchScan)deletesTable.newBatchScan();
        return CloseableIterable.transform((CloseableIterable)((BatchScan)((BatchScan)scan.baseTableFilter(this.filter).caseSensitive(this.caseSensitive)).ignoreResiduals()).planFiles(), PositionDeletesScanTask.class::cast);
    }

    private StructLikeMap<List<PositionDeletesScanTask>> groupByPartition(Types.StructType partitionType, Iterable<PositionDeletesScanTask> tasks) {
        StructLikeMap<List<PositionDeletesScanTask>> filesByPartition = StructLikeMap.create(partitionType);
        for (PositionDeletesScanTask task : tasks) {
            StructLike coerced = PartitionUtil.coercePartition(partitionType, task.spec(), task.partition());
            ArrayList partitionTasks = filesByPartition.get(coerced);
            if (partitionTasks == null) {
                partitionTasks = Lists.newArrayList();
            }
            partitionTasks.add(task);
            filesByPartition.put(coerced, partitionTasks);
        }
        return filesByPartition;
    }

    private RewritePositionDeletesGroup newRewriteGroup(SizeBasedFileRewritePlanner.RewriteExecutionContext ctx, StructLike partition, List<PositionDeletesScanTask> tasks, long inputSplitSize, int expectedOutputFiles) {
        ImmutableRewritePositionDeleteFiles.FileGroupInfo info = ImmutableRewritePositionDeleteFiles.FileGroupInfo.builder().globalIndex(ctx.currentGlobalIndex()).partitionIndex(ctx.currentPartitionIndex(partition)).partition(partition).build();
        return new RewritePositionDeletesGroup(info, Lists.newArrayList(tasks), this.writeMaxFileSize(), inputSplitSize, expectedOutputFiles);
    }
}

