/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.credentials;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.credentials.ImmutableCredential;
import org.apache.iceberg.util.JsonUtil;

public class CredentialParser {
    private static final String PREFIX = "prefix";
    private static final String CONFIG = "config";

    private CredentialParser() {
    }

    public static String toJson(Credential credential) {
        return CredentialParser.toJson(credential, false);
    }

    public static String toJson(Credential credential, boolean pretty) {
        return JsonUtil.generate(gen -> CredentialParser.toJson(credential, gen), pretty);
    }

    public static void toJson(Credential credential, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != credential ? 1 : 0) != 0, (Object)"Invalid credential: null");
        gen.writeStartObject();
        gen.writeStringField(PREFIX, credential.prefix());
        JsonUtil.writeStringMap(CONFIG, credential.config(), gen);
        gen.writeEndObject();
    }

    public static Credential fromJson(String json) {
        return JsonUtil.parse(json, CredentialParser::fromJson);
    }

    public static Credential fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse credential from null object");
        String prefix = JsonUtil.getString(PREFIX, json);
        Map<String, String> config = JsonUtil.getStringMap(CONFIG, json);
        return ImmutableCredential.builder().prefix(prefix).config(config).build();
    }
}

