/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.iceberg.util.StructLikeWrapper;

public class StructLikeMap<T>
extends AbstractMap<StructLike, T>
implements Map<StructLike, T> {
    private final Types.StructType type;
    private final Map<StructLikeWrapper, T> wrapperMap;
    private final ThreadLocal<StructLikeWrapper> wrappers;

    public static <T> StructLikeMap<T> create(Types.StructType type, Comparator<StructLike> comparator) {
        return new StructLikeMap<T>(type, comparator);
    }

    public static <T> StructLikeMap<T> create(Types.StructType type) {
        return StructLikeMap.create(type, Comparators.forType((Types.StructType)type));
    }

    private StructLikeMap(Types.StructType type, Comparator<StructLike> comparator) {
        this.type = type;
        this.wrapperMap = Maps.newHashMap();
        this.wrappers = ThreadLocal.withInitial(() -> StructLikeWrapper.forType(type, comparator));
    }

    @Override
    public int size() {
        return this.wrapperMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapperMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof StructLike || key == null) {
            StructLikeWrapper wrapper = this.wrappers.get();
            boolean result = this.wrapperMap.containsKey(wrapper.set((StructLike)key));
            wrapper.set(null);
            return result;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapperMap.containsValue(value);
    }

    @Override
    public T get(Object key) {
        if (key instanceof StructLike || key == null) {
            StructLikeWrapper wrapper = this.wrappers.get();
            T value = this.wrapperMap.get(wrapper.set((StructLike)key));
            wrapper.set(null);
            return value;
        }
        return null;
    }

    @Override
    public T put(StructLike key, T value) {
        return this.wrapperMap.put(this.wrappers.get().copyFor(key), value);
    }

    @Override
    public T remove(Object key) {
        if (key instanceof StructLike || key == null) {
            StructLikeWrapper wrapper = this.wrappers.get();
            T value = this.wrapperMap.remove(wrapper.set((StructLike)key));
            wrapper.set(null);
            return value;
        }
        return null;
    }

    @Override
    public void clear() {
        this.wrapperMap.clear();
    }

    @Override
    public Set<StructLike> keySet() {
        StructLikeSet keySet = StructLikeSet.create(this.type);
        for (StructLikeWrapper wrapper : this.wrapperMap.keySet()) {
            keySet.add(wrapper.get());
        }
        return keySet;
    }

    @Override
    public Collection<T> values() {
        return this.wrapperMap.values();
    }

    @Override
    public Set<Map.Entry<StructLike, T>> entrySet() {
        HashSet entrySet = Sets.newHashSet();
        for (Map.Entry<StructLikeWrapper, T> entry : this.wrapperMap.entrySet()) {
            entrySet.add(new StructLikeEntry<T>(entry));
        }
        return entrySet;
    }

    public T computeIfAbsent(StructLike struct, Supplier<T> valueSupplier) {
        return (T)this.wrapperMap.computeIfAbsent(this.wrappers.get().copyFor(struct), (? super K key) -> valueSupplier.get());
    }

    public <U> StructLikeMap<U> transformValues(Function<T, U> func) {
        StructLikeMap result = StructLikeMap.create(this.type);
        this.wrapperMap.forEach((key, value) -> result.put(key.get(), func.apply(value)));
        return result;
    }

    private static class StructLikeEntry<R>
    implements Map.Entry<StructLike, R> {
        private final Map.Entry<StructLikeWrapper, R> inner;

        private StructLikeEntry(Map.Entry<StructLikeWrapper, R> inner) {
            this.inner = inner;
        }

        @Override
        public StructLike getKey() {
            return this.inner.getKey().get();
        }

        @Override
        public R getValue() {
            return this.inner.getValue();
        }

        @Override
        public int hashCode() {
            return this.inner.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructLikeEntry that = (StructLikeEntry)o;
            return this.inner.equals(that.inner);
        }

        @Override
        public R setValue(R value) {
            throw new UnsupportedOperationException("Does not support setValue.");
        }
    }
}

