/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.apache.polaris.core.admin.model.AddGrantRequest;
import org.apache.polaris.core.admin.model.Catalog;
import org.apache.polaris.core.admin.model.CatalogGrant;
import org.apache.polaris.core.admin.model.CatalogRole;
import org.apache.polaris.core.admin.model.CreateCatalogRequest;
import org.apache.polaris.core.admin.model.CreateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.NamespaceGrant;
import org.apache.polaris.core.admin.model.PolicyGrant;
import org.apache.polaris.core.admin.model.RevokeGrantRequest;
import org.apache.polaris.core.admin.model.TableGrant;
import org.apache.polaris.core.admin.model.UpdateCatalogRequest;
import org.apache.polaris.core.admin.model.UpdateCatalogRoleRequest;
import org.apache.polaris.core.admin.model.ViewGrant;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.service.admin.api.PolarisCatalogsApiService;
import org.apache.polaris.service.events.CatalogsServiceEvents;
import org.apache.polaris.service.events.listeners.PolarisEventListener;

@Decorator
@Priority(value=1000)
public class PolarisCatalogsEventServiceDelegator
implements PolarisCatalogsApiService {
    @Inject
    @Delegate
    PolarisCatalogsApiService delegate;
    @Inject
    PolarisEventListener polarisEventListener;

    public Response createCatalog(CreateCatalogRequest request, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeCreateCatalog(new CatalogsServiceEvents.BeforeCreateCatalogEvent(request.getCatalog().getName()));
        Response resp = this.delegate.createCatalog(request, realmContext, securityContext);
        this.polarisEventListener.onAfterCreateCatalog(new CatalogsServiceEvents.AfterCreateCatalogEvent((Catalog)resp.getEntity()));
        return resp;
    }

    public Response deleteCatalog(String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeDeleteCatalog(new CatalogsServiceEvents.BeforeDeleteCatalogEvent(catalogName));
        Response resp = this.delegate.deleteCatalog(catalogName, realmContext, securityContext);
        this.polarisEventListener.onAfterDeleteCatalog(new CatalogsServiceEvents.AfterDeleteCatalogEvent(catalogName));
        return resp;
    }

    public Response getCatalog(String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeGetCatalog(new CatalogsServiceEvents.BeforeGetCatalogEvent(catalogName));
        Response resp = this.delegate.getCatalog(catalogName, realmContext, securityContext);
        this.polarisEventListener.onAfterGetCatalog(new CatalogsServiceEvents.AfterGetCatalogEvent((Catalog)resp.getEntity()));
        return resp;
    }

    public Response updateCatalog(String catalogName, UpdateCatalogRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeUpdateCatalog(new CatalogsServiceEvents.BeforeUpdateCatalogEvent(catalogName, updateRequest));
        Response resp = this.delegate.updateCatalog(catalogName, updateRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterUpdateCatalog(new CatalogsServiceEvents.AfterUpdateCatalogEvent((Catalog)resp.getEntity()));
        return resp;
    }

    public Response listCatalogs(RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeListCatalogs(new CatalogsServiceEvents.BeforeListCatalogsEvent());
        Response resp = this.delegate.listCatalogs(realmContext, securityContext);
        this.polarisEventListener.onAfterListCatalogs(new CatalogsServiceEvents.AfterListCatalogsEvent());
        return resp;
    }

    public Response createCatalogRole(String catalogName, CreateCatalogRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeCreateCatalogRole(new CatalogsServiceEvents.BeforeCreateCatalogRoleEvent(catalogName, request.getCatalogRole().getName()));
        Response resp = this.delegate.createCatalogRole(catalogName, request, realmContext, securityContext);
        this.polarisEventListener.onAfterCreateCatalogRole(new CatalogsServiceEvents.AfterCreateCatalogRoleEvent(catalogName, (CatalogRole)resp.getEntity()));
        return resp;
    }

    public Response deleteCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeDeleteCatalogRole(new CatalogsServiceEvents.BeforeDeleteCatalogRoleEvent(catalogName, catalogRoleName));
        Response resp = this.delegate.deleteCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
        this.polarisEventListener.onAfterDeleteCatalogRole(new CatalogsServiceEvents.AfterDeleteCatalogRoleEvent(catalogName, catalogRoleName));
        return resp;
    }

    public Response getCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeGetCatalogRole(new CatalogsServiceEvents.BeforeGetCatalogRoleEvent(catalogName, catalogRoleName));
        Response resp = this.delegate.getCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
        this.polarisEventListener.onAfterGetCatalogRole(new CatalogsServiceEvents.AfterGetCatalogRoleEvent(catalogName, (CatalogRole)resp.getEntity()));
        return resp;
    }

    public Response updateCatalogRole(String catalogName, String catalogRoleName, UpdateCatalogRoleRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeUpdateCatalogRole(new CatalogsServiceEvents.BeforeUpdateCatalogRoleEvent(catalogName, catalogRoleName, updateRequest));
        Response resp = this.delegate.updateCatalogRole(catalogName, catalogRoleName, updateRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterUpdateCatalogRole(new CatalogsServiceEvents.AfterUpdateCatalogRoleEvent(catalogName, (CatalogRole)resp.getEntity()));
        return resp;
    }

    public Response listCatalogRoles(String catalogName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onAfterListCatalogRoles(new CatalogsServiceEvents.AfterListCatalogRolesEvent(catalogName));
        Response resp = this.delegate.listCatalogRoles(catalogName, realmContext, securityContext);
        this.polarisEventListener.onBeforeListCatalogRoles(new CatalogsServiceEvents.BeforeListCatalogRolesEvent(catalogName));
        return resp;
    }

    public Response addGrantToCatalogRole(String catalogName, String catalogRoleName, AddGrantRequest grantRequest, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeAddGrantToCatalogRole(new CatalogsServiceEvents.BeforeAddGrantToCatalogRoleEvent(catalogName, catalogRoleName, grantRequest));
        Response resp = this.delegate.addGrantToCatalogRole(catalogName, catalogRoleName, grantRequest, realmContext, securityContext);
        GrantResource grantResource = grantRequest.getGrant();
        this.polarisEventListener.onAfterAddGrantToCatalogRole(new CatalogsServiceEvents.AfterAddGrantToCatalogRoleEvent(catalogName, catalogRoleName, this.getPrivilegeFromGrantResource(grantResource), grantResource));
        return resp;
    }

    public Response revokeGrantFromCatalogRole(String catalogName, String catalogRoleName, Boolean cascade, RevokeGrantRequest grantRequest, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeRevokeGrantFromCatalogRole(new CatalogsServiceEvents.BeforeRevokeGrantFromCatalogRoleEvent(catalogName, catalogRoleName, grantRequest, cascade));
        Response resp = this.delegate.revokeGrantFromCatalogRole(catalogName, catalogRoleName, cascade, grantRequest, realmContext, securityContext);
        GrantResource grantResource = grantRequest.getGrant();
        this.polarisEventListener.onAfterRevokeGrantFromCatalogRole(new CatalogsServiceEvents.AfterRevokeGrantFromCatalogRoleEvent(catalogName, catalogRoleName, this.getPrivilegeFromGrantResource(grantResource), grantResource, cascade));
        return resp;
    }

    public Response listAssigneePrincipalRolesForCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeListAssigneePrincipalRolesForCatalogRole(new CatalogsServiceEvents.BeforeListAssigneePrincipalRolesForCatalogRoleEvent(catalogName, catalogRoleName));
        Response resp = this.delegate.listAssigneePrincipalRolesForCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
        this.polarisEventListener.onAfterListAssigneePrincipalRolesForCatalogRole(new CatalogsServiceEvents.AfterListAssigneePrincipalRolesForCatalogRoleEvent(catalogName, catalogRoleName));
        return resp;
    }

    public Response listGrantsForCatalogRole(String catalogName, String catalogRoleName, RealmContext realmContext, SecurityContext securityContext) {
        this.polarisEventListener.onBeforeListGrantsForCatalogRole(new CatalogsServiceEvents.BeforeListGrantsForCatalogRoleEvent(catalogName, catalogRoleName));
        Response resp = this.delegate.listGrantsForCatalogRole(catalogName, catalogRoleName, realmContext, securityContext);
        this.polarisEventListener.onAfterListGrantsForCatalogRole(new CatalogsServiceEvents.AfterListGrantsForCatalogRoleEvent(catalogName, catalogRoleName));
        return resp;
    }

    private PolarisPrivilege getPrivilegeFromGrantResource(GrantResource grantResource) {
        GrantResource grantResource2 = grantResource;
        Objects.requireNonNull(grantResource2);
        GrantResource grantResource3 = grantResource2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ViewGrant.class, TableGrant.class, NamespaceGrant.class, CatalogGrant.class, PolicyGrant.class}, (Object)grantResource3, n)) {
            case 0 -> {
                ViewGrant viewGrant = (ViewGrant)grantResource3;
                yield PolarisPrivilege.valueOf((String)viewGrant.getPrivilege().toString());
            }
            case 1 -> {
                TableGrant tableGrant = (TableGrant)grantResource3;
                yield PolarisPrivilege.valueOf((String)tableGrant.getPrivilege().toString());
            }
            case 2 -> {
                NamespaceGrant namespaceGrant = (NamespaceGrant)grantResource3;
                yield PolarisPrivilege.valueOf((String)namespaceGrant.getPrivilege().toString());
            }
            case 3 -> {
                CatalogGrant catalogGrant = (CatalogGrant)grantResource3;
                yield PolarisPrivilege.valueOf((String)catalogGrant.getPrivilege().toString());
            }
            case 4 -> {
                PolicyGrant policyGrant = (PolicyGrant)grantResource3;
                yield PolarisPrivilege.valueOf((String)policyGrant.getPrivilege().toString());
            }
            default -> null;
        };
    }
}

