/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.SecurityContext;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.iceberg.exceptions.UnprocessableEntityException;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.BaseMetastoreViewCatalog;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewMetadataParser;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewUtil;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import org.apache.polaris.core.catalog.PolarisCatalogHelpers;
import org.apache.polaris.core.config.BehaviorChangeConfiguration;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.LocationBasedEntity;
import org.apache.polaris.core.entity.NamespaceEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.table.GenericTableEntity;
import org.apache.polaris.core.entity.table.IcebergTableLikeEntity;
import org.apache.polaris.core.exceptions.CommitConflictException;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.dao.entity.DropEntityResult;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.core.persistence.dao.entity.ListEntitiesResult;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifestCatalogView;
import org.apache.polaris.core.persistence.resolver.ResolverFactory;
import org.apache.polaris.core.persistence.resolver.ResolverPath;
import org.apache.polaris.core.persistence.resolver.ResolverStatus;
import org.apache.polaris.core.storage.AccessConfig;
import org.apache.polaris.core.storage.PolarisCredentialVendor;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.StorageLocation;
import org.apache.polaris.core.storage.StorageUtil;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;
import org.apache.polaris.service.catalog.SupportsNotifications;
import org.apache.polaris.service.catalog.common.LocationUtils;
import org.apache.polaris.service.catalog.iceberg.SupportsCredentialDelegation;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.catalog.io.FileIOUtil;
import org.apache.polaris.service.catalog.validation.IcebergPropertiesValidation;
import org.apache.polaris.service.events.IcebergRestCatalogEvents;
import org.apache.polaris.service.events.listeners.PolarisEventListener;
import org.apache.polaris.service.exception.IcebergExceptionMapper;
import org.apache.polaris.service.task.TaskExecutor;
import org.apache.polaris.service.types.NotificationRequest;
import org.apache.polaris.service.types.NotificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalog
extends BaseMetastoreViewCatalog
implements SupportsNamespaces,
SupportsNotifications,
Closeable,
SupportsCredentialDelegation {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergCatalog.class);
    private static final Joiner SLASH = Joiner.on((String)"/");
    public static final Predicate<Exception> SHOULD_RETRY_REFRESH_PREDICATE = ex -> !(ex instanceof NotFoundException) && !(ex instanceof IllegalArgumentException) && !(ex instanceof AlreadyExistsException) && !(ex instanceof ForbiddenException) && !(ex instanceof UnprocessableEntityException) && (IcebergExceptionMapper.isStorageProviderRetryableException(ex) || IcebergExceptionMapper.isStorageProviderRetryableException(Throwables.getRootCause((Throwable)ex)));
    private final PolarisDiagnostics diagnostics;
    private final StorageCredentialCache storageCredentialCache;
    private final ResolverFactory resolverFactory;
    private final CallContext callContext;
    private final RealmConfig realmConfig;
    private final PolarisResolutionManifestCatalogView resolvedEntityView;
    private final CatalogEntity catalogEntity;
    private final TaskExecutor taskExecutor;
    private final SecurityContext securityContext;
    private final PolarisEventListener polarisEventListener;
    private final AtomicBoolean loggedPrefixOverlapWarning = new AtomicBoolean(false);
    private String ioImplClassName;
    private FileIO catalogFileIO;
    private CloseableGroup closeableGroup;
    private Map<String, String> tableDefaultProperties;
    private final String catalogName;
    private long catalogId = -1L;
    private String defaultBaseLocation;
    private Map<String, String> catalogProperties;
    private FileIOFactory fileIOFactory;
    private PolarisMetaStoreManager metaStoreManager;

    public IcebergCatalog(PolarisDiagnostics diagnostics, StorageCredentialCache storageCredentialCache, ResolverFactory resolverFactory, PolarisMetaStoreManager metaStoreManager, CallContext callContext, PolarisResolutionManifestCatalogView resolvedEntityView, SecurityContext securityContext, TaskExecutor taskExecutor, FileIOFactory fileIOFactory, PolarisEventListener polarisEventListener) {
        this.diagnostics = diagnostics;
        this.storageCredentialCache = storageCredentialCache;
        this.resolverFactory = resolverFactory;
        this.callContext = callContext;
        this.realmConfig = callContext.getRealmConfig();
        this.resolvedEntityView = resolvedEntityView;
        this.catalogEntity = resolvedEntityView.getResolvedCatalogEntity();
        this.securityContext = securityContext;
        this.taskExecutor = taskExecutor;
        this.catalogId = this.catalogEntity.getId();
        this.catalogName = this.catalogEntity.getName();
        this.fileIOFactory = fileIOFactory;
        this.metaStoreManager = metaStoreManager;
        this.polarisEventListener = polarisEventListener;
    }

    public String name() {
        return this.catalogName;
    }

    @VisibleForTesting
    public void setCatalogFileIo(FileIO fileIO) {
        this.catalogFileIO = fileIO;
    }

    public void initialize(String name, Map<String, String> properties) {
        Preconditions.checkState((boolean)this.catalogName.equals(name), (String)"Tried to initialize catalog as name %s but already constructed with name %s", (Object)name, (Object)this.catalogName);
        this.catalogProperties = properties;
        String baseLocation = Optional.ofNullable(this.catalogEntity.getBaseLocation()).orElse(properties.getOrDefault("default-base-location", properties.getOrDefault("warehouse", "")));
        this.defaultBaseLocation = baseLocation.replaceAll("/*$", "");
        PolarisStorageConfigurationInfo storageConfigurationInfo = this.catalogEntity.getStorageConfigurationInfo();
        this.ioImplClassName = IcebergPropertiesValidation.determineFileIOClassName(this.realmConfig, properties, storageConfigurationInfo);
        if (this.ioImplClassName == null) {
            LOGGER.warn("Cannot resolve property '{}' for null storageConfiguration.", (Object)"io-impl");
        }
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.addCloseable((Closeable)this.metricsReporter());
        this.closeableGroup.setSuppressCloseFailure(true);
        this.tableDefaultProperties = PropertyUtil.propertiesWithPrefix(properties, (String)"table-default.");
    }

    public void setMetaStoreManager(PolarisMetaStoreManager newMetaStoreManager) {
        this.metaStoreManager = newMetaStoreManager;
    }

    protected Map<String, String> properties() {
        return this.catalogProperties == null ? ImmutableMap.of() : this.catalogProperties;
    }

    public Table registerTable(TableIdentifier identifier, String metadataFileLocation) {
        Preconditions.checkArgument((identifier != null && this.isValidIdentifier(identifier) ? 1 : 0) != 0, (String)"Invalid identifier: %s", (Object)identifier);
        Preconditions.checkArgument((metadataFileLocation != null && !metadataFileLocation.isEmpty() ? 1 : 0) != 0, (Object)"Cannot register an empty metadata file location as a table");
        int lastSlashIndex = metadataFileLocation.lastIndexOf("/");
        Preconditions.checkArgument((lastSlashIndex != -1 ? 1 : 0) != 0, (String)"Invalid metadata file location; metadata file location must be absolute and contain a '/': %s", (Object)metadataFileLocation);
        if (this.tableExists(identifier)) {
            throw new AlreadyExistsException("Table already exists: %s", new Object[]{identifier});
        }
        String locationDir = metadataFileLocation.substring(0, lastSlashIndex);
        TableOperations ops = this.newTableOps(identifier);
        PolarisResolvedPathWrapper resolvedParent = this.resolvedEntityView.getResolvedPath((Object)identifier.namespace());
        if (resolvedParent == null) {
            throw new IllegalStateException(String.format("Failed to fetch resolved parent for TableIdentifier '%s'", identifier));
        }
        FileIO fileIO = this.loadFileIOForTableLike(identifier, Set.of(locationDir), resolvedParent, new HashMap<String, String>(this.tableDefaultProperties), Set.of(PolarisStorageActions.READ, PolarisStorageActions.LIST));
        InputFile metadataFile = fileIO.newInputFile(metadataFileLocation);
        TableMetadata metadata = TableMetadataParser.read((InputFile)metadataFile);
        ops.commit(null, metadata);
        return new BaseTable(ops, IcebergCatalog.fullTableName((String)this.name(), (TableIdentifier)identifier), this.metricsReporter());
    }

    public Catalog.TableBuilder buildTable(TableIdentifier identifier, Schema schema) {
        return new PolarisIcebergCatalogTableBuilder(identifier, schema);
    }

    public ViewBuilder buildView(TableIdentifier identifier) {
        return new PolarisIcebergCatalogViewBuilder(identifier);
    }

    @VisibleForTesting
    public TableOperations newTableOps(TableIdentifier tableIdentifier, boolean makeMetadataCurrentOnCommit) {
        return new BasePolarisTableOperations(this.catalogFileIO, tableIdentifier, makeMetadataCurrentOnCommit);
    }

    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        boolean makeMetadataCurrentOnCommit = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)BehaviorChangeConfiguration.TABLE_OPERATIONS_MAKE_METADATA_CURRENT_ON_COMMIT);
        return this.newTableOps(tableIdentifier, makeMetadataCurrentOnCommit);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        if (tableIdentifier.namespace().isEmpty()) {
            return SLASH.join((Object)this.defaultNamespaceLocation(tableIdentifier.namespace()), (Object)tableIdentifier.name(), new Object[0]);
        }
        PolarisResolvedPathWrapper resolvedNamespace = this.resolvedEntityView.getResolvedPath((Object)tableIdentifier.namespace());
        if (resolvedNamespace == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{tableIdentifier.namespace()});
        }
        List namespacePath = resolvedNamespace.getRawFullPath();
        String namespaceLocation = IcebergCatalog.resolveLocationForPath(this.diagnostics, namespacePath);
        return SLASH.join((Object)namespaceLocation, (Object)tableIdentifier.name(), new Object[0]);
    }

    private String defaultNamespaceLocation(Namespace namespace) {
        if (namespace.isEmpty()) {
            return this.defaultBaseLocation;
        }
        return SLASH.join((Object)this.defaultBaseLocation, (Object)SLASH.join((Object[])namespace.levels()), new Object[0]);
    }

    public boolean dropTable(TableIdentifier tableIdentifier, boolean purge) {
        TableOperations ops = this.newTableOps(tableIdentifier);
        TableMetadata lastMetadata = purge && ops.current() != null ? ops.current() : null;
        Optional<PolarisEntity> storageInfoEntity = this.findStorageInfo(tableIdentifier);
        Map<String, String> storageProperties = storageInfoEntity.map(PolarisBaseEntity::getInternalPropertiesAsMap).map(properties -> {
            if (lastMetadata == null) {
                return Map.of();
            }
            HashMap<String, String> clone = new HashMap<String, String>();
            clone.putAll(lastMetadata.properties());
            clone.put("io-impl", this.ioImplClassName);
            clone.putAll((Map<String, String>)properties);
            clone.put("storageLocation", lastMetadata.location());
            return clone;
        }).orElse(Map.of());
        DropEntityResult dropEntityResult = this.dropTableLike(PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier, storageProperties, purge);
        if (!dropEntityResult.isSuccess()) {
            return false;
        }
        if (purge && lastMetadata != null && dropEntityResult.getCleanupTaskId() != null) {
            LOGGER.info("Scheduled cleanup task {} for table {}", (Object)dropEntityResult.getCleanupTaskId(), (Object)tableIdentifier);
            this.taskExecutor.addTaskHandlerContext(dropEntityResult.getCleanupTaskId(), this.callContext);
        }
        return true;
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        return this.listTables(namespace, PageToken.readEverything()).items();
    }

    public Page<TableIdentifier> listTables(Namespace namespace, PageToken pageToken) {
        if (!this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException("Cannot list tables for namespace. Namespace does not exist: '%s'", new Object[]{namespace});
        }
        return this.listTableLike(PolarisEntitySubType.ICEBERG_TABLE, namespace, pageToken);
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        if (from.equals((Object)to)) {
            return;
        }
        this.renameTableLike(PolarisEntitySubType.ICEBERG_TABLE, from, to);
    }

    public void createNamespace(Namespace namespace) {
        this.createNamespace(namespace, Collections.emptyMap());
    }

    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
        LOGGER.debug("Creating namespace {} with metadata {}", (Object)namespace, metadata);
        if (namespace.isEmpty()) {
            throw new AlreadyExistsException("Cannot create root namespace, as it already exists implicitly.", new Object[0]);
        }
        Namespace parentNamespace = PolarisCatalogHelpers.getParentNamespace((Namespace)namespace);
        PolarisResolvedPathWrapper resolvedParent = this.resolvedEntityView.getResolvedPath((Object)parentNamespace);
        if (resolvedParent == null) {
            throw new NoSuchNamespaceException("Cannot create namespace %s. Parent namespace does not exist.", new Object[]{namespace});
        }
        this.createNamespaceInternal(namespace, metadata, resolvedParent);
    }

    private void createNamespaceInternal(Namespace namespace, Map<String, String> metadata, PolarisResolvedPathWrapper resolvedParent) {
        EntityResult result;
        Object baseLocation = this.resolveNamespaceLocation(namespace, metadata);
        boolean requireTrailingSlash = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ADD_TRAILING_SLASH_TO_LOCATION);
        if (requireTrailingSlash && !((String)baseLocation).endsWith("/")) {
            baseLocation = (String)baseLocation + "/";
        }
        NamespaceEntity entity = ((NamespaceEntity.Builder)((NamespaceEntity.Builder)((NamespaceEntity.Builder)((NamespaceEntity.Builder)((NamespaceEntity.Builder)new NamespaceEntity.Builder(namespace).setCatalogId(this.getCatalogId())).setId(this.getMetaStoreManager().generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setParentId(resolvedParent.getRawLeafEntity().getId())).setProperties(metadata)).setCreateTimestamp(System.currentTimeMillis())).setBaseLocation((String)baseLocation).build();
        if (!((Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_NAMESPACE_LOCATION_OVERLAP)).booleanValue()) {
            LOGGER.debug("Validating no overlap for {} with sibling tables or namespaces", (Object)namespace);
            this.validateNoLocationOverlap(entity, resolvedParent.getRawFullPath());
        } else {
            LOGGER.debug("Skipping location overlap validation for namespace '{}'", (Object)namespace);
        }
        if (!((Boolean)this.realmConfig.getConfig((PolarisConfiguration)BehaviorChangeConfiguration.ALLOW_NAMESPACE_CUSTOM_LOCATION, this.catalogEntity)).booleanValue()) {
            this.validateNamespaceLocation(entity, resolvedParent);
        }
        if (!(result = this.getMetaStoreManager().createEntityIfNotExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)resolvedParent.getRawFullPath()), (PolarisBaseEntity)entity)).isSuccess()) {
            if (result.alreadyExists()) {
                throw new AlreadyExistsException("Cannot create namespace %s. Namespace already exists", new Object[]{namespace});
            }
            throw new ServiceFailureException("Unexpected error trying to create namespace %s. Status: %s ExtraInfo: %s", new Object[]{namespace, result.getReturnStatus(), result.getExtraInformation()});
        }
    }

    private String resolveNamespaceLocation(Namespace namespace, Map<String, String> properties) {
        if (properties.containsKey("location")) {
            return properties.get("location");
        }
        List<CatalogEntity> parentPath = namespace.length() > 1 ? this.getResolvedParentNamespace(namespace).getRawFullPath() : List.of(this.resolvedEntityView.getResolvedCatalogEntity());
        String parentLocation = IcebergCatalog.resolveLocationForPath(this.diagnostics, parentPath);
        return parentLocation + "/" + namespace.level(namespace.length() - 1);
    }

    @Nonnull
    private static String resolveLocationForPath(@Nonnull PolarisDiagnostics diagnostics, List<PolarisEntity> parentPath) {
        AtomicBoolean foundBaseLocation = new AtomicBoolean(false);
        return parentPath.reversed().stream().takeWhile(entity -> !foundBaseLocation.getAndSet(entity.getPropertiesAsMap().containsKey("location"))).toList().reversed().stream().map(entity -> IcebergCatalog.baseLocation(diagnostics, entity)).map(IcebergCatalog::stripLeadingTrailingSlash).collect(Collectors.joining("/"));
    }

    @Nullable
    private static String baseLocation(@Nonnull PolarisDiagnostics diagnostics, PolarisEntity entity) {
        if (entity.getType().equals((Object)PolarisEntityType.CATALOG)) {
            CatalogEntity catEntity = CatalogEntity.of((PolarisBaseEntity)entity);
            String catalogDefaultBaseLocation = catEntity.getBaseLocation();
            diagnostics.checkNotNull((Object)catalogDefaultBaseLocation, "Tried to resolve location with catalog with null default base location", "catalog = {}", new Object[]{catEntity});
            return catalogDefaultBaseLocation;
        }
        String baseLocation = (String)entity.getPropertiesAsMap().get("location");
        if (baseLocation != null) {
            return baseLocation;
        }
        String entityName = entity.getName();
        diagnostics.checkNotNull((Object)entityName, "Tried to resolve location with entity without base location or name", "entity = {}", new Object[]{entity});
        return entityName;
    }

    private static String stripLeadingTrailingSlash(String location) {
        if (location.startsWith("/")) {
            return IcebergCatalog.stripLeadingTrailingSlash(location.substring(1));
        }
        if (location.endsWith("/")) {
            return location.substring(0, location.length() - 1);
        }
        return location;
    }

    private PolarisResolvedPathWrapper getResolvedParentNamespace(Namespace namespace) {
        Namespace parentNamespace = Namespace.of((String[])Arrays.copyOf(namespace.levels(), namespace.length() - 1));
        PolarisResolvedPathWrapper resolvedParent = this.resolvedEntityView.getResolvedPath((Object)parentNamespace);
        if (resolvedParent == null) {
            return this.resolvedEntityView.getPassthroughResolvedPath((Object)parentNamespace);
        }
        return resolvedParent;
    }

    public boolean namespaceExists(Namespace namespace) {
        return Optional.ofNullable(namespace).filter(ns -> !ns.isEmpty()).map(arg_0 -> ((PolarisResolutionManifestCatalogView)this.resolvedEntityView).getResolvedPath(arg_0)).isPresent();
    }

    public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
        if (namespace.isEmpty()) {
            throw new IllegalArgumentException("Cannot drop root namespace");
        }
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)namespace);
        if (resolvedEntities == null) {
            return false;
        }
        List catalogPath = resolvedEntities.getRawParentPath();
        PolarisEntity leafEntity = resolvedEntities.getRawLeafEntity();
        DropEntityResult dropEntityResult = this.getMetaStoreManager().dropEntityIfExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)leafEntity, Map.of(), ((Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.CLEANUP_ON_NAMESPACE_DROP)).booleanValue());
        if (!dropEntityResult.isSuccess() && dropEntityResult.failedBecauseNotEmpty()) {
            throw new NamespaceNotEmptyException("Namespace %s is not empty", new Object[]{namespace});
        }
        return dropEntityResult.isSuccess();
    }

    public boolean setProperties(Namespace namespace, Map<String, String> properties) throws NoSuchNamespaceException {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)namespace);
        if (resolvedEntities == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        PolarisEntity entity = resolvedEntities.getRawLeafEntity();
        HashMap<String, String> newProperties = new HashMap<String, String>(entity.getPropertiesAsMap());
        newProperties.putAll(properties);
        PolarisEntity updatedEntity = ((PolarisEntity.Builder)new PolarisEntity.Builder(entity).setProperties(newProperties)).build();
        if (!((Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_NAMESPACE_LOCATION_OVERLAP)).booleanValue()) {
            LOGGER.debug("Validating no overlap with sibling tables or namespaces");
            this.validateNoLocationOverlap(NamespaceEntity.of((PolarisBaseEntity)updatedEntity), resolvedEntities.getRawParentPath());
        } else {
            LOGGER.debug("Skipping location overlap validation for namespace '{}'", (Object)namespace);
        }
        if (!((Boolean)this.realmConfig.getConfig((PolarisConfiguration)BehaviorChangeConfiguration.ALLOW_NAMESPACE_CUSTOM_LOCATION, this.catalogEntity)).booleanValue() && properties.containsKey("location")) {
            this.validateNamespaceLocation(NamespaceEntity.of((PolarisBaseEntity)entity), resolvedEntities);
        }
        List parentPath = resolvedEntities.getRawFullPath();
        PolarisEntity returnedEntity = Optional.ofNullable(this.getMetaStoreManager().updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)parentPath), (PolarisBaseEntity)updatedEntity).getEntity()).map(PolarisEntity::new).orElse(null);
        if (returnedEntity == null) {
            throw new CommitConflictException("Concurrent modification of namespace: %s", new Object[]{namespace});
        }
        return true;
    }

    public boolean removeProperties(Namespace namespace, Set<String> properties) throws NoSuchNamespaceException {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)namespace);
        if (resolvedEntities == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        PolarisEntity entity = resolvedEntities.getRawLeafEntity();
        HashMap updatedProperties = new HashMap(entity.getPropertiesAsMap());
        properties.forEach(updatedProperties::remove);
        PolarisEntity updatedEntity = ((PolarisEntity.Builder)new PolarisEntity.Builder(entity).setProperties(updatedProperties)).build();
        List parentPath = resolvedEntities.getRawFullPath();
        PolarisEntity returnedEntity = Optional.ofNullable(this.getMetaStoreManager().updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)parentPath), (PolarisBaseEntity)updatedEntity).getEntity()).map(PolarisEntity::new).orElse(null);
        if (returnedEntity == null) {
            throw new CommitConflictException("Concurrent modification of namespace: %s", new Object[]{namespace});
        }
        return true;
    }

    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)namespace);
        if (resolvedEntities == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        NamespaceEntity entity = NamespaceEntity.of((PolarisBaseEntity)resolvedEntities.getRawLeafEntity());
        Preconditions.checkState((boolean)entity.getParentNamespace().equals((Object)PolarisCatalogHelpers.getParentNamespace((Namespace)namespace)), (String)"Mismatched stored parentNamespace '%s' vs looked up parentNamespace '%s", (Object)entity.getParentNamespace(), (Object)PolarisCatalogHelpers.getParentNamespace((Namespace)namespace));
        return entity.getPropertiesAsMap();
    }

    public List<Namespace> listNamespaces() {
        return this.listNamespaces(Namespace.empty());
    }

    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        return this.listNamespaces(namespace, PageToken.readEverything()).items();
    }

    public Page<Namespace> listNamespaces(Namespace namespace, PageToken pageToken) throws NoSuchNamespaceException {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)namespace);
        if (resolvedEntities == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        List catalogPath = resolvedEntities.getRawFullPath();
        ListEntitiesResult listResult = this.getMetaStoreManager().listEntities(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)catalogPath), PolarisEntityType.NAMESPACE, PolarisEntitySubType.NULL_SUBTYPE, pageToken);
        return listResult.getPage().map(record -> PolarisCatalogHelpers.nameAndIdToNamespace((List)catalogPath, (PolarisEntity.NameAndId)new PolarisEntity.NameAndId(record.getName(), record.getId())));
    }

    @Override
    public void close() throws IOException {
        if (this.closeableGroup != null) {
            this.closeableGroup.close();
        }
    }

    public List<TableIdentifier> listViews(Namespace namespace) {
        return this.listViews(namespace, PageToken.readEverything()).items();
    }

    public Page<TableIdentifier> listViews(Namespace namespace, PageToken pageToken) {
        if (!this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException("Cannot list views for namespace. Namespace does not exist: '%s'", new Object[]{namespace});
        }
        return this.listTableLike(PolarisEntitySubType.ICEBERG_VIEW, namespace, pageToken);
    }

    @VisibleForTesting
    protected ViewOperations newViewOps(TableIdentifier identifier) {
        return new BasePolarisViewOperations(this.catalogFileIO, identifier);
    }

    public boolean dropView(TableIdentifier identifier) {
        boolean purge = (Boolean)this.callContext.getRealmConfig().getConfig((PolarisConfiguration)FeatureConfiguration.PURGE_VIEW_METADATA_ON_DROP, this.catalogEntity);
        return this.dropTableLike(PolarisEntitySubType.ICEBERG_VIEW, identifier, Map.of(), purge).isSuccess();
    }

    public void renameView(TableIdentifier from, TableIdentifier to) {
        if (from.equals((Object)to)) {
            return;
        }
        this.renameTableLike(PolarisEntitySubType.ICEBERG_VIEW, from, to);
    }

    @Override
    public boolean sendNotification(TableIdentifier identifier, NotificationRequest notificationRequest) {
        return this.sendNotificationForTableLike(PolarisEntitySubType.ICEBERG_TABLE, identifier, notificationRequest);
    }

    @Override
    public AccessConfig getAccessConfig(TableIdentifier tableIdentifier, TableMetadata tableMetadata, Set<PolarisStorageActions> storageActions, Optional<String> refreshCredentialsEndpoint) {
        Optional<PolarisEntity> storageInfo = this.findStorageInfo(tableIdentifier);
        if (storageInfo.isEmpty()) {
            LOGGER.atWarn().addKeyValue("tableIdentifier", (Object)tableIdentifier).log("Table entity has no storage configuration in its hierarchy");
            return AccessConfig.builder().supportsCredentialVending(false).build();
        }
        return FileIOUtil.refreshAccessConfig(this.callContext, this.storageCredentialCache, this.getCredentialVendor(), tableIdentifier, StorageUtil.getLocationsUsedByTable((TableMetadata)tableMetadata), storageActions, storageInfo.get(), refreshCredentialsEndpoint);
    }

    private String buildPrefixedLocation(TableIdentifier tableIdentifier) {
        StringBuilder locationBuilder = new StringBuilder();
        locationBuilder.append(this.defaultBaseLocation);
        if (!this.defaultBaseLocation.endsWith("/")) {
            locationBuilder.append("/");
        }
        locationBuilder.append(LocationUtils.computeHash(tableIdentifier.toString()));
        for (String ns : tableIdentifier.namespace().levels()) {
            locationBuilder.append("/").append(URLEncoder.encode(ns, Charset.defaultCharset()));
        }
        locationBuilder.append("/").append(URLEncoder.encode(tableIdentifier.name(), Charset.defaultCharset())).append("/");
        return locationBuilder.toString();
    }

    private String applyDefaultLocationObjectStoragePrefix(TableIdentifier tableIdentifier, String location) {
        boolean prefixEnabled = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.DEFAULT_LOCATION_OBJECT_STORAGE_PREFIX_ENABLED, this.catalogEntity);
        boolean allowUnstructuredTableLocation = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_UNSTRUCTURED_TABLE_LOCATION, this.catalogEntity);
        boolean allowTableLocationOverlap = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_TABLE_LOCATION_OVERLAP, this.catalogEntity);
        boolean optimizedSiblingCheck = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.OPTIMIZED_SIBLING_CHECK, this.catalogEntity);
        if (location != null) {
            return location;
        }
        if (!prefixEnabled) {
            return location;
        }
        if (!allowUnstructuredTableLocation) {
            throw new IllegalStateException(String.format("The configuration %s is enabled, but %s is not enabled", FeatureConfiguration.DEFAULT_LOCATION_OBJECT_STORAGE_PREFIX_ENABLED.key(), FeatureConfiguration.ALLOW_UNSTRUCTURED_TABLE_LOCATION.key()));
        }
        if (!allowTableLocationOverlap) {
            if (!optimizedSiblingCheck) {
                throw new IllegalStateException(String.format("%s and %s are both disabled, which means that table location overlap checkes are being performed, but only within each namespace. However, %s is enabled, which indicates that tables may be created outside of their parent namespace. This is not a safe combination of configurations.", FeatureConfiguration.ALLOW_TABLE_LOCATION_OVERLAP.key(), FeatureConfiguration.OPTIMIZED_SIBLING_CHECK.key(), FeatureConfiguration.ALLOW_UNSTRUCTURED_TABLE_LOCATION.key()));
            }
            if (!this.loggedPrefixOverlapWarning.getAndSet(true)) {
                LOGGER.warn("A table is being created with {} and {} enabled, but with {} disabled. This is a safe combination of configurations which may prevent table overlap, but only if the underlying persistence actually implements %s. Exercise caution.", new Object[]{FeatureConfiguration.DEFAULT_LOCATION_OBJECT_STORAGE_PREFIX_ENABLED.key(), FeatureConfiguration.OPTIMIZED_SIBLING_CHECK.key(), FeatureConfiguration.ALLOW_TABLE_LOCATION_OVERLAP.key()});
            }
            return this.buildPrefixedLocation(tableIdentifier);
        }
        return this.buildPrefixedLocation(tableIdentifier);
    }

    private String applyReplaceNewLocationWithCatalogDefault(String specifiedTableLikeLocation) {
        String replaceNewLocationPrefix = this.catalogEntity.getReplaceNewLocationPrefixWithCatalogDefault();
        if (specifiedTableLikeLocation != null && replaceNewLocationPrefix != null && specifiedTableLikeLocation.startsWith(replaceNewLocationPrefix)) {
            String modifiedLocation = this.defaultBaseLocation + specifiedTableLikeLocation.substring(replaceNewLocationPrefix.length());
            LOGGER.atDebug().addKeyValue("specifiedTableLikeLocation", (Object)specifiedTableLikeLocation).addKeyValue("modifiedLocation", (Object)modifiedLocation).log("Translating specifiedTableLikeLocation based on config");
            return modifiedLocation;
        }
        return specifiedTableLikeLocation;
    }

    public String transformTableLikeLocation(TableIdentifier tableIdentifier, String location) {
        return this.applyDefaultLocationObjectStoragePrefix(tableIdentifier, this.applyReplaceNewLocationWithCatalogDefault(location));
    }

    @Nonnull
    private Optional<PolarisEntity> findStorageInfo(TableIdentifier tableIdentifier) {
        PolarisResolvedPathWrapper resolvedTableEntities = this.resolvedEntityView.getResolvedPath((Object)tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_TABLE);
        PolarisResolvedPathWrapper resolvedStorageEntity = resolvedTableEntities == null ? this.resolvedEntityView.getResolvedPath((Object)tableIdentifier.namespace()) : resolvedTableEntities;
        return FileIOUtil.findStorageInfoFromHierarchy(resolvedStorageEntity);
    }

    private void validateLocationForTableLike(TableIdentifier identifier, String location) {
        PolarisResolvedPathWrapper resolvedStorageEntity = this.resolvedEntityView.getResolvedPath((Object)identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE);
        if (resolvedStorageEntity == null) {
            resolvedStorageEntity = this.resolvedEntityView.getResolvedPath((Object)identifier.namespace());
        }
        if (resolvedStorageEntity == null) {
            resolvedStorageEntity = this.resolvedEntityView.getPassthroughResolvedPath((Object)identifier.namespace());
        }
        this.validateLocationForTableLike(identifier, location, resolvedStorageEntity);
    }

    private void validateLocationForTableLike(TableIdentifier identifier, String location, PolarisResolvedPathWrapper resolvedStorageEntity) {
        this.validateLocationsForTableLike(identifier, Set.of(location), resolvedStorageEntity);
    }

    private void validateLocationsForTableLike(TableIdentifier identifier, Set<String> locations, PolarisResolvedPathWrapper resolvedStorageEntity) {
        PolarisStorageConfigurationInfo.forEntityPath((RealmConfig)this.realmConfig, (List)resolvedStorageEntity.getRawFullPath()).ifPresentOrElse(restrictions -> restrictions.validate(this.realmConfig, identifier, locations), () -> {
            List invalidLocations;
            List allowedStorageTypes = (List)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.SUPPORTED_CATALOG_STORAGE_TYPES);
            if (!allowedStorageTypes.contains(StorageConfigInfo.StorageTypeEnum.FILE.name()) && !(invalidLocations = locations.stream().filter(location -> location.startsWith("file:") || location.startsWith("http")).collect(Collectors.toList())).isEmpty()) {
                throw new ForbiddenException("Invalid locations '%s' for identifier '%s': File locations are not allowed", new Object[]{invalidLocations, identifier});
            }
        });
    }

    private void validateNoLocationOverlap(CatalogEntity catalog, TableIdentifier identifier, List<PolarisEntity> resolvedNamespace, String location, PolarisEntity entity) {
        boolean validateViewOverlap = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)BehaviorChangeConfiguration.VALIDATE_VIEW_LOCATION_OVERLAP);
        if (((Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_TABLE_LOCATION_OVERLAP, catalog)).booleanValue()) {
            LOGGER.debug("Skipping location overlap validation for identifier '{}'", (Object)identifier);
        } else if (validateViewOverlap || entity.getSubType().equals((Object)PolarisEntitySubType.ICEBERG_TABLE)) {
            LOGGER.debug("Validating no overlap with sibling tables or namespaces");
            IcebergTableLikeEntity virtualEntity = IcebergTableLikeEntity.of((PolarisBaseEntity)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)((PolarisEntity.Builder)new PolarisEntity.Builder().setType(PolarisEntityType.TABLE_LIKE)).setSubType(PolarisEntitySubType.ICEBERG_TABLE)).setParentId(resolvedNamespace.getLast().getId())).setProperties(Map.of("location", location))).build());
            this.validateNoLocationOverlap(virtualEntity, resolvedNamespace);
        }
    }

    private void validateNamespaceLocation(NamespaceEntity namespace, PolarisResolvedPathWrapper resolvedParent) {
        StorageLocation namespaceLocation = StorageLocation.of((String)StorageLocation.ensureTrailingSlash((String)this.resolveNamespaceLocation(namespace.asNamespace(), namespace.getPropertiesAsMap())));
        PolarisEntity parent = resolvedParent.getResolvedLeafEntity().getEntity();
        Preconditions.checkArgument((parent.getType().equals((Object)PolarisEntityType.CATALOG) || parent.getType().equals((Object)PolarisEntityType.NAMESPACE) ? 1 : 0) != 0, (Object)"Invalid parent type");
        if (parent.getType().equals((Object)PolarisEntityType.CATALOG)) {
            CatalogEntity parentEntity = CatalogEntity.of((PolarisBaseEntity)parent);
            LOGGER.debug("Validating namespace {} given parent catalog {}", (Object)namespace.getName(), (Object)parentEntity.getName());
            PolarisStorageConfigurationInfo storageConfigInfo = parentEntity.getStorageConfigurationInfo();
            if (storageConfigInfo == null) {
                throw new IllegalArgumentException("Cannot create namespace without a parent storage configuration");
            }
            List<StorageLocation> defaultLocations = parentEntity.getStorageConfigurationInfo().getAllowedLocations().stream().filter(Objects::nonNull).map(l -> StorageLocation.ensureTrailingSlash((String)(StorageLocation.ensureTrailingSlash((String)l) + namespace.getName()))).map(StorageLocation::of).toList();
            if (!defaultLocations.contains(namespaceLocation)) {
                throw new IllegalArgumentException("Namespace " + namespace.getName() + " has a custom location, which is not enabled. Expected a location in: [" + String.join((CharSequence)", ", defaultLocations.stream().map(StorageLocation::toString).toList()) + "]. Got location: " + String.valueOf(namespaceLocation) + "]");
            }
        } else if (parent.getType().equals((Object)PolarisEntityType.NAMESPACE)) {
            NamespaceEntity parentEntity = NamespaceEntity.of((PolarisBaseEntity)parent);
            LOGGER.debug("Validating namespace {} given parent namespace {}", (Object)namespace.getName(), (Object)parentEntity.getName());
            String parentLocation = this.resolveNamespaceLocation(parentEntity.asNamespace(), parentEntity.getPropertiesAsMap());
            StorageLocation defaultLocation = StorageLocation.of((String)StorageLocation.ensureTrailingSlash((String)(StorageLocation.ensureTrailingSlash((String)parentLocation) + namespace.getName())));
            if (!defaultLocation.equals((Object)namespaceLocation)) {
                throw new IllegalArgumentException("Namespace " + namespace.getName() + " has a custom location, which is not enabled. Expected location: [" + String.valueOf(defaultLocation) + "]. Got location: [" + String.valueOf(namespaceLocation) + "]");
            }
        }
    }

    private <T extends PolarisEntity> void validateNoLocationOverlap(T entity, List<PolarisEntity> parentPath) {
        Optional directSiblingCheckResult;
        String location = ((LocationBasedEntity)entity).getBaseLocation();
        String name = entity.getName();
        boolean useOptimizedSiblingCheck = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.OPTIMIZED_SIBLING_CHECK);
        if (useOptimizedSiblingCheck && (directSiblingCheckResult = this.getMetaStoreManager().hasOverlappingSiblings(this.callContext.getPolarisCallContext(), entity)).isPresent()) {
            if (((Optional)directSiblingCheckResult.get()).isPresent()) {
                throw new ForbiddenException("Unable to create entity at location '%s' because it conflicts with existing table or namespace at %s", new Object[]{location, ((Optional)directSiblingCheckResult.get()).get()});
            }
            return;
        }
        Optional<NamespaceEntity> parentNamespace = parentPath.size() > 1 ? Optional.of(NamespaceEntity.of((PolarisBaseEntity)((PolarisBaseEntity)parentPath.getLast()))) : Optional.empty();
        ListEntitiesResult siblingNamespacesResult = this.getMetaStoreManager().listEntities(this.getCurrentPolarisContext(), PolarisEntity.toCoreList(parentPath), PolarisEntityType.NAMESPACE, PolarisEntitySubType.ANY_SUBTYPE, PageToken.readEverything());
        if (!siblingNamespacesResult.isSuccess()) {
            throw new IllegalStateException("Unable to resolve siblings entities to validate location - could not list namespaces");
        }
        List siblingTables = parentNamespace.map(ns -> {
            ListEntitiesResult siblingTablesResult = this.getMetaStoreManager().listEntities(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)parentPath), PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE, PageToken.readEverything());
            if (!siblingTablesResult.isSuccess()) {
                throw new IllegalStateException("Unable to resolve siblings entities to validate location - could not list tables");
            }
            return siblingTablesResult.getEntities().stream().map(tbl -> TableIdentifier.of((Namespace)ns.asNamespace(), (String)tbl.getName())).collect(Collectors.toList());
        }).orElse(List.of());
        List<Namespace> siblingNamespaces = siblingNamespacesResult.getEntities().stream().map(ns -> {
            String[] nsLevels = parentNamespace.map(parent -> parent.asNamespace().levels()).orElse(new String[0]);
            String[] newLevels = Arrays.copyOf(nsLevels, nsLevels.length + 1);
            newLevels[nsLevels.length] = ns.getName();
            return Namespace.of((String[])newLevels);
        }).toList();
        LOGGER.debug("Resolving {} sibling entities to validate location", (Object)(siblingTables.size() + siblingNamespaces.size()));
        PolarisResolutionManifest resolutionManifest = new PolarisResolutionManifest(this.diagnostics, this.callContext.getRealmContext(), this.resolverFactory, this.securityContext, parentPath.getFirst().getName());
        siblingTables.forEach(tbl -> resolutionManifest.addPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)tbl), PolarisEntityType.TABLE_LIKE), tbl));
        siblingNamespaces.forEach(ns -> resolutionManifest.addPath(new ResolverPath(Arrays.asList(ns.levels()), PolarisEntityType.NAMESPACE), ns));
        ResolverStatus status = resolutionManifest.resolveAll();
        if (!status.getStatus().equals((Object)ResolverStatus.StatusEnum.SUCCESS)) {
            String message = "Unable to resolve sibling entities to validate location - " + String.valueOf(status.getStatus());
            if (status.getStatus().equals((Object)ResolverStatus.StatusEnum.ENTITY_COULD_NOT_BE_RESOLVED)) {
                message = message + ". Could not resolve entity: " + status.getFailedToResolvedEntityName();
            }
            throw new IllegalStateException(message);
        }
        StorageLocation targetLocation = StorageLocation.of((String)location);
        Stream.concat(siblingTables.stream().filter(tbl -> !tbl.name().equals(name)).map(tbl -> {
            PolarisResolvedPathWrapper resolveTablePath = resolutionManifest.getResolvedPath(tbl);
            PolarisEntity tableEntity = resolveTablePath.getRawLeafEntity();
            if (tableEntity.getSubType() == PolarisEntitySubType.GENERIC_TABLE) {
                return GenericTableEntity.of((PolarisBaseEntity)tableEntity).getBaseLocation();
            }
            return IcebergTableLikeEntity.of((PolarisBaseEntity)tableEntity).getBaseLocation();
        }), siblingNamespaces.stream().filter(ns -> !ns.level(ns.length() - 1).equals(name)).map(ns -> {
            PolarisResolvedPathWrapper resolveNamespacePath = resolutionManifest.getResolvedPath(ns);
            return NamespaceEntity.of((PolarisBaseEntity)resolveNamespacePath.getRawLeafEntity()).getBaseLocation();
        })).filter(Objects::nonNull).map(StorageLocation::of).forEach(siblingLocation -> {
            if (targetLocation.isChildOf(siblingLocation) || siblingLocation.isChildOf(targetLocation)) {
                throw new ForbiddenException("Unable to create table at location '%s' because it conflicts with existing table or namespace at location '%s'", new Object[]{targetLocation, siblingLocation});
            }
        });
    }

    private void validateMetadataFileInTableDir(TableIdentifier identifier, TableMetadata metadata) {
        boolean allowEscape = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_EXTERNAL_TABLE_LOCATION);
        if (!allowEscape && !((Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ALLOW_EXTERNAL_METADATA_FILE_LOCATION)).booleanValue()) {
            LOGGER.debug("Validating base location {} for table {} in metadata file {}", new Object[]{metadata.location(), identifier, metadata.metadataFileLocation()});
            StorageLocation metadataFileLocation = StorageLocation.of((String)metadata.metadataFileLocation());
            StorageLocation baseLocation = StorageLocation.of((String)metadata.location());
            if (!metadataFileLocation.isChildOf(baseLocation)) {
                throw new BadRequestException("Metadata location %s is not allowed outside of table location %s", new Object[]{metadata.metadataFileLocation(), metadata.location()});
            }
        }
    }

    private FileIO loadFileIOForTableLike(TableIdentifier identifier, Set<String> readLocations, PolarisResolvedPathWrapper resolvedStorageEntity, Map<String, String> tableProperties, Set<PolarisStorageActions> storageActions) {
        FileIO fileIO = this.fileIOFactory.loadFileIO(this.callContext, this.ioImplClassName, tableProperties, identifier, readLocations, storageActions, resolvedStorageEntity);
        this.closeableGroup.addCloseable((Closeable)fileIO);
        return fileIO;
    }

    private PolarisCallContext getCurrentPolarisContext() {
        return this.callContext.getPolarisCallContext();
    }

    private PolarisMetaStoreManager getMetaStoreManager() {
        return this.metaStoreManager;
    }

    private PolarisCredentialVendor getCredentialVendor() {
        return this.metaStoreManager;
    }

    @VisibleForTesting
    public void setFileIOFactory(FileIOFactory newFactory) {
        this.fileIOFactory = newFactory;
    }

    @VisibleForTesting
    long getCatalogId() {
        if (this.catalogId <= 0L) {
            throw new RuntimeException("Failed to initialize catalogId before using catalog with name: " + this.catalogName);
        }
        return this.catalogId;
    }

    private void renameTableLike(PolarisEntitySubType subType, TableIdentifier from, TableIdentifier to) {
        IcebergTableLikeEntity toEntity;
        LOGGER.debug("Renaming tableLike from {} to {}", (Object)from, (Object)to);
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)from, PolarisEntityType.TABLE_LIKE, subType);
        if (resolvedEntities == null) {
            if (subType == PolarisEntitySubType.ICEBERG_VIEW) {
                throw new NoSuchViewException("Cannot rename %s to %s. View does not exist", new Object[]{from, to});
            }
            throw new NoSuchTableException("Cannot rename %s to %s. Table does not exist", new Object[]{from, to});
        }
        List catalogPath = resolvedEntities.getRawParentPath();
        PolarisEntity leafEntity = resolvedEntities.getRawLeafEntity();
        List newCatalogPath = null;
        if (!from.namespace().equals((Object)to.namespace())) {
            PolarisResolvedPathWrapper resolvedNewParentEntities = this.resolvedEntityView.getResolvedPath((Object)to.namespace());
            if (resolvedNewParentEntities == null) {
                throw new NoSuchNamespaceException("Cannot rename %s to %s. Namespace does not exist: %s", new Object[]{from, to, to.namespace()});
            }
            newCatalogPath = resolvedNewParentEntities.getRawFullPath();
            toEntity = ((IcebergTableLikeEntity.Builder)new IcebergTableLikeEntity.Builder(IcebergTableLikeEntity.of((PolarisBaseEntity)leafEntity)).setTableIdentifier(to).setParentId(resolvedNewParentEntities.getResolvedLeafEntity().getEntity().getId())).build();
        } else {
            toEntity = new IcebergTableLikeEntity.Builder(IcebergTableLikeEntity.of((PolarisBaseEntity)leafEntity)).setTableIdentifier(to).build();
        }
        EntityResult returnedEntityResult = this.getMetaStoreManager().renameEntity(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)leafEntity, PolarisEntity.toCoreList((List)newCatalogPath), (PolarisEntity)toEntity);
        if (!returnedEntityResult.isSuccess()) {
            LOGGER.debug("Rename error {} trying to rename {} to {}. Checking existing object.", new Object[]{returnedEntityResult.getReturnStatus(), from, to});
            switch (returnedEntityResult.getReturnStatus()) {
                case ENTITY_ALREADY_EXISTS: {
                    PolarisEntitySubType existingEntitySubType = returnedEntityResult.getAlreadyExistsEntitySubType();
                    if (existingEntitySubType == null) {
                        throw new AlreadyExistsException("Cannot rename %s to %s. Object already exists", new Object[]{from, to});
                    }
                    if (existingEntitySubType == PolarisEntitySubType.ICEBERG_TABLE) {
                        throw new AlreadyExistsException("Cannot rename %s to %s. Table already exists", new Object[]{from, to});
                    }
                    if (existingEntitySubType == PolarisEntitySubType.ICEBERG_VIEW) {
                        throw new AlreadyExistsException("Cannot rename %s to %s. View already exists", new Object[]{from, to});
                    }
                    throw new IllegalStateException(String.format("Unexpected entity type '%s'", existingEntitySubType));
                }
                case ENTITY_NOT_FOUND: {
                    throw new NotFoundException("Cannot rename %s to %s. %s does not exist", new Object[]{from, to, from});
                }
                case TARGET_ENTITY_CONCURRENTLY_MODIFIED: 
                case ENTITY_CANNOT_BE_RESOLVED: {
                    throw new RuntimeException("concurrent update detected, please retry");
                }
                case ENTITY_CANNOT_BE_RENAMED: {
                    throw new BadRequestException("Cannot rename built-in object %s", new Object[]{leafEntity.getName()});
                }
            }
            throw new IllegalStateException("Unknown error status " + String.valueOf(returnedEntityResult.getReturnStatus()));
        }
        IcebergTableLikeEntity returnedEntity = IcebergTableLikeEntity.of((PolarisBaseEntity)returnedEntityResult.getEntity());
        if (!toEntity.getTableIdentifier().equals((Object)returnedEntity.getTableIdentifier())) {
            LOGGER.atError().addKeyValue("toEntity.getTableIdentifier()", (Object)toEntity.getTableIdentifier()).addKeyValue("returnedEntity.getTableIdentifier()", (Object)returnedEntity.getTableIdentifier()).log("Returned entity identifier doesn't match toEntity identifier");
            this.getMetaStoreManager().updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)newCatalogPath), (PolarisBaseEntity)new IcebergTableLikeEntity.Builder(returnedEntity).setTableIdentifier(to).build());
        }
    }

    private void createTableLike(TableIdentifier identifier, PolarisEntity entity) {
        PolarisResolvedPathWrapper resolvedParent = this.resolvedEntityView.getResolvedPath((Object)identifier.namespace());
        if (resolvedParent == null) {
            throw new IllegalStateException(String.format("Failed to fetch resolved parent for TableIdentifier '%s'", identifier));
        }
        this.createTableLike(identifier, entity, resolvedParent);
    }

    private void createTableLike(TableIdentifier identifier, PolarisEntity entity, PolarisResolvedPathWrapper resolvedParent) {
        IcebergTableLikeEntity icebergTableLikeEntity = IcebergTableLikeEntity.of((PolarisBaseEntity)entity);
        boolean requireTrailingSlash = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ADD_TRAILING_SLASH_TO_LOCATION);
        if (requireTrailingSlash && icebergTableLikeEntity.getBaseLocation() != null && !icebergTableLikeEntity.getBaseLocation().endsWith("/")) {
            icebergTableLikeEntity = new IcebergTableLikeEntity.Builder(icebergTableLikeEntity).setBaseLocation(icebergTableLikeEntity.getBaseLocation() + "/").build();
        }
        String metadataLocation = icebergTableLikeEntity.getMetadataLocation();
        this.validateLocationForTableLike(identifier, metadataLocation, resolvedParent);
        List catalogPath = resolvedParent.getRawFullPath();
        if (icebergTableLikeEntity.getParentId() <= 0L) {
            icebergTableLikeEntity = ((IcebergTableLikeEntity.Builder)new IcebergTableLikeEntity.Builder(icebergTableLikeEntity).setParentId(resolvedParent.getRawLeafEntity().getId())).build();
        }
        icebergTableLikeEntity = ((IcebergTableLikeEntity.Builder)new IcebergTableLikeEntity.Builder(icebergTableLikeEntity).setCreateTimestamp(System.currentTimeMillis())).build();
        EntityResult res = this.getMetaStoreManager().createEntityIfNotExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)icebergTableLikeEntity);
        if (!res.isSuccess()) {
            switch (res.getReturnStatus()) {
                case CATALOG_PATH_CANNOT_BE_RESOLVED: {
                    throw new NotFoundException("Parent path does not exist for %s", new Object[]{identifier});
                }
                case ENTITY_ALREADY_EXISTS: {
                    throw new AlreadyExistsException("Iceberg table, view, or generic table already exists: %s", new Object[]{identifier});
                }
            }
            throw new IllegalStateException(String.format("Unknown error status for identifier %s: %s with extraInfo: %s", identifier, res.getReturnStatus(), res.getExtraInformation()));
        }
        PolarisEntity resultEntity = PolarisEntity.of((EntityResult)res);
        LOGGER.debug("Created TableLike entity {} with TableIdentifier {}", (Object)resultEntity, (Object)identifier);
    }

    private void updateTableLike(TableIdentifier identifier, PolarisEntity entity) {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)identifier, entity.getType(), entity.getSubType());
        if (resolvedEntities == null) {
            throw new IllegalStateException(String.format("Failed to fetch resolved TableIdentifier '%s'", identifier));
        }
        IcebergTableLikeEntity icebergTableLikeEntity = new IcebergTableLikeEntity((PolarisBaseEntity)entity);
        boolean requireTrailingSlash = (Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.ADD_TRAILING_SLASH_TO_LOCATION);
        if (requireTrailingSlash && icebergTableLikeEntity.getBaseLocation() != null && !icebergTableLikeEntity.getBaseLocation().endsWith("/")) {
            icebergTableLikeEntity = new IcebergTableLikeEntity.Builder(icebergTableLikeEntity).setBaseLocation(icebergTableLikeEntity.getBaseLocation() + "/").build();
        }
        String metadataLocation = icebergTableLikeEntity.getMetadataLocation();
        this.validateLocationForTableLike(identifier, metadataLocation, resolvedEntities);
        List catalogPath = resolvedEntities.getRawParentPath();
        EntityResult res = this.getMetaStoreManager().updateEntityPropertiesIfNotChanged(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)icebergTableLikeEntity);
        if (!res.isSuccess()) {
            switch (res.getReturnStatus()) {
                case CATALOG_PATH_CANNOT_BE_RESOLVED: {
                    throw new NotFoundException("Parent path does not exist for %s", new Object[]{identifier});
                }
                case TARGET_ENTITY_CONCURRENTLY_MODIFIED: {
                    throw new CommitConflictException("Failed to commit Table or View %s because it was concurrently modified", new Object[]{identifier});
                }
            }
            throw new IllegalStateException(String.format("Unknown error status for identifier %s: %s with extraInfo: %s", identifier, res.getReturnStatus(), res.getExtraInformation()));
        }
        PolarisEntity resultEntity = PolarisEntity.of((EntityResult)res);
        LOGGER.debug("Updated TableLike entity {} with TableIdentifier {}", (Object)resultEntity, (Object)identifier);
    }

    @Nonnull
    private DropEntityResult dropTableLike(PolarisEntitySubType subType, TableIdentifier identifier, Map<String, String> storageProperties, boolean purge) {
        boolean dropWithPurgeEnabled;
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)identifier, PolarisEntityType.TABLE_LIKE, subType);
        if (resolvedEntities == null) {
            return new DropEntityResult(BaseResult.ReturnStatus.ENTITY_NOT_FOUND, null);
        }
        List catalogPath = resolvedEntities.getRawParentPath();
        PolarisEntity leafEntity = resolvedEntities.getRawLeafEntity();
        if (catalogPath != null && !catalogPath.isEmpty() && purge && !(dropWithPurgeEnabled = ((Boolean)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.DROP_WITH_PURGE_ENABLED, this.catalogEntity)).booleanValue())) {
            throw new ForbiddenException(String.format("Unable to purge entity: %s. To enable this feature, set the Polaris configuration %s or the catalog configuration %s", identifier.name(), FeatureConfiguration.DROP_WITH_PURGE_ENABLED.key(), FeatureConfiguration.DROP_WITH_PURGE_ENABLED.catalogConfig()), new Object[0]);
        }
        return this.getMetaStoreManager().dropEntityIfExists(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)catalogPath), (PolarisBaseEntity)leafEntity, storageProperties, purge);
    }

    private boolean sendNotificationForTableLike(PolarisEntitySubType subType, TableIdentifier tableIdentifier, NotificationRequest request) {
        LOGGER.debug("Handling notification request {} for tableIdentifier {}", (Object)request, (Object)tableIdentifier);
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getPassthroughResolvedPath((Object)tableIdentifier, PolarisEntityType.TABLE_LIKE, subType);
        NotificationType notificationType = request.getNotificationType();
        Preconditions.checkNotNull((Object)notificationType, (Object)"Expected a valid notification type.");
        if (notificationType == NotificationType.DROP) {
            return this.dropTableLike(PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier, Map.of(), false).isSuccess();
        }
        if (notificationType == NotificationType.VALIDATE) {
            PolarisResolvedPathWrapper resolvedStorageEntity = null;
            Optional<Object> storageInfoEntity = Optional.empty();
            for (int i = tableIdentifier.namespace().length(); i >= 0; --i) {
                Namespace nsLevel = Namespace.of((String[])((String[])Arrays.stream(tableIdentifier.namespace().levels()).limit(i).toArray(String[]::new)));
                resolvedStorageEntity = this.resolvedEntityView.getResolvedPath((Object)nsLevel);
                if (resolvedStorageEntity == null) continue;
                storageInfoEntity = FileIOUtil.findStorageInfoFromHierarchy(resolvedStorageEntity);
                break;
            }
            if (resolvedStorageEntity == null || storageInfoEntity.isEmpty()) {
                throw new BadRequestException("Failed to find StorageInfo entity for TableIdentifier %s", new Object[]{tableIdentifier});
            }
            String metadataLocation = this.transformTableLikeLocation(tableIdentifier, request.getPayload().getMetadataLocation());
            this.validateLocationForTableLike(tableIdentifier, metadataLocation, resolvedStorageEntity);
            String locationDir = metadataLocation.substring(0, metadataLocation.lastIndexOf("/"));
            this.loadFileIOForTableLike(tableIdentifier, Set.of(locationDir), resolvedStorageEntity, new HashMap<String, String>(this.tableDefaultProperties), Set.of(PolarisStorageActions.READ));
            LOGGER.debug("Successful VALIDATE notification for tableIdentifier {}, metadataLocation {}", (Object)tableIdentifier, (Object)metadataLocation);
        } else if (notificationType == NotificationType.CREATE || notificationType == NotificationType.UPDATE) {
            String existingLocation;
            Namespace ns = tableIdentifier.namespace();
            this.createNonExistingNamespaces(ns);
            PolarisResolvedPathWrapper resolvedParent = this.resolvedEntityView.getPassthroughResolvedPath((Object)ns);
            IcebergTableLikeEntity entity = IcebergTableLikeEntity.of((PolarisBaseEntity)(resolvedEntities == null ? null : resolvedEntities.getRawLeafEntity()));
            String newLocation = this.transformTableLikeLocation(tableIdentifier, request.getPayload().getMetadataLocation());
            if (null == entity) {
                existingLocation = null;
                entity = ((IcebergTableLikeEntity.Builder)((IcebergTableLikeEntity.Builder)new IcebergTableLikeEntity.Builder(PolarisEntitySubType.ICEBERG_TABLE, tableIdentifier, newLocation).setCatalogId(this.getCatalogId())).setId(this.getMetaStoreManager().generateNewEntityId(this.getCurrentPolarisContext()).getId().longValue())).setLastNotificationTimestamp(request.getPayload().getTimestamp().longValue()).build();
            } else {
                if (entity.getLastAdmittedNotificationTimestamp().isPresent() && request.getPayload().getTimestamp() <= (Long)entity.getLastAdmittedNotificationTimestamp().get()) {
                    throw new AlreadyExistsException("A notification with a newer timestamp has been processed for table %s", new Object[]{tableIdentifier});
                }
                existingLocation = entity.getMetadataLocation();
                entity = new IcebergTableLikeEntity.Builder(entity).setMetadataLocation(newLocation).setLastNotificationTimestamp(request.getPayload().getTimestamp().longValue()).build();
            }
            this.validateLocationForTableLike(tableIdentifier, newLocation);
            String locationDir = newLocation.substring(0, newLocation.lastIndexOf("/"));
            FileIO fileIO = this.loadFileIOForTableLike(tableIdentifier, Set.of(locationDir), resolvedParent, new HashMap<String, String>(this.tableDefaultProperties), Set.of(PolarisStorageActions.READ, PolarisStorageActions.WRITE, PolarisStorageActions.LIST));
            TableMetadata tableMetadata = TableMetadataParser.read((FileIO)fileIO, (String)newLocation);
            this.validateLocationForTableLike(tableIdentifier, tableMetadata.location());
            this.validateMetadataFileInTableDir(tableIdentifier, tableMetadata);
            if (null == existingLocation) {
                LOGGER.debug("Creating table {} for notification with metadataLocation {}", (Object)tableIdentifier, (Object)newLocation);
                this.createTableLike(tableIdentifier, (PolarisEntity)entity, resolvedParent);
            } else {
                LOGGER.debug("Updating table {} for notification with metadataLocation {}", (Object)tableIdentifier, (Object)newLocation);
                this.updateTableLike(tableIdentifier, (PolarisEntity)entity);
            }
        }
        return true;
    }

    private void createNonExistingNamespaces(Namespace namespace) {
        for (int i = 1; i <= namespace.length(); ++i) {
            Namespace nsLevel = Namespace.of((String[])((String[])Arrays.stream(namespace.levels()).limit(i).toArray(String[]::new)));
            if (this.resolvedEntityView.getPassthroughResolvedPath((Object)nsLevel) != null) continue;
            Namespace parentNamespace = PolarisCatalogHelpers.getParentNamespace((Namespace)nsLevel);
            PolarisResolvedPathWrapper resolvedParent = this.resolvedEntityView.getPassthroughResolvedPath((Object)parentNamespace);
            try {
                this.createNamespaceInternal(nsLevel, Collections.emptyMap(), resolvedParent);
                continue;
            }
            catch (AlreadyExistsException aee) {
                LOGGER.atInfo().setCause((Throwable)aee).addKeyValue("namespace", (Object)namespace).log("Namespace already exists in createNonExistingNamespace");
            }
        }
    }

    private Page<TableIdentifier> listTableLike(PolarisEntitySubType subType, Namespace namespace, PageToken pageToken) {
        PolarisResolvedPathWrapper resolvedEntities = this.resolvedEntityView.getResolvedPath((Object)namespace);
        if (resolvedEntities == null) {
            throw new IllegalStateException(String.format("Failed to fetch resolved namespace '%s'", namespace));
        }
        List catalogPath = resolvedEntities.getRawFullPath();
        ListEntitiesResult listResult = this.getMetaStoreManager().listEntities(this.getCurrentPolarisContext(), PolarisEntity.toCoreList((List)catalogPath), PolarisEntityType.TABLE_LIKE, subType, pageToken);
        Namespace parentNamespace = PolarisCatalogHelpers.parentNamespace((List)catalogPath);
        return listResult.getPage().map(record -> TableIdentifier.of((Namespace)parentNamespace, (String)record.getName()));
    }

    protected FileIO loadFileIO(String ioImpl, Map<String, String> properties) {
        IcebergTableLikeEntity icebergTableLikeEntity = IcebergTableLikeEntity.of((PolarisBaseEntity)this.catalogEntity);
        TableIdentifier identifier = icebergTableLikeEntity.getTableIdentifier();
        Set<String> locations = Set.of(this.catalogEntity.getBaseLocation());
        ResolvedPolarisEntity resolvedCatalogEntity = new ResolvedPolarisEntity((PolarisEntity)this.catalogEntity, List.of(), List.of());
        PolarisResolvedPathWrapper resolvedPath = new PolarisResolvedPathWrapper(List.of(resolvedCatalogEntity));
        Set<PolarisStorageActions> storageActions = Set.of(PolarisStorageActions.ALL);
        return this.fileIOFactory.loadFileIO(this.callContext, ioImpl, properties, identifier, locations, storageActions, resolvedPath);
    }

    private int getMaxMetadataRefreshRetries() {
        return (Integer)this.realmConfig.getConfig((PolarisConfiguration)FeatureConfiguration.MAX_METADATA_REFRESH_RETRIES);
    }

    private class PolarisIcebergCatalogTableBuilder
    extends BaseMetastoreViewCatalog.BaseMetastoreViewCatalogTableBuilder {
        private final TableIdentifier identifier;

        public PolarisIcebergCatalogTableBuilder(TableIdentifier identifier, Schema schema) {
            super((BaseMetastoreViewCatalog)IcebergCatalog.this, identifier, schema);
            this.identifier = identifier;
        }

        public Catalog.TableBuilder withLocation(String newLocation) {
            return super.withLocation(IcebergCatalog.this.transformTableLikeLocation(this.identifier, newLocation));
        }
    }

    private class PolarisIcebergCatalogViewBuilder
    extends BaseMetastoreViewCatalog.BaseViewBuilder {
        private final TableIdentifier identifier;

        public PolarisIcebergCatalogViewBuilder(TableIdentifier identifier) {
            super((BaseMetastoreViewCatalog)IcebergCatalog.this, identifier);
            this.withProperties(PropertyUtil.propertiesWithPrefix(IcebergCatalog.this.properties(), (String)"table-default."));
            this.identifier = identifier;
        }

        public ViewBuilder withLocation(String newLocation) {
            return super.withLocation(IcebergCatalog.this.transformTableLikeLocation(this.identifier, newLocation));
        }
    }

    @VisibleForTesting
    public class BasePolarisTableOperations
    extends PolarisOperationsBase<TableMetadata>
    implements TableOperations {
        private final TableIdentifier tableIdentifier;
        private final String fullTableName;
        private final boolean makeMetadataCurrentOnCommit;
        private FileIO tableFileIO;

        BasePolarisTableOperations(FileIO defaultFileIO, TableIdentifier tableIdentifier, boolean makeMetadataCurrentOnCommit) {
            LOGGER.debug("new BasePolarisTableOperations for {}", (Object)tableIdentifier);
            this.tableIdentifier = tableIdentifier;
            this.fullTableName = IcebergCatalog.fullTableName((String)IcebergCatalog.this.catalogName, (TableIdentifier)tableIdentifier);
            this.tableFileIO = defaultFileIO;
            this.makeMetadataCurrentOnCommit = makeMetadataCurrentOnCommit;
        }

        public TableMetadata current() {
            if (this.shouldRefresh) {
                return this.refresh();
            }
            return (TableMetadata)this.currentMetadata;
        }

        public TableMetadata refresh() {
            boolean currentMetadataWasAvailable = this.currentMetadata != null;
            try {
                this.doRefresh();
            }
            catch (NoSuchTableException e) {
                if (currentMetadataWasAvailable) {
                    LOGGER.warn("Could not find the table during refresh, setting current metadata to null", (Throwable)e);
                    this.shouldRefresh = true;
                }
                this.currentMetadata = null;
                this.currentMetadataLocation = null;
                this.version = -1;
                throw e;
            }
            return this.current();
        }

        public void commit(TableMetadata base, TableMetadata metadata) {
            if (base != this.current()) {
                if (base != null) {
                    throw new CommitFailedException("Cannot commit: stale table metadata", new Object[0]);
                }
                throw new AlreadyExistsException("Table already exists: %s", new Object[]{this.fullTableName});
            }
            if (base == metadata) {
                LOGGER.info("Nothing to commit.");
                return;
            }
            long start = System.currentTimeMillis();
            this.doCommit(base, metadata);
            CatalogUtil.deleteRemovedMetadataFiles((FileIO)this.io(), (TableMetadata)base, (TableMetadata)metadata);
            this.requestRefresh();
            LOGGER.info("Successfully committed to table {} in {} ms", (Object)this.fullTableName, (Object)(System.currentTimeMillis() - start));
        }

        public FileIO io() {
            return this.tableFileIO;
        }

        public String metadataFileLocation(String filename) {
            return this.metadataFileLocation(this.current(), filename);
        }

        public LocationProvider locationProvider() {
            return LocationProviders.locationsFor((String)this.current().location(), (Map)this.current().properties());
        }

        public void doRefresh() {
            LOGGER.debug("doRefresh for tableIdentifier {}", (Object)this.tableIdentifier);
            PolarisResolvedPathWrapper resolvedEntities = IcebergCatalog.this.resolvedEntityView.getPassthroughResolvedPath((Object)this.tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_TABLE);
            IcebergTableLikeEntity entity = null;
            if (resolvedEntities != null && !this.tableIdentifier.equals((Object)(entity = IcebergTableLikeEntity.of((PolarisBaseEntity)resolvedEntities.getRawLeafEntity())).getTableIdentifier())) {
                LOGGER.atError().addKeyValue("entity.getTableIdentifier()", (Object)entity.getTableIdentifier()).addKeyValue("tableIdentifier", (Object)this.tableIdentifier).log("Stored table identifier mismatches requested identifier");
            }
            String latestLocation = entity != null ? entity.getMetadataLocation() : null;
            LOGGER.debug("Refreshing latestLocation: {}", (Object)latestLocation);
            if (latestLocation == null) {
                this.disableRefresh();
            } else {
                IcebergCatalog.this.polarisEventListener.onBeforeRefreshTable(new IcebergRestCatalogEvents.BeforeRefreshTableEvent(IcebergCatalog.this.catalogName, this.tableIdentifier));
                this.refreshFromMetadataLocation(latestLocation, SHOULD_RETRY_REFRESH_PREDICATE, IcebergCatalog.this.getMaxMetadataRefreshRetries(), metadataLocation -> {
                    String latestLocationDir = latestLocation.substring(0, latestLocation.lastIndexOf(47));
                    FileIO fileIO = IcebergCatalog.this.loadFileIOForTableLike(this.tableIdentifier, Set.of(latestLocationDir), resolvedEntities, new HashMap<String, String>(IcebergCatalog.this.tableDefaultProperties), Set.of(PolarisStorageActions.READ, PolarisStorageActions.LIST));
                    return TableMetadataParser.read((FileIO)fileIO, (String)metadataLocation);
                });
                IcebergCatalog.this.polarisEventListener.onAfterRefreshTable(new IcebergRestCatalogEvents.AfterRefreshTableEvent(IcebergCatalog.this.catalogName, this.tableIdentifier));
            }
        }

        public void doCommit(TableMetadata base, TableMetadata metadata) {
            String existingLocation;
            IcebergTableLikeEntity entity;
            List resolvedNamespace;
            IcebergCatalog.this.polarisEventListener.onBeforeCommitTable(new IcebergRestCatalogEvents.BeforeCommitTableEvent(IcebergCatalog.this.catalogName, this.tableIdentifier, base, metadata));
            LOGGER.debug("doCommit for table {} with metadataBefore {}, metadataAfter {}", new Object[]{this.tableIdentifier, base, metadata});
            if (null == base && !IcebergCatalog.this.namespaceExists(this.tableIdentifier.namespace())) {
                throw new NoSuchNamespaceException("Cannot create table '%s'. Namespace does not exist: '%s'", new Object[]{this.tableIdentifier, this.tableIdentifier.namespace()});
            }
            PolarisResolvedPathWrapper resolvedTableEntities = IcebergCatalog.this.resolvedEntityView.getPassthroughResolvedPath((Object)this.tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_TABLE);
            PolarisResolvedPathWrapper resolvedStorageEntity = resolvedTableEntities == null ? IcebergCatalog.this.resolvedEntityView.getResolvedPath((Object)this.tableIdentifier.namespace()) : resolvedTableEntities;
            this.tableFileIO = IcebergCatalog.this.loadFileIOForTableLike(this.tableIdentifier, StorageUtil.getLocationsUsedByTable((TableMetadata)metadata), resolvedStorageEntity, new HashMap<String, String>(metadata.properties()), Set.of(PolarisStorageActions.READ, PolarisStorageActions.WRITE, PolarisStorageActions.LIST));
            List list = resolvedNamespace = resolvedTableEntities == null ? IcebergCatalog.this.resolvedEntityView.getResolvedPath((Object)this.tableIdentifier.namespace()).getRawFullPath() : resolvedTableEntities.getRawParentPath();
            if (base == null || !metadata.location().equals(base.location()) || !com.google.common.base.Objects.equal(base.properties().get("write.data.path"), metadata.properties().get("write.data.path"))) {
                Set dataLocations = StorageUtil.getLocationsUsedByTable((String)metadata.location(), (Map)metadata.properties());
                IcebergCatalog.this.validateLocationsForTableLike(this.tableIdentifier, dataLocations, resolvedStorageEntity);
                dataLocations.forEach(location -> IcebergCatalog.this.validateNoLocationOverlap(IcebergCatalog.this.catalogEntity, this.tableIdentifier, resolvedNamespace, (String)location, resolvedStorageEntity.getRawLeafEntity()));
                if (metadata.metadataFileLocation() != null) {
                    IcebergCatalog.this.validateMetadataFileInTableDir(this.tableIdentifier, metadata);
                }
            }
            String newLocation = this.writeNewMetadataIfRequired(base == null, metadata);
            String oldLocation = base == null ? null : base.metadataFileLocation();
            PolarisResolvedPathWrapper resolvedPath = IcebergCatalog.this.resolvedEntityView.getPassthroughResolvedPath((Object)this.tableIdentifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ANY_SUBTYPE);
            if (resolvedPath != null && resolvedPath.getRawLeafEntity() != null) {
                if (resolvedPath.getRawLeafEntity().getSubType() == PolarisEntitySubType.ICEBERG_VIEW) {
                    throw new AlreadyExistsException("View with same name already exists: %s", new Object[]{this.tableIdentifier});
                }
                if (resolvedPath.getRawLeafEntity().getSubType() == PolarisEntitySubType.GENERIC_TABLE) {
                    throw new AlreadyExistsException("Generic table with same name already exists: %s", new Object[]{this.tableIdentifier});
                }
            }
            if (null == (entity = IcebergTableLikeEntity.of((PolarisBaseEntity)(resolvedPath == null ? null : resolvedPath.getRawLeafEntity())))) {
                existingLocation = null;
                entity = ((IcebergTableLikeEntity.Builder)((IcebergTableLikeEntity.Builder)new IcebergTableLikeEntity.Builder(PolarisEntitySubType.ICEBERG_TABLE, this.tableIdentifier, newLocation).setCatalogId(IcebergCatalog.this.getCatalogId())).setBaseLocation(metadata.location()).setId(IcebergCatalog.this.getMetaStoreManager().generateNewEntityId(IcebergCatalog.this.getCurrentPolarisContext()).getId().longValue())).build();
            } else {
                existingLocation = entity.getMetadataLocation();
                entity = new IcebergTableLikeEntity.Builder(entity).setBaseLocation(metadata.location()).setMetadataLocation(newLocation).build();
            }
            if (!com.google.common.base.Objects.equal((Object)existingLocation, (Object)oldLocation)) {
                if (null == base) {
                    throw new AlreadyExistsException("Table already exists: %s", new Object[]{this.fullTableName});
                }
                if (null == existingLocation) {
                    throw new NoSuchTableException("Table does not exist: %s", new Object[]{this.fullTableName});
                }
                throw new CommitFailedException("Cannot commit to table %s metadata location from %s to %s because it has been concurrently modified to %s", new Object[]{this.tableIdentifier, oldLocation, newLocation, existingLocation});
            }
            if (this.makeMetadataCurrentOnCommit) {
                this.currentMetadata = TableMetadata.buildFrom((TableMetadata)metadata).withMetadataLocation(newLocation).discardChanges().build();
                this.currentMetadataLocation = newLocation;
            }
            if (null == existingLocation) {
                IcebergCatalog.this.createTableLike(this.tableIdentifier, (PolarisEntity)entity);
            } else {
                IcebergCatalog.this.updateTableLike(this.tableIdentifier, (PolarisEntity)entity);
            }
            IcebergCatalog.this.polarisEventListener.onAfterCommitTable(new IcebergRestCatalogEvents.AfterCommitTableEvent(IcebergCatalog.this.catalogName, this.tableIdentifier, base, metadata));
        }

        public TableOperations temp(final TableMetadata uncommittedMetadata) {
            return new TableOperations(){

                public TableMetadata current() {
                    return uncommittedMetadata;
                }

                public TableMetadata refresh() {
                    throw new UnsupportedOperationException("Cannot call refresh on temporary table operations");
                }

                public void commit(TableMetadata base, TableMetadata metadata) {
                    throw new UnsupportedOperationException("Cannot call commit on temporary table operations");
                }

                public String metadataFileLocation(String fileName) {
                    return BasePolarisTableOperations.this.metadataFileLocation(uncommittedMetadata, fileName);
                }

                public LocationProvider locationProvider() {
                    return LocationProviders.locationsFor((String)uncommittedMetadata.location(), (Map)uncommittedMetadata.properties());
                }

                public FileIO io() {
                    return BasePolarisTableOperations.this.io();
                }

                public EncryptionManager encryption() {
                    return BasePolarisTableOperations.this.encryption();
                }

                public long newSnapshotId() {
                    return BasePolarisTableOperations.this.newSnapshotId();
                }
            };
        }

        protected String writeNewMetadataIfRequired(boolean newTable, TableMetadata metadata) {
            return newTable && metadata.metadataFileLocation() != null ? metadata.metadataFileLocation() : this.writeNewMetadata(metadata, this.version + 1);
        }

        protected String writeNewMetadata(TableMetadata metadata, int newVersion) {
            String newTableMetadataFilePath = this.newTableMetadataFilePath(metadata, newVersion);
            OutputFile newMetadataLocation = this.io().newOutputFile(newTableMetadataFilePath);
            TableMetadataParser.overwrite((TableMetadata)metadata, (OutputFile)newMetadataLocation);
            return newMetadataLocation.location();
        }

        private String metadataFileLocation(TableMetadata metadata, String filename) {
            String metadataLocation = (String)metadata.properties().get("write.metadata.path");
            if (metadataLocation != null) {
                return String.format("%s/%s", LocationUtil.stripTrailingSlash((String)metadataLocation), filename);
            }
            return String.format("%s/%s/%s", metadata.location(), "metadata", filename);
        }

        private String newTableMetadataFilePath(TableMetadata meta, int newVersion) {
            String codecName = meta.property("write.metadata.compression-codec", "none");
            String fileExtension = TableMetadataParser.getFileExtension((String)codecName);
            return this.metadataFileLocation(meta, String.format(Locale.ROOT, "%05d-%s%s", newVersion, UUID.randomUUID(), fileExtension));
        }
    }

    private class BasePolarisViewOperations
    extends PolarisOperationsBase<ViewMetadata>
    implements ViewOperations {
        private final TableIdentifier identifier;
        private final String fullViewName;
        private FileIO viewFileIO;

        BasePolarisViewOperations(FileIO defaultFileIO, TableIdentifier identifier) {
            this.viewFileIO = defaultFileIO;
            this.identifier = identifier;
            this.fullViewName = ViewUtil.fullViewName((String)IcebergCatalog.this.catalogName, (TableIdentifier)identifier);
        }

        public ViewMetadata current() {
            if (this.shouldRefresh) {
                return this.refresh();
            }
            return (ViewMetadata)this.currentMetadata;
        }

        public ViewMetadata refresh() {
            boolean currentMetadataWasAvailable = this.currentMetadata != null;
            try {
                this.doRefresh();
            }
            catch (NoSuchViewException e) {
                if (currentMetadataWasAvailable) {
                    LOGGER.warn("Could not find the view during refresh, setting current metadata to null", (Throwable)e);
                    this.shouldRefresh = true;
                }
                this.currentMetadata = null;
                this.currentMetadataLocation = null;
                this.version = -1;
                throw e;
            }
            return this.current();
        }

        public void commit(ViewMetadata base, ViewMetadata metadata) {
            if (base != this.current()) {
                if (base != null) {
                    throw new CommitFailedException("Cannot commit: stale view metadata", new Object[0]);
                }
                throw new AlreadyExistsException("View already exists: %s", new Object[]{this.viewName()});
            }
            if (base == metadata) {
                LOGGER.info("Nothing to commit.");
                return;
            }
            long start = System.currentTimeMillis();
            this.doCommit(base, metadata);
            this.requestRefresh();
            LOGGER.info("Successfully committed to view {} in {} ms", (Object)this.viewName(), (Object)(System.currentTimeMillis() - start));
        }

        public void doRefresh() {
            PolarisResolvedPathWrapper resolvedEntities = IcebergCatalog.this.resolvedEntityView.getPassthroughResolvedPath((Object)this.identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_VIEW);
            IcebergTableLikeEntity entity = null;
            if (resolvedEntities != null && !this.identifier.equals((Object)(entity = IcebergTableLikeEntity.of((PolarisBaseEntity)resolvedEntities.getRawLeafEntity())).getTableIdentifier())) {
                LOGGER.atError().addKeyValue("entity.getTableIdentifier()", (Object)entity.getTableIdentifier()).addKeyValue("identifier", (Object)this.identifier).log("Stored view identifier mismatches requested identifier");
            }
            String latestLocation = entity != null ? entity.getMetadataLocation() : null;
            LOGGER.debug("Refreshing view latestLocation: {}", (Object)latestLocation);
            if (latestLocation == null) {
                this.disableRefresh();
            } else {
                IcebergCatalog.this.polarisEventListener.onBeforeRefreshView(new IcebergRestCatalogEvents.BeforeRefreshViewEvent(IcebergCatalog.this.catalogName, this.identifier));
                this.refreshFromMetadataLocation(latestLocation, SHOULD_RETRY_REFRESH_PREDICATE, IcebergCatalog.this.getMaxMetadataRefreshRetries(), metadataLocation -> {
                    String latestLocationDir = latestLocation.substring(0, latestLocation.lastIndexOf(47));
                    FileIO fileIO = IcebergCatalog.this.loadFileIOForTableLike(this.identifier, Set.of(latestLocationDir), resolvedEntities, new HashMap<String, String>(IcebergCatalog.this.tableDefaultProperties), Set.of(PolarisStorageActions.READ, PolarisStorageActions.LIST));
                    return ViewMetadataParser.read((InputFile)fileIO.newInputFile(metadataLocation));
                });
                IcebergCatalog.this.polarisEventListener.onAfterRefreshView(new IcebergRestCatalogEvents.AfterRefreshViewEvent(IcebergCatalog.this.catalogName, this.identifier));
            }
        }

        public void doCommit(ViewMetadata base, ViewMetadata metadata) {
            String existingLocation;
            List resolvedNamespace;
            IcebergCatalog.this.polarisEventListener.onBeforeCommitView(new IcebergRestCatalogEvents.BeforeCommitViewEvent(IcebergCatalog.this.catalogName, this.identifier, base, metadata));
            LOGGER.debug("doCommit for view {} with metadataBefore {}, metadataAfter {}", new Object[]{this.identifier, base, metadata});
            if (null == base && !IcebergCatalog.this.namespaceExists(this.identifier.namespace())) {
                throw new NoSuchNamespaceException("Cannot create view '%s'. Namespace does not exist: '%s'", new Object[]{this.identifier, this.identifier.namespace()});
            }
            PolarisResolvedPathWrapper resolvedTable = IcebergCatalog.this.resolvedEntityView.getPassthroughResolvedPath((Object)this.identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_TABLE);
            if (resolvedTable != null) {
                throw new AlreadyExistsException("Table with same name already exists: %s", new Object[]{this.identifier});
            }
            PolarisResolvedPathWrapper resolvedEntities = IcebergCatalog.this.resolvedEntityView.getPassthroughResolvedPath((Object)this.identifier, PolarisEntityType.TABLE_LIKE, PolarisEntitySubType.ICEBERG_VIEW);
            PolarisResolvedPathWrapper resolvedStorageEntity = resolvedEntities == null ? IcebergCatalog.this.resolvedEntityView.getResolvedPath((Object)this.identifier.namespace()) : resolvedEntities;
            List list = resolvedNamespace = resolvedEntities == null ? IcebergCatalog.this.resolvedEntityView.getResolvedPath((Object)this.identifier.namespace()).getRawFullPath() : resolvedEntities.getRawParentPath();
            if (base == null || !metadata.location().equals(base.location())) {
                IcebergCatalog.this.validateLocationForTableLike(this.identifier, metadata.location(), resolvedStorageEntity);
                IcebergCatalog.this.validateNoLocationOverlap(IcebergCatalog.this.catalogEntity, this.identifier, resolvedNamespace, metadata.location(), resolvedStorageEntity.getRawLeafEntity());
            }
            HashMap<String, String> tableProperties = new HashMap<String, String>(metadata.properties());
            this.viewFileIO = IcebergCatalog.this.loadFileIOForTableLike(this.identifier, StorageUtil.getLocationsUsedByTable((ViewMetadata)metadata), resolvedStorageEntity, tableProperties, Set.of(PolarisStorageActions.READ, PolarisStorageActions.WRITE));
            String newLocation = this.writeNewMetadataIfRequired(metadata);
            String oldLocation = base == null ? null : this.currentMetadataLocation;
            IcebergTableLikeEntity entity = IcebergTableLikeEntity.of((PolarisBaseEntity)(resolvedEntities == null ? null : resolvedEntities.getRawLeafEntity()));
            if (null == entity) {
                existingLocation = null;
                entity = ((IcebergTableLikeEntity.Builder)((IcebergTableLikeEntity.Builder)new IcebergTableLikeEntity.Builder(PolarisEntitySubType.ICEBERG_VIEW, this.identifier, newLocation).setCatalogId(IcebergCatalog.this.getCatalogId())).setId(IcebergCatalog.this.getMetaStoreManager().generateNewEntityId(IcebergCatalog.this.getCurrentPolarisContext()).getId().longValue())).build();
            } else {
                existingLocation = entity.getMetadataLocation();
                entity = new IcebergTableLikeEntity.Builder(entity).setMetadataLocation(newLocation).build();
            }
            if (!com.google.common.base.Objects.equal((Object)existingLocation, (Object)oldLocation)) {
                if (null == base) {
                    throw new AlreadyExistsException("View already exists: %s", new Object[]{this.identifier});
                }
                if (null == existingLocation) {
                    throw new NoSuchViewException("View does not exist: %s", new Object[]{this.identifier});
                }
                throw new CommitFailedException("Cannot commit to view %s metadata location from %s to %s because it has been concurrently modified to %s", new Object[]{this.identifier, oldLocation, newLocation, existingLocation});
            }
            if (null == existingLocation) {
                IcebergCatalog.this.createTableLike(this.identifier, (PolarisEntity)entity);
            } else {
                IcebergCatalog.this.updateTableLike(this.identifier, (PolarisEntity)entity);
            }
            IcebergCatalog.this.polarisEventListener.onAfterCommitView(new IcebergRestCatalogEvents.AfterCommitViewEvent(IcebergCatalog.this.catalogName, this.identifier, base, metadata));
        }

        protected String writeNewMetadataIfRequired(ViewMetadata metadata) {
            return null != metadata.metadataFileLocation() ? metadata.metadataFileLocation() : this.writeNewMetadata(metadata, this.version + 1);
        }

        private String writeNewMetadata(ViewMetadata metadata, int newVersion) {
            String newMetadataFilePath = this.newMetadataFilePath(metadata, newVersion);
            OutputFile newMetadataLocation = this.io().newOutputFile(newMetadataFilePath);
            ViewMetadataParser.overwrite((ViewMetadata)metadata, (OutputFile)newMetadataLocation);
            return newMetadataLocation.location();
        }

        private String newMetadataFilePath(ViewMetadata metadata, int newVersion) {
            String codecName = metadata.properties().getOrDefault("write.metadata.compression-codec", "gzip");
            String fileExtension = TableMetadataParser.getFileExtension((String)codecName);
            return this.metadataFileLocation(metadata, String.format(Locale.ROOT, "%05d-%s%s", newVersion, UUID.randomUUID(), fileExtension));
        }

        private String metadataFileLocation(ViewMetadata metadata, String filename) {
            String metadataLocation = (String)metadata.properties().get("write.metadata.path");
            if (metadataLocation != null) {
                return String.format("%s/%s", LocationUtil.stripTrailingSlash((String)metadataLocation), filename);
            }
            return String.format("%s/%s/%s", LocationUtil.stripTrailingSlash((String)metadata.location()), "metadata", filename);
        }

        public FileIO io() {
            return this.viewFileIO;
        }

        protected String viewName() {
            return this.fullViewName;
        }
    }

    private static abstract class PolarisOperationsBase<T> {
        protected static final String METADATA_FOLDER_NAME = "metadata";
        protected T currentMetadata = null;
        protected String currentMetadataLocation = null;
        protected boolean shouldRefresh = true;
        protected int version = -1;

        private PolarisOperationsBase() {
        }

        protected void requestRefresh() {
            this.shouldRefresh = true;
        }

        protected void disableRefresh() {
            this.shouldRefresh = false;
        }

        protected int parseVersion(String metadataLocation) {
            int versionStart = metadataLocation.lastIndexOf(47) + 1;
            int versionEnd = metadataLocation.indexOf(45, versionStart);
            if (versionEnd < 0) {
                return -1;
            }
            try {
                return Integer.parseInt(metadataLocation.substring(versionStart, versionEnd));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Unable to parse version from metadata location: {}", (Object)metadataLocation, (Object)e);
                return -1;
            }
        }

        protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries, Function<String, T> metadataLoader) {
            if (!com.google.common.base.Objects.equal((Object)this.currentMetadataLocation, (Object)newLocation)) {
                LOGGER.info("Refreshing table metadata from new version: {}", (Object)newLocation);
                AtomicReference newMetadata = new AtomicReference();
                Tasks.foreach((Object[])new String[]{newLocation}).retry(numRetries).exponentialBackoff(100L, 5000L, 600000L, 4.0).throwFailureWhenFinished().stopRetryOn(new Class[]{NotFoundException.class}).shouldRetryTest(shouldRetry).run(metadataLocation -> newMetadata.set(metadataLoader.apply((String)metadataLocation)));
                Object v = newMetadata.get();
                if (v instanceof TableMetadata) {
                    TableMetadata tableMetadata = (TableMetadata)v;
                    T t = this.currentMetadata;
                    if (t instanceof TableMetadata) {
                        TableMetadata currentTableMetadata = (TableMetadata)t;
                        String newUUID = tableMetadata.uuid();
                        if (this.currentMetadata != null && currentTableMetadata.uuid() != null && newUUID != null) {
                            Preconditions.checkState((boolean)newUUID.equals(currentTableMetadata.uuid()), (String)"Table UUID does not match: current=%s != refreshed=%s", (Object)currentTableMetadata.uuid(), (Object)newUUID);
                        }
                    }
                }
                this.currentMetadata = newMetadata.get();
                this.currentMetadataLocation = newLocation;
                this.version = this.parseVersion(newLocation);
            }
            this.shouldRefresh = false;
        }
    }
}

