/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackup;
import software.amazon.awssdk.services.rds.model.DBClusterAutomatedBackupListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbClusterAutomatedBackupsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbClusterAutomatedBackupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbClusterAutomatedBackupsResponse.getter(DescribeDbClusterAutomatedBackupsResponse::marker)).setter(DescribeDbClusterAutomatedBackupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBClusterAutomatedBackup>> DB_CLUSTER_AUTOMATED_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterAutomatedBackups").getter(DescribeDbClusterAutomatedBackupsResponse.getter(DescribeDbClusterAutomatedBackupsResponse::dbClusterAutomatedBackups)).setter(DescribeDbClusterAutomatedBackupsResponse.setter(Builder::dbClusterAutomatedBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterAutomatedBackups").build(), ListTrait.builder().memberLocationName("DBClusterAutomatedBackup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBClusterAutomatedBackup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterAutomatedBackup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_CLUSTER_AUTOMATED_BACKUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDbClusterAutomatedBackupsResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<DBClusterAutomatedBackup> dbClusterAutomatedBackups;

    private DescribeDbClusterAutomatedBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterAutomatedBackups = builder.dbClusterAutomatedBackups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasDbClusterAutomatedBackups() {
        return this.dbClusterAutomatedBackups != null && !(this.dbClusterAutomatedBackups instanceof SdkAutoConstructList);
    }

    public final List<DBClusterAutomatedBackup> dbClusterAutomatedBackups() {
        return this.dbClusterAutomatedBackups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterAutomatedBackups() ? this.dbClusterAutomatedBackups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterAutomatedBackupsResponse)) {
            return false;
        }
        DescribeDbClusterAutomatedBackupsResponse other = (DescribeDbClusterAutomatedBackupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasDbClusterAutomatedBackups() == other.hasDbClusterAutomatedBackups() && Objects.equals(this.dbClusterAutomatedBackups(), other.dbClusterAutomatedBackups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbClusterAutomatedBackupsResponse").add("Marker", (Object)this.marker()).add("DBClusterAutomatedBackups", this.hasDbClusterAutomatedBackups() ? this.dbClusterAutomatedBackups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBClusterAutomatedBackups": {
                return Optional.ofNullable(clazz.cast(this.dbClusterAutomatedBackups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("DBClusterAutomatedBackups", DB_CLUSTER_AUTOMATED_BACKUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClusterAutomatedBackupsResponse, T> g) {
        return obj -> g.apply((DescribeDbClusterAutomatedBackupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterAutomatedBackup> dbClusterAutomatedBackups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterAutomatedBackupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusterAutomatedBackups(model.dbClusterAutomatedBackups);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBClusterAutomatedBackup.Builder> getDbClusterAutomatedBackups() {
            List<DBClusterAutomatedBackup.Builder> result = DBClusterAutomatedBackupListCopier.copyToBuilder(this.dbClusterAutomatedBackups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterAutomatedBackups(Collection<DBClusterAutomatedBackup.BuilderImpl> dbClusterAutomatedBackups) {
            this.dbClusterAutomatedBackups = DBClusterAutomatedBackupListCopier.copyFromBuilder(dbClusterAutomatedBackups);
        }

        @Override
        public final Builder dbClusterAutomatedBackups(Collection<DBClusterAutomatedBackup> dbClusterAutomatedBackups) {
            this.dbClusterAutomatedBackups = DBClusterAutomatedBackupListCopier.copy(dbClusterAutomatedBackups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterAutomatedBackups(DBClusterAutomatedBackup ... dbClusterAutomatedBackups) {
            this.dbClusterAutomatedBackups(Arrays.asList(dbClusterAutomatedBackups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterAutomatedBackups(Consumer<DBClusterAutomatedBackup.Builder> ... dbClusterAutomatedBackups) {
            this.dbClusterAutomatedBackups(Stream.of(dbClusterAutomatedBackups).map(c -> (DBClusterAutomatedBackup)((DBClusterAutomatedBackup.Builder)DBClusterAutomatedBackup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbClusterAutomatedBackupsResponse build() {
            return new DescribeDbClusterAutomatedBackupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbClusterAutomatedBackupsResponse> {
        public Builder marker(String var1);

        public Builder dbClusterAutomatedBackups(Collection<DBClusterAutomatedBackup> var1);

        public Builder dbClusterAutomatedBackups(DBClusterAutomatedBackup ... var1);

        public Builder dbClusterAutomatedBackups(Consumer<DBClusterAutomatedBackup.Builder> ... var1);
    }
}

