/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse;

public class DescribeDBInstanceAutomatedBackupsPublisher
implements SdkPublisher<DescribeDbInstanceAutomatedBackupsResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbInstanceAutomatedBackupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBInstanceAutomatedBackupsPublisher(RdsAsyncClient client, DescribeDbInstanceAutomatedBackupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBInstanceAutomatedBackupsPublisher(RdsAsyncClient client, DescribeDbInstanceAutomatedBackupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbInstanceAutomatedBackupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbInstanceAutomatedBackupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBInstanceAutomatedBackup> dbInstanceAutomatedBackups() {
        Function<DescribeDbInstanceAutomatedBackupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbInstanceAutomatedBackups() != null) {
                return response.dbInstanceAutomatedBackups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbInstanceAutomatedBackupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbInstanceAutomatedBackupsResponseFetcher
    implements AsyncPageFetcher<DescribeDbInstanceAutomatedBackupsResponse> {
        private DescribeDbInstanceAutomatedBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbInstanceAutomatedBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbInstanceAutomatedBackupsResponse> nextPage(DescribeDbInstanceAutomatedBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBInstanceAutomatedBackupsPublisher.this.client.describeDBInstanceAutomatedBackups(DescribeDBInstanceAutomatedBackupsPublisher.this.firstRequest);
            }
            return DescribeDBInstanceAutomatedBackupsPublisher.this.client.describeDBInstanceAutomatedBackups((DescribeDbInstanceAutomatedBackupsRequest)((Object)DescribeDBInstanceAutomatedBackupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

