/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context.status;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.status.AnnotationMatchExceptionCheckStrategy;
import org.apache.skywalking.apm.agent.core.context.status.ExceptionCheckContext;
import org.apache.skywalking.apm.agent.core.context.status.ExceptionCheckStrategy;
import org.apache.skywalking.apm.agent.core.context.status.HierarchyMatchExceptionCheckStrategy;
import org.apache.skywalking.apm.agent.core.context.status.OffExceptionCheckStrategy;

public enum StatusChecker {
    OFF(Collections.singletonList(new OffExceptionCheckStrategy()), (isError, throwable) -> {}),
    HIERARCHY_MATCH(Arrays.asList(new HierarchyMatchExceptionCheckStrategy(), new AnnotationMatchExceptionCheckStrategy()), (isError, throwable) -> {
        if (isError.booleanValue()) {
            ExceptionCheckContext.INSTANCE.registerErrorStatusException(throwable);
        } else {
            ExceptionCheckContext.INSTANCE.registerIgnoredException(throwable);
        }
    });

    private final List<ExceptionCheckStrategy> strategies;
    private final ExceptionCheckCallback callback;

    public boolean checkStatus(Throwable e) {
        int maxDepth = Config.StatusCheck.MAX_RECURSIVE_DEPTH;
        boolean isError = true;
        while (isError && Objects.nonNull(e) && maxDepth-- > 0) {
            isError = this.check(e);
            e = e.getCause();
        }
        return isError;
    }

    private boolean check(Throwable e) {
        boolean isError = ExceptionCheckContext.INSTANCE.isChecked(e) ? ExceptionCheckContext.INSTANCE.isError(e) : this.strategies.stream().allMatch(item -> item.isError(e));
        this.callback.onChecked(isError, e);
        return isError;
    }

    @Generated
    private StatusChecker(List<ExceptionCheckStrategy> strategies, ExceptionCheckCallback callback) {
        this.strategies = strategies;
        this.callback = callback;
    }

    @FunctionalInterface
    private static interface ExceptionCheckCallback {
        public void onChecked(Boolean var1, Throwable var2);
    }
}

