/*
 * Decompiled with CFR 0.152.
 */
package vlsi.utils;

import com.github.andrewoma.dexx.collection.HashMap;
import com.github.andrewoma.dexx.collection.Map;
import com.github.andrewoma.dexx.collection.Pair;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import vlsi.utils.CompactHashMap;
import vlsi.utils.CompactHashMapClassEmptyDefaults;
import vlsi.utils.CompactHashMapDefaultValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CompactHashMapClass<K, V> {
    public static final CompactHashMapClass EMPTY = new CompactHashMapClassEmptyDefaults(new HashMap());
    final Map<K, Integer> key2slot;
    public static final String REMOVED_OBJECT = new String("Non existing mapping value");
    private static final Object NULL = new Object();

    public CompactHashMapClass(Map<K, Integer> key2slot) {
        this.key2slot = key2slot;
    }

    private K maskNull(K key) {
        return (K)(key == null ? NULL : key);
    }

    private K unmaskNull(K key) {
        return key == NULL ? null : (K)key;
    }

    protected java.util.Map<K, V> getDefaultValues() {
        return Collections.emptyMap();
    }

    protected abstract CompactHashMapClassEmptyDefaults<K, V> getMapWithEmptyDefaults();

    public V get(CompactHashMap<K, V> map, K key) {
        Object result = this.getInternal(map, key);
        return (V)(result != REMOVED_OBJECT ? result : null);
    }

    private Object getInternal(CompactHashMap<K, V> map, Object key) {
        Object nonNullKey = this.maskNull(key);
        Integer slot = (Integer)this.key2slot.get(nonNullKey);
        if (slot == null) {
            return this.getDefaultValues().get(nonNullKey);
        }
        return CompactHashMapClass.getValueFromSlot(map, slot);
    }

    protected static Object getValueFromSlot(CompactHashMap map, int slot) {
        switch (slot) {
            case -1: {
                return map.v1;
            }
            case -2: {
                return map.v2;
            }
            case -3: {
                return map.v3;
            }
        }
        return ((Object[])map.v1)[slot];
    }

    public V put(CompactHashMap<K, V> map, K key, Object value) {
        K nonNullKey = this.maskNull(key);
        Integer slot = (Integer)this.key2slot.get(nonNullKey);
        Object prevValue = REMOVED_OBJECT;
        if (slot == null) {
            prevValue = this.getDefaultValues().get(nonNullKey);
            java.util.Map<K, V> newDef = CompactHashMapDefaultValues.getNewDefaultValues(this.getDefaultValues(), nonNullKey, value);
            if (newDef != null) {
                map.klass = this.getMapWithEmptyDefaults().getNewDefaultClass(newDef);
                return (V)prevValue;
            }
            if (value == REMOVED_OBJECT) {
                return (V)prevValue;
            }
            slot = this.createNewSlot(map, nonNullKey);
        }
        switch (slot) {
            case -1: {
                if (prevValue == REMOVED_OBJECT) {
                    prevValue = map.v1;
                }
                map.v1 = value;
                break;
            }
            case -2: {
                if (prevValue == REMOVED_OBJECT) {
                    prevValue = map.v2;
                }
                map.v2 = value;
                break;
            }
            case -3: {
                if (prevValue == REMOVED_OBJECT) {
                    prevValue = map.v3;
                }
                map.v3 = value;
                break;
            }
            default: {
                Object[] array = (Object[])map.v1;
                if (prevValue == REMOVED_OBJECT) {
                    prevValue = array[slot];
                }
                array[slot.intValue()] = value;
            }
        }
        return (V)prevValue;
    }

    private Integer createNewSlot(CompactHashMap<K, V> map, K key) {
        Object[] array;
        CompactHashMapClass<K, V> nextKlass = this.getMapWithEmptyDefaults().getNextKlass(key, this.getDefaultValues());
        map.klass = nextKlass;
        int prevSize = this.key2slot.size();
        if (prevSize == 3) {
            Object[] array2 = new Object[4];
            array2[0] = map.v1;
            map.v1 = array2;
        } else if (prevSize > 3 && (array = (Object[])map.v1).length < prevSize - 1) {
            int newSize = array.length * 3 / 2;
            newSize += newSize & 1;
            Object[] newArray = new Object[newSize];
            System.arraycopy(array, 0, newArray, 0, array.length);
            map.v1 = newArray;
        }
        return (Integer)nextKlass.key2slot.get(key);
    }

    public int size(CompactHashMap<K, V> map) {
        return this.key2slot.size() + this.getDefaultValues().size() - this.removedSlotsCount(map);
    }

    private int removedSlotsCount(CompactHashMap<K, V> map) {
        int emptySlots = 0;
        switch (this.key2slot.size()) {
            default: {
                for (Object o : (Object[])map.v1) {
                    if (o != REMOVED_OBJECT) continue;
                    ++emptySlots;
                }
            }
            case 3: {
                if (map.v1 == REMOVED_OBJECT) {
                    ++emptySlots;
                }
            }
            case 2: {
                if (map.v2 == REMOVED_OBJECT) {
                    ++emptySlots;
                }
            }
            case 1: {
                if (map.v3 != REMOVED_OBJECT) break;
                ++emptySlots;
            }
            case 0: 
        }
        return emptySlots;
    }

    public boolean containsKey(CompactHashMap<K, V> map, Object key) {
        Object nonNullKey = this.maskNull(key);
        Integer slot = (Integer)this.key2slot.get(nonNullKey);
        if (slot == null) {
            return this.getDefaultValues().containsKey(nonNullKey);
        }
        return CompactHashMapClass.getValueFromSlot(map, slot) != REMOVED_OBJECT;
    }

    public Set<K> keySet(CompactHashMap<K, V> map) {
        return new KeySet<K, V>(map);
    }

    public Set<V> values(CompactHashMap<K, V> map) {
        return new Values<K, V>(map);
    }

    public Set<Map.Entry<K, V>> entrySet(CompactHashMap<K, V> map) {
        return new EntrySet<K, V>(map);
    }

    public void serialize(CompactHashMap<K, V> map, ObjectOutputStream s) throws IOException {
        int size = this.key2slot.size() - this.removedSlotsCount(map);
        s.writeInt(size);
        if (size > 0) {
            for (Pair entry : this.key2slot) {
                Object value = CompactHashMapClass.getValueFromSlot(map, (Integer)entry.component2());
                if (value == REMOVED_OBJECT) continue;
                s.writeObject(this.unmaskNull(entry.component1()));
                s.writeObject(value);
            }
        }
        s.writeObject(this.getDefaultValues());
    }

    public static <K, V> void deserialize(CompactHashMap<K, V> map, ObjectInputStream s) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        map.klass = EMPTY;
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            map.put(key, value);
        }
        java.util.Map defaults = (java.util.Map)s.readObject();
        for (Map.Entry entry : defaults.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;
        private final CompactHashMap<K, V> map;

        public SimpleEntry(CompactHashMap<K, V> map, K key, V value) {
            this.map = map;
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return (K)this.map.klass.unmaskNull(this.key);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.map.put(this.key, value);
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.getKey(), e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == NULL ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.map.klass.unmaskNull(this.key) + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntryIterator<K, V>
    extends HashIterator<K, V, Map.Entry<K, V>> {
        public EntryIterator(CompactHashMap<K, V> kvCompactMap) {
            super(kvCompactMap);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueIterator<K, V>
    extends HashIterator<K, V, V> {
        public ValueIterator(CompactHashMap<K, V> kvCompactMap) {
            super(kvCompactMap);
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeyIterator<K, V>
    extends HashIterator<K, V, K> {
        public KeyIterator(CompactHashMap<K, V> kvCompactMap) {
            super(kvCompactMap);
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class HashIterator<K, V, E>
    implements Iterator<E> {
        boolean defValues = true;
        private final CompactHashMap<K, V> map;
        Iterator it;
        Map.Entry<K, V> current;
        Map.Entry<K, V> next;

        public HashIterator(CompactHashMap<K, V> map) {
            this.map = map;
            if (map.isEmpty()) {
                return;
            }
            this.it = map.klass.getDefaultValues().entrySet().iterator();
            this.advance();
        }

        private void advance() {
            if (!this.it.hasNext() && this.defValues) {
                this.defValues = false;
                this.it = this.map.klass.key2slot.asMap().entrySet().iterator();
            }
            if (!this.it.hasNext()) {
                this.next = null;
                return;
            }
            while (this.it.hasNext()) {
                Object value;
                Map.Entry entry = (Map.Entry)this.it.next();
                if (this.defValues) {
                    value = entry.getValue();
                } else {
                    value = CompactHashMapClass.getValueFromSlot(this.map, (Integer)entry.getValue());
                    if (value == REMOVED_OBJECT) continue;
                }
                this.next = new SimpleEntry<K, V>(this.map, entry.getKey(), value);
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Map.Entry<K, V> nextEntry() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.advance();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.current.getKey());
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        private final CompactHashMap<K, V> map;

        public EntrySet(CompactHashMap<K, V> map) {
            this.map = map;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator<K, V>(this.map);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = e.getValue();
            V ourValue = this.map.get(key);
            if (value == null) {
                return ourValue == null && this.map.containsKey(key);
            }
            return value.equals(ourValue);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.map.remove(e.getKey()) != null;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Values<K, V>
    extends AbstractSet<V> {
        private final CompactHashMap<K, V> map;

        public Values(CompactHashMap<K, V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator<K, V>(this.map);
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KeySet<K, V>
    extends AbstractSet<K> {
        private final CompactHashMap<K, V> map;

        public KeySet(CompactHashMap<K, V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator<K, V>(this.map);
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

