/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc;

import org.apache.skywalking.apm.plugin.jdbc.JDBCPluginConfig;

public class PreparedStatementParameterBuilder {
    private static final String EMPTY_LIST = "[]";
    private Object[] parameters;
    private Integer maxIndex;

    public PreparedStatementParameterBuilder setParameters(Object[] parameters) {
        this.parameters = parameters;
        return this;
    }

    public PreparedStatementParameterBuilder setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
        return this;
    }

    public String build() {
        if (this.parameters == null) {
            return EMPTY_LIST;
        }
        return this.getParameterString();
    }

    private String getParameterString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.getMaxIndex(); ++i) {
            Object parameter = this.parameters[i];
            if (!first) {
                stringBuilder.append(",");
            }
            stringBuilder.append(parameter);
            first = false;
            if (JDBCPluginConfig.Plugin.JDBC.SQL_PARAMETERS_MAX_LENGTH <= 0 || stringBuilder.length() + EMPTY_LIST.length() <= JDBCPluginConfig.Plugin.JDBC.SQL_PARAMETERS_MAX_LENGTH) continue;
            return this.format(stringBuilder).substring(0, JDBCPluginConfig.Plugin.JDBC.SQL_PARAMETERS_MAX_LENGTH) + "...";
        }
        return this.format(stringBuilder);
    }

    private int getMaxIndex() {
        int maxIdx = this.maxIndex != null ? this.maxIndex : this.parameters.length;
        return Math.min(maxIdx, this.parameters.length);
    }

    private String format(StringBuilder stringBuilder) {
        return String.format("[%s]", stringBuilder.toString());
    }
}

