/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.network.trace.component.OfficialComponent;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class MysqlURLParser
extends AbstractURLParser {
    private static final int DEFAULT_PORT = 3306;
    private String dbType = "Mysql";
    private OfficialComponent component = ComponentsDefine.MYSQL_JDBC_DRIVER;

    public MysqlURLParser(String url) {
        super(url);
    }

    public MysqlURLParser(String url, String dbType, OfficialComponent component) {
        super(url);
        this.dbType = dbType;
        this.component = component;
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.url.indexOf("//");
        int hostLabelEndIndex = this.url.indexOf("/", hostLabelStartIndex + 2);
        if (hostLabelEndIndex == -1) {
            hostLabelEndIndex = this.url.indexOf("?", hostLabelStartIndex + 2);
        }
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    protected String fetchDatabaseNameFromURL(int startSize) {
        URLLocation hostsLocation = this.fetchDatabaseNameIndexRange(startSize);
        if (hostsLocation == null) {
            return "";
        }
        return this.url.substring(hostsLocation.startIndex(), hostsLocation.endIndex());
    }

    protected URLLocation fetchDatabaseNameIndexRange(int startSize) {
        int databaseStartTag = this.url.indexOf("/", startSize);
        if (databaseStartTag == -1) {
            return null;
        }
        int databaseEndTag = this.url.indexOf("?", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = this.url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        int databaseStartTag = this.url.lastIndexOf("/");
        int databaseEndTag = this.url.indexOf("?", databaseStartTag);
        if (databaseEndTag == -1) {
            databaseEndTag = this.url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse() {
        URLLocation location = this.fetchDatabaseHostsIndexRange();
        String hosts = this.url.substring(location.startIndex(), location.endIndex());
        String[] hostSegment = hosts.split(",");
        if (hostSegment.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String host : hostSegment) {
                if (host.split(":").length == 1) {
                    sb.append(host).append(":").append(3306).append(",");
                    continue;
                }
                sb.append(host).append(",");
            }
            return new ConnectionInfo(this.component, this.dbType, sb.substring(0, sb.length() - 1), this.fetchDatabaseNameFromURL());
        }
        String[] hostAndPort = hostSegment[0].split(":");
        if (hostAndPort.length != 1) {
            return new ConnectionInfo(this.component, this.dbType, hostAndPort[0], Integer.valueOf(hostAndPort[1]), this.fetchDatabaseNameFromURL(location.endIndex()));
        }
        return new ConnectionInfo(this.component, this.dbType, hostAndPort[0], 3306, this.fetchDatabaseNameFromURL(location.endIndex()));
    }
}

