/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.namingserver.entity.pojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.seata.common.metadata.Cluster;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.metadata.namingserver.NamingServerNode;
import org.apache.seata.common.metadata.namingserver.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ClusterData {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterData.class);
    private String clusterName;
    private String clusterType;
    private final Map<String, Unit> unitData;
    private final Lock lock = new ReentrantLock();

    public ClusterData() {
        this.unitData = new ConcurrentHashMap();
    }

    public ClusterData(String clusterName) {
        this.unitData = new ConcurrentHashMap();
        this.clusterName = clusterName;
    }

    public ClusterData(String clusterName, String clusterType) {
        this.unitData = new ConcurrentHashMap();
        this.clusterName = clusterName;
        this.clusterType = clusterType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public Map<String, Unit> getUnitData() {
        return this.unitData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstance(Node node, String unitName) {
        Unit unit = (Unit)this.unitData.get(unitName);
        if (Objects.isNull(unit)) {
            LOGGER.warn("unit {} is null", (Object)unitName);
            return;
        }
        unit.removeInstance(node);
        this.lock.lock();
        try {
            if (CollectionUtils.isEmpty((Collection)unit.getNamingInstanceList())) {
                this.unitData.remove(unitName);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Node> getInstanceList() {
        return this.unitData.values().stream().map(Unit::getNamingInstanceList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Cluster getClusterByUnits(Set<String> unitNames) {
        Cluster clusterResponse = new Cluster();
        clusterResponse.setClusterName(this.clusterName);
        clusterResponse.setClusterType(this.clusterType);
        if (CollectionUtils.isEmpty(unitNames)) {
            clusterResponse.appendUnits(this.unitData.values());
        } else {
            for (String unitName : unitNames) {
                ArrayList unitList = new ArrayList();
                Optional.ofNullable(this.unitData.get(unitName)).ifPresent(unitList::add);
                clusterResponse.appendUnits(unitList);
            }
        }
        return clusterResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerInstance(NamingServerNode instance, String unitName) {
        Unit currentUnit = this.unitData.computeIfAbsent(unitName, value -> {
            Unit unit = new Unit();
            CopyOnWriteArrayList instances = new CopyOnWriteArrayList();
            unit.setUnitName(unitName);
            unit.setNamingInstanceList(instances);
            return unit;
        });
        this.lock.lock();
        try {
            boolean bl = currentUnit.addInstance(instance);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

