/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.boot.autoconfigure.properties;

import org.apache.seata.common.DefaultValues;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="seata.transport")
public class TransportProperties {
    private String type = "TCP";
    private String server = "NIO";
    private boolean heartbeat = true;
    private String serialization = "seata";
    private String compressor = "none";
    private String protocol = "seata";
    private boolean enableClientBatchSendRequest = true;
    private boolean enableTmClientBatchSendRequest = false;
    private boolean enableRmClientBatchSendRequest = true;
    private boolean enableTcServerBatchSendResponse = false;
    private long rpcRmRequestTimeout = DefaultValues.DEFAULT_RPC_RM_REQUEST_TIMEOUT;
    private long rpcTmRequestTimeout = DefaultValues.DEFAULT_RPC_TM_REQUEST_TIMEOUT;
    private long rpcTcRequestTimeout = DefaultValues.DEFAULT_RPC_TC_REQUEST_TIMEOUT;
    private boolean enableClientSharedEventLoop = false;
    private int minHttpPoolSize = 10;
    private int maxHttpPoolSize = 100;
    private int maxHttpTaskQueueSize = 1000;
    private int httpPoolKeepAliveTime = 500;
    private int serverSocketSendBufSize = 153600;
    private int serverSocketResvBufSize = 153600;
    private int writeBufferHighWaterMark = 0x4000000;
    private int writeBufferLowWaterMark = 0x100000;
    private int soBackLogSize = 1024;
    private int serverChannelMaxIdleTimeSeconds = 30;
    private int minServerPoolSize = 50;
    private int maxServerPoolSize = 500;
    private int maxTaskQueueSize = 20000;
    private int keepAliveTime = 500;

    public String getType() {
        return this.type;
    }

    public TransportProperties setType(String type) {
        this.type = type;
        return this;
    }

    public String getServer() {
        return this.server;
    }

    public TransportProperties setServer(String server) {
        this.server = server;
        return this;
    }

    public boolean isHeartbeat() {
        return this.heartbeat;
    }

    public TransportProperties setHeartbeat(boolean heartbeat) {
        this.heartbeat = heartbeat;
        return this;
    }

    public String getSerialization() {
        return this.serialization;
    }

    public TransportProperties setSerialization(String serialization) {
        this.serialization = serialization;
        return this;
    }

    public String getCompressor() {
        return this.compressor;
    }

    public TransportProperties setCompressor(String compressor) {
        this.compressor = compressor;
        return this;
    }

    public boolean isEnableClientBatchSendRequest() {
        return this.enableClientBatchSendRequest;
    }

    public TransportProperties setEnableClientBatchSendRequest(boolean enableClientBatchSendRequest) {
        this.enableClientBatchSendRequest = enableClientBatchSendRequest;
        return this;
    }

    public boolean isEnableTmClientBatchSendRequest() {
        return this.enableTmClientBatchSendRequest;
    }

    public TransportProperties setEnableTmClientBatchSendRequest(boolean enableTmClientBatchSendRequest) {
        this.enableTmClientBatchSendRequest = enableTmClientBatchSendRequest;
        return this;
    }

    public boolean isEnableRmClientBatchSendRequest() {
        return this.enableRmClientBatchSendRequest;
    }

    public TransportProperties setEnableRmClientBatchSendRequest(boolean enableRmClientBatchSendRequest) {
        this.enableRmClientBatchSendRequest = enableRmClientBatchSendRequest;
        return this;
    }

    public boolean isEnableTcServerBatchSendResponse() {
        return this.enableTcServerBatchSendResponse;
    }

    public void setEnableTcServerBatchSendResponse(boolean enableTcServerBatchSendResponse) {
        this.enableTcServerBatchSendResponse = enableTcServerBatchSendResponse;
    }

    public long getRpcRmRequestTimeout() {
        return this.rpcRmRequestTimeout;
    }

    public void setRpcRmRequestTimeout(long rpcRmRequestTimeout) {
        this.rpcRmRequestTimeout = rpcRmRequestTimeout;
    }

    public long getRpcTmRequestTimeout() {
        return this.rpcTmRequestTimeout;
    }

    public void setRpcTmRequestTimeout(long rpcTmRequestTimeout) {
        this.rpcTmRequestTimeout = rpcTmRequestTimeout;
    }

    public long getRpcTcRequestTimeout() {
        return this.rpcTcRequestTimeout;
    }

    public boolean isEnableClientSharedEventLoop() {
        return this.enableClientSharedEventLoop;
    }

    public void setRpcTcRequestTimeout(long rpcTcRequestTimeout) {
        this.rpcTcRequestTimeout = rpcTcRequestTimeout;
    }

    public void setEnableClientSharedEventLoop(boolean useSharedEventLoop) {
        this.enableClientSharedEventLoop = useSharedEventLoop;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getMinHttpPoolSize() {
        return this.minHttpPoolSize;
    }

    public void setMinHttpPoolSize(int minHttpPoolSize) {
        this.minHttpPoolSize = minHttpPoolSize;
    }

    public int getMaxHttpPoolSize() {
        return this.maxHttpPoolSize;
    }

    public void setMaxHttpPoolSize(int maxHttpPoolSize) {
        this.maxHttpPoolSize = maxHttpPoolSize;
    }

    public int getMaxHttpTaskQueueSize() {
        return this.maxHttpTaskQueueSize;
    }

    public void setMaxHttpTaskQueueSize(int maxHttpTaskQueueSize) {
        this.maxHttpTaskQueueSize = maxHttpTaskQueueSize;
    }

    public int getHttpPoolKeepAliveTime() {
        return this.httpPoolKeepAliveTime;
    }

    public void setHttpPoolKeepAliveTime(int httpPoolKeepAliveTime) {
        this.httpPoolKeepAliveTime = httpPoolKeepAliveTime;
    }

    public int getServerSocketSendBufSize() {
        return this.serverSocketSendBufSize;
    }

    public void setServerSocketSendBufSize(int serverSocketSendBufSize) {
        this.serverSocketSendBufSize = serverSocketSendBufSize;
    }

    public int getServerSocketResvBufSize() {
        return this.serverSocketResvBufSize;
    }

    public void setServerSocketResvBufSize(int serverSocketResvBufSize) {
        this.serverSocketResvBufSize = serverSocketResvBufSize;
    }

    public int getWriteBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    public void setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
    }

    public int getWriteBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    public void setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
    }

    public int getSoBackLogSize() {
        return this.soBackLogSize;
    }

    public void setSoBackLogSize(int soBackLogSize) {
        this.soBackLogSize = soBackLogSize;
    }

    public int getServerChannelMaxIdleTimeSeconds() {
        return this.serverChannelMaxIdleTimeSeconds;
    }

    public void setServerChannelMaxIdleTimeSeconds(int serverChannelMaxIdleTimeSeconds) {
        this.serverChannelMaxIdleTimeSeconds = serverChannelMaxIdleTimeSeconds;
    }

    public int getMinServerPoolSize() {
        return this.minServerPoolSize;
    }

    public void setMinServerPoolSize(int minServerPoolSize) {
        this.minServerPoolSize = minServerPoolSize;
    }

    public int getMaxServerPoolSize() {
        return this.maxServerPoolSize;
    }

    public void setMaxServerPoolSize(int maxServerPoolSize) {
        this.maxServerPoolSize = maxServerPoolSize;
    }

    public int getMaxTaskQueueSize() {
        return this.maxTaskQueueSize;
    }

    public void setMaxTaskQueueSize(int maxTaskQueueSize) {
        this.maxTaskQueueSize = maxTaskQueueSize;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }
}

