/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.registry.client.api.Configurator;
import com.alipay.sofa.registry.client.api.EventBus;
import com.alipay.sofa.registry.client.api.Publisher;
import com.alipay.sofa.registry.client.api.Register;
import com.alipay.sofa.registry.client.api.RegistryClient;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.Subscriber;
import com.alipay.sofa.registry.client.api.exception.DuplicateException;
import com.alipay.sofa.registry.client.api.exception.RegistryClientException;
import com.alipay.sofa.registry.client.api.model.RegistryType;
import com.alipay.sofa.registry.client.api.registration.ConfiguratorRegistration;
import com.alipay.sofa.registry.client.api.registration.PublisherRegistration;
import com.alipay.sofa.registry.client.api.registration.SubscriberRegistration;
import com.alipay.sofa.registry.client.auth.AuthManager;
import com.alipay.sofa.registry.client.auth.NoopAuthManager;
import com.alipay.sofa.registry.client.event.ConfiguratorProcessEvent;
import com.alipay.sofa.registry.client.event.DefaultEventBus;
import com.alipay.sofa.registry.client.event.LookoutSubscriber;
import com.alipay.sofa.registry.client.event.SubscriberProcessEvent;
import com.alipay.sofa.registry.client.log.LoggerFactory;
import com.alipay.sofa.registry.client.provider.AbstractInternalRegister;
import com.alipay.sofa.registry.client.provider.DefaultConfigurator;
import com.alipay.sofa.registry.client.provider.DefaultObserverHandler;
import com.alipay.sofa.registry.client.provider.DefaultPublisher;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfig;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfigBuilder;
import com.alipay.sofa.registry.client.provider.DefaultServerManager;
import com.alipay.sofa.registry.client.provider.DefaultSubscriber;
import com.alipay.sofa.registry.client.provider.RegisterCache;
import com.alipay.sofa.registry.client.remoting.ClientConnection;
import com.alipay.sofa.registry.client.remoting.ClientConnectionCloseEventProcessor;
import com.alipay.sofa.registry.client.remoting.ClientConnectionOpenEventProcessor;
import com.alipay.sofa.registry.client.remoting.ReceivedConfigDataProcessor;
import com.alipay.sofa.registry.client.remoting.ReceivedDataProcessor;
import com.alipay.sofa.registry.client.remoting.ServerManager;
import com.alipay.sofa.registry.client.task.ObserverHandler;
import com.alipay.sofa.registry.client.task.SyncConfigThread;
import com.alipay.sofa.registry.client.task.TaskEvent;
import com.alipay.sofa.registry.client.task.WorkerThread;
import com.alipay.sofa.registry.client.util.StringUtils;
import com.alipay.sofa.registry.core.model.ReceivedConfigData;
import com.alipay.sofa.registry.core.model.ReceivedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class DefaultRegistryClient
implements RegistryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegistryClient.class);
    private RegistryClientConfig registryClientConfig;
    private RegisterCache registerCache;
    private ServerManager serverManager;
    private WorkerThread workerThread;
    private ClientConnection client;
    private Map<Class<?>, UserProcessor> userProcessorMap;
    private Map<ConnectionEventType, ConnectionEventProcessor> connectionEventProcessorMap;
    private ConcurrentMap<PublisherRegistration, Publisher> registrationPublisherMap;
    private ConcurrentMap<SubscriberRegistration, Subscriber> registrationSubscriberMap;
    private ConcurrentMap<ConfiguratorRegistration, Configurator> registrationConfiguratorMap;
    private ObserverHandler observerHandler;
    private AuthManager authManager;
    private EventBus eventBus;
    private LookoutSubscriber lookoutSubscriber;
    private AtomicBoolean init = new AtomicBoolean(false);

    public DefaultRegistryClient(RegistryClientConfig registryClientConfig) {
        this.registryClientConfig = this.cloneConfig(registryClientConfig);
        this.registerCache = new RegisterCache();
        this.registrationPublisherMap = new ConcurrentHashMap<PublisherRegistration, Publisher>();
        this.registrationSubscriberMap = new ConcurrentHashMap<SubscriberRegistration, Subscriber>();
        this.registrationConfiguratorMap = new ConcurrentHashMap<ConfiguratorRegistration, Configurator>();
    }

    private DefaultRegistryClientConfig cloneConfig(RegistryClientConfig registryClientConfig) {
        DefaultRegistryClientConfig cloneConfig = null;
        DefaultRegistryClientConfigBuilder builder = DefaultRegistryClientConfigBuilder.start();
        if (null != registryClientConfig) {
            cloneConfig = builder.setEnv(registryClientConfig.getEnv()).setAppName(registryClientConfig.getAppName()).setInstanceId(registryClientConfig.getInstanceId()).setDataCenter(registryClientConfig.getDataCenter()).setZone(registryClientConfig.getZone()).setRegistryEndpoint(registryClientConfig.getRegistryEndpoint()).setRegistryEndpointPort(registryClientConfig.getRegistryEndpointPort()).setConnectTimeout(registryClientConfig.getConnectTimeout()).setSocketTimeout(registryClientConfig.getSocketTimeout()).setInvokeTimeout(registryClientConfig.getInvokeTimeout()).setRecheckInterval(registryClientConfig.getRecheckInterval()).setObserverThreadCoreSize(registryClientConfig.getObserverThreadCoreSize()).setObserverThreadMaxSize(registryClientConfig.getObserverThreadMaxSize()).setObserverThreadQueueLength(registryClientConfig.getObserverThreadQueueLength()).setObserverCallbackTimeout(registryClientConfig.getObserverCallbackTimeout()).setSyncConfigRetryInterval(registryClientConfig.getSyncConfigRetryInterval()).setAccessKey(registryClientConfig.getAccessKey()).setSecretKey(registryClientConfig.getSecretKey()).build();
        }
        return cloneConfig;
    }

    public void init() {
        if (!this.init.compareAndSet(false, true)) {
            return;
        }
        if (null == this.lookoutSubscriber) {
            this.lookoutSubscriber = new LookoutSubscriber();
        }
        if (null == this.eventBus) {
            this.eventBus = new DefaultEventBus(this.registryClientConfig);
            this.eventBus.register(SubscriberProcessEvent.class, this.lookoutSubscriber);
            this.eventBus.register(ConfiguratorProcessEvent.class, this.lookoutSubscriber);
        }
        if (null == this.serverManager) {
            this.serverManager = new DefaultServerManager(this.registryClientConfig);
        }
        if (null == this.observerHandler) {
            this.observerHandler = new DefaultObserverHandler(this.registryClientConfig, this.eventBus);
        }
        if (null == this.authManager) {
            this.authManager = NoopAuthManager.INSTANCE;
        }
        ArrayList<UserProcessor> userProcessorList = new ArrayList<UserProcessor>();
        if (null == this.userProcessorMap) {
            userProcessorList.add((UserProcessor)new ReceivedDataProcessor(this.registerCache, this.observerHandler));
            userProcessorList.add((UserProcessor)new ReceivedConfigDataProcessor(this.registerCache, this.observerHandler));
        } else {
            UserProcessor userProcessor = this.userProcessorMap.get(ReceivedData.class);
            if (null == userProcessor) {
                userProcessorList.add((UserProcessor)new ReceivedDataProcessor(this.registerCache, this.observerHandler));
            }
            if (null == (userProcessor = this.userProcessorMap.get(ReceivedConfigData.class))) {
                userProcessorList.add((UserProcessor)new ReceivedConfigDataProcessor(this.registerCache, this.observerHandler));
            }
            userProcessorList.addAll(this.userProcessorMap.values());
        }
        if (null == this.connectionEventProcessorMap) {
            this.connectionEventProcessorMap = new HashMap<ConnectionEventType, ConnectionEventProcessor>(ConnectionEventType.values().length);
        }
        if (null == this.connectionEventProcessorMap.get(ConnectionEventType.CLOSE)) {
            ClientConnectionCloseEventProcessor connectionCloseEventProcessor = new ClientConnectionCloseEventProcessor();
            this.connectionEventProcessorMap.put(ConnectionEventType.CLOSE, connectionCloseEventProcessor);
        }
        if (null == this.connectionEventProcessorMap.get(ConnectionEventType.CONNECT)) {
            ClientConnectionOpenEventProcessor connectionOpenEventProcessor = new ClientConnectionOpenEventProcessor();
            this.connectionEventProcessorMap.put(ConnectionEventType.CONNECT, connectionOpenEventProcessor);
        }
        this.client = new ClientConnection(this.serverManager, userProcessorList, this.connectionEventProcessorMap, this.registerCache, this.registryClientConfig);
        this.workerThread = new WorkerThread(this.client, this.registryClientConfig, this.registerCache);
        this.client.setWorker(this.workerThread);
        this.client.init();
        new RegistryCheckThread().start();
        new SyncConfigThread(this.client, this.registerCache, this.registryClientConfig, this.observerHandler).start();
    }

    @Override
    public Publisher register(PublisherRegistration registration, String ... data) {
        Publisher publisher;
        if (!this.init.get()) {
            throw new IllegalStateException("Client needs to be initialized before using.");
        }
        if (null == registration) {
            throw new IllegalArgumentException("Registration can not be null.");
        }
        if (StringUtils.isBlank(registration.getDataId())) {
            throw new IllegalArgumentException("DataId can not be null");
        }
        if (StringUtils.isBlank(registration.getGroup())) {
            registration.setGroup("DEFAULT_GROUP");
        }
        if (null != (publisher = (Publisher)this.registrationPublisherMap.get(registration))) {
            this.throwDuplicateException(registration, publisher);
        }
        publisher = new DefaultPublisher(registration, this.workerThread, this.registryClientConfig);
        ((DefaultPublisher)publisher).setAuthManager(this.authManager);
        Publisher oldPublisher = this.registrationPublisherMap.putIfAbsent(registration, publisher);
        if (null != oldPublisher) {
            this.throwDuplicateException(registration, oldPublisher);
        }
        this.registerCache.addRegister(publisher);
        publisher.republish(data);
        LOGGER.info("[api] Regist publisher success, dataId: {}, group: {}, registerId: {}", new Object[]{publisher.getDataId(), publisher.getGroup(), publisher.getRegistId()});
        return publisher;
    }

    private void throwDuplicateException(PublisherRegistration registration, Publisher publisher) {
        LOGGER.info("[api] Publisher already exists, dataId: {}, group: {}, registerId: {}", new Object[]{publisher.getDataId(), publisher.getGroup(), publisher.getRegistId()});
        throw new DuplicateException("Duplicate Publisher registration. (dataId: " + registration.getDataId() + ", group: " + registration.getGroup() + ")");
    }

    @Override
    public Subscriber register(SubscriberRegistration registration) {
        Subscriber subscriber;
        if (!this.init.get()) {
            throw new IllegalStateException("Client needs to be initialized before using.");
        }
        if (null == registration) {
            throw new IllegalArgumentException("Registration can not be null.");
        }
        if (StringUtils.isBlank(registration.getDataId())) {
            throw new IllegalArgumentException("DataId can not be null.");
        }
        if (null == registration.getSubscriberDataObserver()) {
            throw new IllegalArgumentException("Subscriber data observer can not be null.");
        }
        if (StringUtils.isBlank(registration.getGroup())) {
            registration.setGroup("DEFAULT_GROUP");
        }
        if (null != (subscriber = (Subscriber)this.registrationSubscriberMap.get(registration))) {
            this.throwDuplicateException(registration, subscriber);
        }
        subscriber = new DefaultSubscriber(registration, this.workerThread, this.registryClientConfig);
        ((DefaultSubscriber)subscriber).setAuthManager(this.authManager);
        Subscriber oldSubscriber = this.registrationSubscriberMap.putIfAbsent(registration, subscriber);
        if (null != oldSubscriber) {
            this.throwDuplicateException(registration, oldSubscriber);
        }
        this.registerCache.addRegister(subscriber);
        this.addRegisterTask(subscriber);
        LOGGER.info("[api] Regist subscriber success, dataId: {}, group: {}, scope: {}, registerId: {}", new Object[]{subscriber.getDataId(), subscriber.getGroup(), subscriber.getScopeEnum(), subscriber.getRegistId()});
        return subscriber;
    }

    @Override
    public Configurator register(ConfiguratorRegistration registration) {
        Configurator configurator;
        if (!this.init.get()) {
            throw new IllegalStateException("Client needs to be initialized before using.");
        }
        if (null == registration) {
            throw new IllegalArgumentException("Registration can not be null.");
        }
        if (StringUtils.isBlank(registration.getDataId())) {
            throw new IllegalArgumentException("DataId can not be null.");
        }
        if (null == registration.getConfigDataObserver()) {
            throw new IllegalArgumentException("Config data observer can not be null");
        }
        if (StringUtils.isBlank(registration.getGroup())) {
            registration.setGroup("DEFAULT_GROUP");
        }
        if (null != (configurator = (Configurator)this.registrationConfiguratorMap.get(registration))) {
            this.throwDuplicateException(configurator);
        }
        configurator = new DefaultConfigurator(registration, this.registryClientConfig, this.workerThread);
        ((DefaultConfigurator)configurator).setAuthManager(this.authManager);
        Configurator oldConfigurator = this.registrationConfiguratorMap.putIfAbsent(registration, configurator);
        if (null != oldConfigurator) {
            this.throwDuplicateException(configurator);
        }
        this.registerCache.addRegister(configurator);
        this.addRegisterTask(configurator);
        LOGGER.info("[api] Regist configurator success, dataId: {}, registerId: {}", (Object)configurator.getDataId(), (Object)configurator.getRegistId());
        return configurator;
    }

    private void throwDuplicateException(Configurator configurator) {
        LOGGER.info("[api] Configurator already exists, dataId: {}, registerId: {}", (Object)configurator.getDataObserver(), (Object)configurator.getRegistId());
        throw new DuplicateException("Duplicate configurator registration. (dataId: " + configurator.getDataId() + " )");
    }

    @Override
    public int unregister(String dataId, String group, RegistryType registryType) {
        if (StringUtils.isBlank(dataId)) {
            throw new IllegalArgumentException("dataId can not be empty");
        }
        if (null == registryType) {
            throw new IllegalArgumentException("registry type can not be null");
        }
        if (null == group) {
            group = "DEFAULT_GROUP";
        }
        ArrayList<Register> registers = new ArrayList<Register>();
        if (RegistryType.PUBLISHER == registryType) {
            Collection<Publisher> publishers = this.registerCache.getAllPublishers();
            for (Publisher publisher : publishers) {
                if (!dataId.equals(publisher.getDataId()) || !group.equals(publisher.getGroup())) continue;
                registers.add(publisher);
            }
        } else if (RegistryType.SUBSCRIBER == registryType) {
            Collection<Subscriber> subscribers = this.registerCache.getAllSubscribers();
            for (Subscriber subscriber : subscribers) {
                if (!dataId.equals(subscriber.getDataId()) || !group.equals(subscriber.getGroup())) continue;
                registers.add(subscriber);
            }
        } else if (RegistryType.CONFIGURATOR == registryType) {
            Collection<Configurator> configurators = this.registerCache.getAllConfigurator();
            for (Configurator configurator : configurators) {
                if (!dataId.equals(configurator.getDataId())) continue;
                registers.add(configurator);
            }
        }
        for (Register register : registers) {
            register.unregister();
        }
        return registers.size();
    }

    private void throwDuplicateException(SubscriberRegistration registration, Subscriber subscriber) {
        LOGGER.info("[api] Subscriber already exists, dataId: {}, group: {}, scope: {}, registerId: {}", new Object[]{subscriber.getDataId(), subscriber.getGroup(), subscriber.getScopeEnum(), subscriber.getRegistId()});
        throw new DuplicateException("Duplicate subscriber registration. (dataId: " + registration.getDataId() + ", group: " + registration.getGroup() + ")");
    }

    private void addRegisterTask(Register register) throws RegistryClientException {
        try {
            TaskEvent event = new TaskEvent(register);
            this.workerThread.schedule(event);
        }
        catch (Exception e) {
            LOGGER.error("Register task schedule error, {}", (Object)register, (Object)e);
            throw new RegistryClientException("Register task schedule error", e);
        }
    }

    public RegisterCache getRegisterCache() {
        return this.registerCache;
    }

    public void setUserProcessorMap(Map<Class<?>, UserProcessor> userProcessorMap) {
        this.userProcessorMap = userProcessorMap;
    }

    public void setConnectionEventProcessorMap(Map<ConnectionEventType, ConnectionEventProcessor> connectionEventProcessorMap) {
        this.connectionEventProcessorMap = connectionEventProcessorMap;
    }

    public void setObserverHandler(ObserverHandler observerHandler) {
        this.observerHandler = observerHandler;
    }

    public void setServerManager(ServerManager serverManager) {
        this.serverManager = serverManager;
    }

    public void setAuthManager(AuthManager authManager) {
        this.authManager = authManager;
    }

    public void setLookoutSubscriber(LookoutSubscriber lookoutSubscriber) {
        this.lookoutSubscriber = lookoutSubscriber;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    class RegistryCheckThread
    extends Thread {
        public RegistryCheckThread() {
            super("RegistryClientCheckThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block9: while (true) {
                        Thread.sleep(DefaultRegistryClient.this.registryClientConfig.getRecheckInterval());
                        Collection<Publisher> allPublishers = DefaultRegistryClient.this.registerCache.getAllPublishers();
                        for (Publisher publisher : allPublishers) {
                            try {
                                if (null == publisher || ((AbstractInternalRegister)((Object)publisher)).isDone()) continue;
                                DefaultRegistryClient.this.addRegisterTask(publisher);
                            }
                            catch (Exception e) {
                                LOGGER.error("Sync publisher error, {}", (Object)publisher, (Object)e);
                            }
                        }
                        Collection<Subscriber> allSubscribers = DefaultRegistryClient.this.registerCache.getAllSubscribers();
                        for (Subscriber subscriber : allSubscribers) {
                            try {
                                if (null == subscriber || ((AbstractInternalRegister)((Object)subscriber)).isDone()) continue;
                                DefaultRegistryClient.this.addRegisterTask(subscriber);
                            }
                            catch (Exception e) {
                                LOGGER.error("Sync subscriber error, {}", (Object)subscriber, (Object)e);
                            }
                        }
                        Collection<Configurator> collection = DefaultRegistryClient.this.registerCache.getAllConfigurator();
                        Iterator<Configurator> iterator = collection.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block9;
                            Configurator configurator = iterator.next();
                            try {
                                if (null == configurator || ((AbstractInternalRegister)((Object)configurator)).isDone()) continue;
                                DefaultRegistryClient.this.addRegisterTask(configurator);
                            }
                            catch (Exception e) {
                                LOGGER.error("Sync configurator error, {}", (Object)configurator, (Object)e);
                            }
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("Execute error", e);
                    continue;
                }
                break;
            }
        }
    }
}

