/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.convert;

import dm.jdbc.convert.OffRowData;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import java.nio.charset.Charset;
import java.sql.Clob;

public class OffRowClobData
extends OffRowData {
    public OffRowClobData(Clob clob, Charset charset) {
        super(clob, charset, -1L);
        this.init();
    }

    @Override
    public void read(ByteArrayQueue byteArrayQueue) {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(byteArrayQueue);
        } else if (!this.readOver) {
            Clob clob = (Clob)this.obj;
            long l2 = clob.length();
            long l3 = l2 - this.position;
            int n2 = (int)(l3 > (long)READ_LEN ? (long)READ_LEN : l3);
            String string = clob.getSubString(this.position + 1L, n2);
            byte[] byArray = ByteUtil.fromString(string, this.encoding);
            this.position += (long)n2;
            if (this.position == l2) {
                this.readOver = true;
            }
            byteArrayQueue.putBytes(byArray, 0, byArray.length);
        }
    }

    @Override
    public byte[] readAll() {
        Clob clob = (Clob)this.obj;
        String string = ConvertUtil.getClobData(clob);
        return ByteUtil.fromString(string, this.encoding);
    }
}

