/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.convert;

import dm.jdbc.convert.J2DB;
import dm.jdbc.convert.OffRowData;
import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.ConvertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class OffRowStreamData
extends OffRowData {
    private int streamType;

    public OffRowStreamData(InputStream inputStream, Charset charset, long l2, int n2) {
        super(inputStream, charset, l2);
        this.streamType = n2;
        this.init();
    }

    @Override
    public void read(ByteArrayQueue byteArrayQueue) {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(byteArrayQueue);
        } else if (!this.readOver) {
            int n2 = READ_LEN;
            if (this.targetLength != -1L) {
                n2 = (int)(this.targetLength - this.position > (long)n2 ? (long)n2 : this.targetLength - this.position);
            }
            try {
                InputStream inputStream = (InputStream)this.obj;
                byte[] byArray = new byte[n2];
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    n3 = inputStream.read(byArray, n4, n2 - n4);
                    if (n3 <= 0) {
                        this.readOver = true;
                        break;
                    }
                    n4 += n3;
                }
                n2 = n4;
                this.position += (long)n2;
                if (n2 < byArray.length || this.targetLength != -1L && this.position == this.targetLength) {
                    this.readOver = true;
                }
                switch (this.streamType) {
                    case 2: {
                        char[] cArray = ConvertUtil.ASCIIBytesToJavaChars(byArray, 0, n2);
                        byte[] byArray2 = J2DB.toVarchar(String.valueOf(cArray), this.encoding);
                        byteArrayQueue.putBytes(byArray2, 0, byArray2.length);
                        break;
                    }
                    case 3: {
                        String string = ConvertUtil.UnicodeBytesToString(byArray, n2);
                        byte[] byArray3 = J2DB.toVarchar(string, this.encoding);
                        byteArrayQueue.putBytes(byArray3, 0, byArray3.length);
                        break;
                    }
                    default: {
                        byteArrayQueue.putBytes(byArray, 0, n2);
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                DBError.throwException(iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public byte[] readAll() {
        ByteArrayQueue byteArrayQueue = new ByteArrayQueue();
        this.read(byteArrayQueue);
        while (!this.readOver) {
            this.read(byteArrayQueue);
        }
        return byteArrayQueue.toBytes();
    }
}

