/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rw;

import dm.jdbc.desc.Configuration;
import dm.jdbc.desc.DmProperties;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.enums.RWSite;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.rw.ExecuteCallBack;
import dm.jdbc.rw.RWCounter;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class RWUtil {
    private static ILogger log = LogFactory.getLog(RWUtil.class);

    public static DmdbConnection connect(DmDriver dmDriver, DmProperties dmProperties) {
        dmProperties.setProperty(Configuration.loginMode.getName(), "1");
        DmdbConnection dmdbConnection = dmDriver.do_connect(dmProperties);
        dmdbConnection.rwInfo.rwCounter = RWCounter.getInstance(dmdbConnection, dmdbConnection.standbyCount);
        RWUtil.connectStandby(dmdbConnection);
        return dmdbConnection;
    }

    public static void reconnect(DmdbConnection dmdbConnection) {
        if (dmdbConnection.rwInfo == null) {
            return;
        }
        RWUtil.removeStandby(dmdbConnection);
        dmdbConnection.do_reconnect();
        dmdbConnection.rwInfo.cleanup();
        dmdbConnection.rwInfo.rwCounter = RWCounter.getInstance(dmdbConnection, dmdbConnection.standbyCount);
        RWUtil.connectStandby(dmdbConnection);
    }

    public static void recoverStandby(DmdbConnection dmdbConnection) {
        if (dmdbConnection.do_isClosed() || RWUtil.isStandbyAlive(dmdbConnection)) {
            return;
        }
        long l2 = System.currentTimeMillis();
        int n2 = dmdbConnection.rwStandbyRecoverTime;
        if (n2 <= 0 || l2 - dmdbConnection.rwInfo.tryRecoverTs < (long)n2) {
            return;
        }
        RWUtil.connectStandby(dmdbConnection);
        if (!RWUtil.checkStatusValid(dmdbConnection)) {
            RWUtil.removeStandby(dmdbConnection);
            log.debug((Object)dmdbConnection, "recoverStandby", "standby status invalid");
        }
        dmdbConnection.rwInfo.tryRecoverTs = l2;
    }

    private static void connectStandby(DmdbConnection dmdbConnection) {
        if (StringUtil.isEmpty(dmdbConnection.standbyHost) || dmdbConnection.standbyPort <= 0) {
            log.warn(dmdbConnection, "connStandby", "no standby");
            return;
        }
        try {
            DmProperties dmProperties = (DmProperties)dmdbConnection.props.clone();
            dmProperties.setProperty(Configuration.host.getName(), dmdbConnection.standbyHost);
            dmProperties.setProperty(Configuration.port.getName(), String.valueOf(dmdbConnection.standbyPort));
            dmProperties.setProperty(Configuration.rwStandby.getName(), String.valueOf(true));
            dmProperties.setProperty(Configuration.epGroup.getName(), null);
            dmProperties.setProperty(Configuration.loginMode.getName(), String.valueOf(2));
            dmProperties.setProperty(Configuration.switchTimes.getName(), "1");
            dmdbConnection.rwInfo.connStandby = DmDriver.driver.do_connect(dmProperties);
        }
        catch (Throwable throwable) {
            log.warn(dmdbConnection, "connStandby", throwable.getMessage());
        }
    }

    private static boolean checkStatusValid(DmdbConnection dmdbConnection) {
        block8: {
            DmdbResultSet dmdbResultSet;
            DmdbStatement dmdbStatement;
            DmdbResultSet dmdbResultSet2;
            DmdbStatement dmdbStatement2;
            block7: {
                DmdbConnection dmdbConnection2 = dmdbConnection.rwInfo.connStandby;
                if (dmdbConnection2 == null || dmdbConnection2.do_isClosed()) {
                    return false;
                }
                if (dmdbConnection2.svrMode != 2 || dmdbConnection2.svrStat != 4) {
                    return false;
                }
                dmdbStatement2 = null;
                dmdbResultSet2 = null;
                dmdbStatement = null;
                dmdbResultSet = null;
                int n2 = 0;
                try {
                    dmdbStatement2 = dmdbConnection.do_createStatement();
                    dmdbResultSet2 = dmdbStatement2.do_executeQuery("select oguid from v$instance");
                    dmdbResultSet2.do_next();
                    n2 = dmdbResultSet2.do_getInt(1);
                    dmdbStatement = dmdbConnection2.do_createStatement();
                    dmdbResultSet = dmdbStatement.do_executeQuery("select oguid from v$instance");
                    dmdbResultSet.do_next();
                    if (n2 != dmdbResultSet.do_getInt(1)) break block7;
                    MiscUtil.close(dmdbResultSet2);
                }
                catch (Exception exception) {
                    break block8;
                }
                finally {
                    MiscUtil.close(dmdbResultSet2);
                    MiscUtil.close(dmdbResultSet);
                    MiscUtil.close(dmdbStatement2);
                    MiscUtil.close(dmdbStatement);
                }
                MiscUtil.close(dmdbResultSet);
                MiscUtil.close(dmdbStatement2);
                MiscUtil.close(dmdbStatement);
                return true;
            }
            MiscUtil.close(dmdbResultSet2);
            MiscUtil.close(dmdbResultSet);
            MiscUtil.close(dmdbStatement2);
            MiscUtil.close(dmdbStatement);
        }
        return false;
    }

    public static void afterExceptionOnStandby(DmdbConnection dmdbConnection, SQLException sQLException) {
        if (sQLException.getErrorCode() == DBError.ECJDBC_COMMUNITION_ERROR.errCode) {
            RWUtil.removeStandby(dmdbConnection);
        }
    }

    private static void removeStandby(DmdbConnection dmdbConnection) {
        try {
            if (dmdbConnection.rwInfo.connStandby != null) {
                dmdbConnection.rwInfo.connStandby.do_close();
                dmdbConnection.rwInfo.connStandby = null;
            }
        }
        catch (Throwable throwable) {}
    }

    public static boolean isCreateStandbyStmt(DmdbStatement dmdbStatement) {
        return dmdbStatement != null && dmdbStatement.rwInfo.readOnly && RWUtil.isStandbyAlive(dmdbStatement.connection);
    }

    public static Object execute(DmdbStatement dmdbStatement, String string, ExecuteCallBack executeCallBack) {
        DmdbStatement dmdbStatement2 = dmdbStatement.rwInfo.stmtCurrent;
        RWUtil.recoverStandby(dmdbStatement.connection);
        RWUtil.distribute(dmdbStatement, string);
        if (dmdbStatement2 != dmdbStatement.rwInfo.stmtCurrent) {
            dmdbStatement.rwInfo.stmtCurrent.resetParams(dmdbStatement2);
        }
        Object object = null;
        boolean bl = false;
        try {
            object = executeCallBack.execute();
            DmdbStatement dmdbStatement3 = dmdbStatement.rwInfo.stmtCurrent;
            switch (dmdbStatement3.getRetType()) {
                case 147: 
                case 148: 
                case 151: 
                case 153: 
                case 165: 
                case 166: {
                    try {
                        DmdbStatement dmdbStatement4;
                        DmdbStatement dmdbStatement5 = dmdbStatement4 = dmdbStatement3 != dmdbStatement ? dmdbStatement : dmdbStatement.rwInfo.stmtStandby;
                        if (dmdbStatement4 == null) break;
                        dmdbStatement4.resetParams(dmdbStatement3);
                        executeCallBack.execute(dmdbStatement4);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 162: {
                    String string2 = StringUtil.isNotEmpty(string) ? string.trim() : (StringUtil.isNotEmpty(dmdbStatement.nativeSql) ? dmdbStatement.nativeSql.trim() : "");
                    String string3 = string2.split("[ (]", 2)[0];
                    if (string3.equalsIgnoreCase("SP_SET_PARA_VALUE") || string3.equalsIgnoreCase("SP_SET_SESSION_READONLY")) {
                        try {
                            DmdbStatement dmdbStatement6;
                            DmdbStatement dmdbStatement7 = dmdbStatement6 = dmdbStatement3 != dmdbStatement ? dmdbStatement : dmdbStatement.rwInfo.stmtStandby;
                            if (dmdbStatement6 == null) break;
                            dmdbStatement6.resetParams(dmdbStatement3);
                            executeCallBack.execute(dmdbStatement6);
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case 160: {
                    if (dmdbStatement.connection.rwHA && dmdbStatement3 == dmdbStatement.rwInfo.stmtStandby && (dmdbStatement3.execInfo.rsDatas == null || dmdbStatement3.execInfo.rsDatas.length == 0)) {
                        bl = true;
                    }
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            if (dmdbStatement.rwInfo.stmtCurrent == dmdbStatement.rwInfo.stmtStandby) {
                RWUtil.afterExceptionOnStandby(dmdbStatement.connection, sQLException);
                bl = true;
            }
            throw sQLException;
        }
        if (bl) {
            dmdbStatement.connection.rwInfo.toPrimary();
            dmdbStatement.rwInfo.stmtCurrent = dmdbStatement;
            dmdbStatement.resetParams(dmdbStatement.rwInfo.stmtStandby);
            return executeCallBack.execute(dmdbStatement);
        }
        return object;
    }

    public static boolean checkReadonly(DmdbStatement dmdbStatement, String string) {
        boolean bl = true;
        if (StringUtil.isNotEmpty(string) && !dmdbStatement.connection.rwIgnoreSql) {
            String string2 = string.trim();
            String string3 = string2.split(" ", 2)[0];
            bl = string3.equalsIgnoreCase("SELECT") ? dmdbStatement.resultSetConcurrency == 1007 : !string3.equalsIgnoreCase("INSERT") && !string3.equalsIgnoreCase("UPDATE") && !string3.equalsIgnoreCase("DELETE") && !string3.equalsIgnoreCase("CREATE") && !string3.equalsIgnoreCase("TRUNCATE") && !string3.equalsIgnoreCase("DROP") && !string3.equalsIgnoreCase("ALTER");
        }
        return bl;
    }

    public static RWSite distribute(DmdbStatement dmdbStatement, String string) {
        RWSite rWSite = null;
        rWSite = !RWUtil.isStandbyAlive(dmdbStatement.connection) ? dmdbStatement.connection.rwInfo.toPrimary() : ((dmdbStatement instanceof DmdbPreparedStatement ? !dmdbStatement.rwInfo.readOnly : !RWUtil.checkReadonly(dmdbStatement, string)) ? dmdbStatement.connection.rwInfo.toPrimary() : (dmdbStatement.connection.rwInfo.distribute == RWSite.PRIMARY && !dmdbStatement.connection.trxFinish || dmdbStatement.connection.rwInfo.distribute == RWSite.STANDBY && !dmdbStatement.connection.rwInfo.connStandby.trxFinish ? dmdbStatement.connection.rwInfo.distribute : (dmdbStatement.connection.isoLevel != 8 ? dmdbStatement.connection.rwInfo.toAny() : dmdbStatement.connection.rwInfo.toPrimary())));
        if (rWSite == RWSite.STANDBY && !RWUtil.isStandbyStatementValid(dmdbStatement)) {
            try {
                dmdbStatement.rwInfo.stmtStandby = dmdbStatement instanceof DmdbCallableStatement ? dmdbStatement.connection.rwInfo.connStandby.do_prepareCall(dmdbStatement.nativeSql, dmdbStatement.resultSetType, dmdbStatement.resultSetConcurrency, dmdbStatement.resultSetHoldability) : (dmdbStatement instanceof DmdbPreparedStatement ? dmdbStatement.connection.rwInfo.connStandby.do_prepareStatement(dmdbStatement.nativeSql, dmdbStatement.resultSetType, dmdbStatement.resultSetConcurrency, dmdbStatement.resultSetHoldability) : dmdbStatement.connection.rwInfo.connStandby.do_createStatement(dmdbStatement.resultSetType, dmdbStatement.resultSetConcurrency, dmdbStatement.resultSetHoldability));
            }
            catch (Exception exception) {
                rWSite = dmdbStatement.connection.rwInfo.toPrimary();
            }
        }
        dmdbStatement.rwInfo.stmtCurrent = rWSite == RWSite.PRIMARY ? dmdbStatement : dmdbStatement.rwInfo.stmtStandby;
        return rWSite;
    }

    public static boolean isStandbyAlive(DmdbConnection dmdbConnection) {
        return dmdbConnection.rwInfo.connStandby != null && !dmdbConnection.rwInfo.connStandby.do_isClosed();
    }

    public static boolean isStandbyStatementValid(DmdbStatement dmdbStatement) {
        return dmdbStatement.rwInfo.stmtStandby != null && !dmdbStatement.rwInfo.stmtStandby.do_isClosed();
    }
}

