/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.protobuf;

import com.google.protobuf.GeneratedMessageV3;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.BufferUtils;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.serializer.protobuf.ProtobufInnerSerializer;
import org.apache.seata.serializer.protobuf.convertor.PbConvertor;
import org.apache.seata.serializer.protobuf.manager.ProtobufConvertManager;

@LoadLevel(name="PROTOBUF", order=0)
public class ProtobufSerializer
implements Serializer {
    protected static final Charset UTF8 = StandardCharsets.UTF_8;

    public <T> byte[] serialize(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchConvertor(t.getClass().getName());
        GeneratedMessageV3 newBody = (GeneratedMessageV3)pbConvertor.convert2Proto(t);
        byte[] body = ProtobufInnerSerializer.serializeContent(newBody);
        String name = newBody.getDescriptorForType().getFullName();
        byte[] nameBytes = name.getBytes(UTF8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + nameBytes.length + body.length);
        byteBuffer.putInt(nameBytes.length);
        byteBuffer.put(nameBytes);
        byteBuffer.put(body);
        BufferUtils.flip((Buffer)byteBuffer);
        byte[] content = new byte[byteBuffer.limit()];
        byteBuffer.get(content);
        return content;
    }

    public <T> T deserialize(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int clazzNameLength = byteBuffer.getInt();
        byte[] clazzName = new byte[clazzNameLength];
        byteBuffer.get(clazzName);
        byte[] body = new byte[bytes.length - clazzNameLength - 4];
        byteBuffer.get(body);
        String descriptorName = new String(clazzName, UTF8);
        Class protobufClazz = ProtobufConvertManager.getInstance().fetchProtoClass(descriptorName);
        Object protobufObject = ProtobufInnerSerializer.deserializeContent(protobufClazz.getName(), body);
        PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchReversedConvertor(protobufClazz.getName());
        Object newBody = pbConvertor.convert2Model(protobufObject);
        return newBody;
    }
}

