/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplBigDecimal;
import com.alibaba.fastjson2.writer.ObjectWriterImplDouble;
import com.alibaba.fastjson2.writer.ObjectWriterImplFloat;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.DecimalFormat;

final class ObjectWriterArrayFinal
extends ObjectWriterPrimitiveImpl {
    public static final ObjectWriterArrayFinal FLOAT_ARRAY = new ObjectWriterArrayFinal(Float.class, null);
    public static final ObjectWriterArrayFinal DOUBLE_ARRAY = new ObjectWriterArrayFinal(Double.class, null);
    public static final ObjectWriterArrayFinal DECIMAL_ARRAY = new ObjectWriterArrayFinal(BigDecimal.class, null);
    final byte[] typeNameBytes;
    final long typeNameHash;
    final Class itemClass;
    volatile ObjectWriter itemObjectWriter;
    public final DecimalFormat format;
    public final boolean refDetect;

    public ObjectWriterArrayFinal(Class itemClass, DecimalFormat format) {
        this.itemClass = itemClass;
        this.format = format;
        String typeName = '[' + TypeUtils.getTypeName(itemClass);
        this.typeNameBytes = JSONB.toBytes(typeName);
        this.typeNameHash = Fnv.hashCode64(typeName);
        this.refDetect = !ObjectWriterProvider.isNotReferenceDetect(itemClass);
    }

    public ObjectWriter getItemObjectWriter(JSONWriter jsonWriter) {
        ObjectWriter itemObjectWriter = this.itemObjectWriter;
        if (itemObjectWriter == null) {
            itemObjectWriter = this.itemClass == Float.class ? (this.format != null ? new ObjectWriterImplFloat(this.format) : ObjectWriterImplFloat.INSTANCE) : (this.itemClass == Double.class ? (this.format != null ? new ObjectWriterImplDouble(this.format) : ObjectWriterImplDouble.INSTANCE) : (this.itemClass == BigDecimal.class ? (this.format != null ? new ObjectWriterImplBigDecimal(this.format, null) : ObjectWriterImplBigDecimal.INSTANCE) : jsonWriter.getObjectWriter(this.itemClass)));
            this.itemObjectWriter = itemObjectWriter;
        }
        return itemObjectWriter;
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (jsonWriter.jsonb) {
            this.writeJSONB(jsonWriter, object, fieldName, fieldType, features);
            return;
        }
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        boolean refDetect = jsonWriter.isRefDetect();
        if (refDetect) {
            refDetect = this.refDetect;
        }
        Object[] list = (Object[])object;
        jsonWriter.startArray();
        for (int i = 0; i < list.length; ++i) {
            String refPath;
            Object item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = list[i]) == null) {
                jsonWriter.writeNull();
                continue;
            }
            ObjectWriter itemObjectWriter = this.getItemObjectWriter(jsonWriter);
            if (refDetect && (refPath = jsonWriter.setPath(i, item)) != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(item);
                continue;
            }
            itemObjectWriter.write(jsonWriter, item, i, this.itemClass, features);
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        boolean refDetect = jsonWriter.isRefDetect();
        if (refDetect) {
            refDetect = this.refDetect;
        }
        Object[] list = (Object[])object;
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(this.typeNameBytes, this.typeNameHash);
        }
        jsonWriter.startArray(list.length);
        for (int i = 0; i < list.length; ++i) {
            String refPath;
            Object item = list[i];
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            ObjectWriter itemObjectWriter = this.getItemObjectWriter(jsonWriter);
            if (refDetect && (refPath = jsonWriter.setPath(i, item)) != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(item);
                continue;
            }
            itemObjectWriter.writeJSONB(jsonWriter, item, i, this.itemClass, features);
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
    }
}

