/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.metrics.registry.compact;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class TimerValue {
    private final LongAdder count = new LongAdder();
    private final LongAdder total = new LongAdder();
    private final AtomicLong max = new AtomicLong(0L);

    public long getCount() {
        return this.count.longValue();
    }

    public long getTotal() {
        return this.total.longValue();
    }

    public long getMax() {
        return this.max.get();
    }

    public double getAverage() {
        double count = this.count.doubleValue();
        double total = this.total.doubleValue();
        return count == 0.0 ? 0.0 : total / count;
    }

    public void record(long value, TimeUnit unit) {
        if (value < 0L) {
            return;
        }
        long changeValue = unit == TimeUnit.MICROSECONDS ? value : TimeUnit.MICROSECONDS.convert(value, unit);
        this.count.increment();
        this.total.add(changeValue);
        this.max.accumulateAndGet(changeValue, Math::max);
    }
}

