/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server;

import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.seata.common.XID;
import org.apache.seata.common.holder.ObjectHolder;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.common.util.UUIDGenerator;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.rpc.Disposable;
import org.apache.seata.core.rpc.RemotingServer;
import org.apache.seata.core.rpc.TransactionMessageHandler;
import org.apache.seata.core.rpc.netty.NettyRemotingServer;
import org.apache.seata.core.rpc.netty.NettyServerConfig;
import org.apache.seata.server.ParameterParser;
import org.apache.seata.server.ServerRunner;
import org.apache.seata.server.coordinator.DefaultCoordinator;
import org.apache.seata.server.instance.SeataInstanceStrategy;
import org.apache.seata.server.lock.LockerManagerFactory;
import org.apache.seata.server.metrics.MetricsManager;
import org.apache.seata.server.session.SessionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="seataServer")
public class Server {
    @Resource
    SeataInstanceStrategy seataInstanceStrategy;

    public void start(String[] args) {
        ParameterParser parameterParser = new ParameterParser(args);
        MetricsManager.get().init();
        ThreadPoolExecutor workingThreads = new ThreadPoolExecutor(NettyServerConfig.getMinServerPoolSize(), NettyServerConfig.getMaxServerPoolSize(), NettyServerConfig.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(NettyServerConfig.getMaxTaskQueueSize()), (ThreadFactory)new NamedThreadFactory("ServerHandlerThread", NettyServerConfig.getMaxServerPoolSize()), new ThreadPoolExecutor.CallerRunsPolicy());
        if (NetUtil.isValidIp((String)parameterParser.getHost(), (boolean)false)) {
            XID.setIpAddress((String)parameterParser.getHost());
        } else {
            String preferredNetworks = ConfigurationFactory.getInstance().getConfig("registry.preferredNetworks");
            if (StringUtils.isNotBlank((String)preferredNetworks)) {
                XID.setIpAddress((String)NetUtil.getLocalIp((String[])preferredNetworks.split(";")));
            } else {
                XID.setIpAddress((String)NetUtil.getLocalIp((String[])new String[0]));
            }
        }
        NettyRemotingServer nettyRemotingServer = new NettyRemotingServer(workingThreads);
        XID.setPort((int)nettyRemotingServer.getListenPort());
        UUIDGenerator.init((Long)parameterParser.getServerNode());
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)ObjectHolder.INSTANCE.getObject("springApplicationContext")).getBeanFactory();
        DefaultCoordinator coordinator = DefaultCoordinator.getInstance((RemotingServer)nettyRemotingServer);
        if (coordinator instanceof ApplicationListener) {
            beanFactory.registerSingleton(NettyRemotingServer.class.getName(), (Object)nettyRemotingServer);
            beanFactory.registerSingleton(DefaultCoordinator.class.getName(), (Object)coordinator);
            ((ConfigurableApplicationContext)ObjectHolder.INSTANCE.getObject("springApplicationContext")).addApplicationListener((ApplicationListener)coordinator);
        }
        SessionHolder.init();
        LockerManagerFactory.init();
        coordinator.init();
        nettyRemotingServer.setHandler((TransactionMessageHandler)coordinator);
        Optional.ofNullable(this.seataInstanceStrategy).ifPresent(SeataInstanceStrategy::init);
        ServerRunner.addDisposable((Disposable)coordinator);
        nettyRemotingServer.init();
    }
}

