/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.execute.branch;

import org.apache.seata.core.store.BranchTransactionDO;
import org.apache.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBranchSessionSyncMsg;
import org.apache.seata.server.cluster.raft.sync.msg.dto.BranchTransactionDTO;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.storage.SessionConverter;
import org.apache.seata.server.storage.raft.session.RaftSessionManager;

public class AddBranchSessionExecute
extends AbstractRaftMsgExecute {
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        BranchTransactionDTO branchTransactionDTO;
        String xid;
        RaftBranchSessionSyncMsg sessionSyncMsg = (RaftBranchSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager((String)sessionSyncMsg.getGroup());
        GlobalSession globalSession = raftSessionManager.findGlobalSession(xid = (branchTransactionDTO = sessionSyncMsg.getBranchSession()).getXid());
        if (globalSession == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The transaction corresponding to the XID: {} does not exist, which may cause a two-phase concurrency issue, msg type: {}", (Object)xid, (Object)syncMsg.getMsgType());
            }
            return false;
        }
        BranchSession branchSession = SessionConverter.convertBranchSession((BranchTransactionDO)branchTransactionDTO);
        branchSession.lock();
        globalSession.add(branchSession);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("addBranch xid: {},branchId: {}", (Object)branchTransactionDTO.getXid(), (Object)branchTransactionDTO.getBranchId());
        }
        return true;
    }
}

