/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.PageUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.apache.seata.core.store.db.sql.log.LogStoreSqlsFactory;
import org.apache.seata.server.console.entity.param.GlobalSessionParam;
import org.apache.seata.server.console.entity.vo.GlobalSessionVO;
import org.apache.seata.server.console.impl.AbstractGlobalService;
import org.apache.seata.server.console.service.BranchSessionService;
import org.apache.seata.server.console.service.GlobalSessionService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'db'.equals('${sessionMode}')}")
public class GlobalSessionDBServiceImpl
extends AbstractGlobalService
implements GlobalSessionService {
    private String globalTable;
    private String dbType;
    private DataSource dataSource;
    @Resource(type=BranchSessionService.class)
    private BranchSessionService branchSessionService;

    public GlobalSessionDBServiceImpl() {
        org.apache.seata.config.Configuration configuration = ConfigurationFactory.getInstance();
        this.globalTable = configuration.getConfig("store.db.globalTable", "global_table");
        this.dbType = configuration.getConfig("store.db.dbType");
        if (StringUtils.isBlank((String)this.dbType)) {
            throw new IllegalArgumentException("store.db.dbType should not be blank");
        }
        String dbDataSource = configuration.getConfig("store.db.datasource");
        if (StringUtils.isBlank((String)dbDataSource)) {
            throw new IllegalArgumentException("store.db.datasource should not be blank");
        }
        this.dataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)dbDataSource)).provide();
    }

    public PageResult<GlobalSessionVO> query(GlobalSessionParam param) {
        PageUtil.checkParam((int)param.getPageNum(), (int)param.getPageSize());
        ArrayList sqlParamList = new ArrayList();
        String whereCondition = this.getWhereConditionByParam(param, sqlParamList);
        String sourceSql = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getAllGlobalSessionSql(this.globalTable, whereCondition);
        String querySessionSql = PageUtil.pageSql((String)sourceSql, (String)this.dbType, (int)param.getPageNum(), (int)param.getPageSize());
        String sessionCountSql = PageUtil.countSql((String)sourceSql, (String)this.dbType);
        ArrayList<GlobalSessionVO> list = new ArrayList<GlobalSessionVO>();
        int count = 0;
        Connection conn = null;
        PreparedStatement ps = null;
        PreparedStatement countPs = null;
        ResultSet rs = null;
        ResultSet countRs = null;
        try {
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement(querySessionSql);
            countPs = conn.prepareStatement(sessionCountSql);
            PageUtil.setObject((PreparedStatement)ps, sqlParamList);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(GlobalSessionVO.convert((ResultSet)rs));
            }
            PageUtil.setObject((PreparedStatement)countPs, sqlParamList);
            countRs = countPs.executeQuery();
            if (countRs.next()) {
                count = countRs.getInt(1);
            }
            if (param.isWithBranch()) {
                for (GlobalSessionVO globalSessionVO : list) {
                    PageResult pageResp = this.branchSessionService.queryByXid(globalSessionVO.getXid());
                    globalSessionVO.setBranchSessionVOs(new HashSet(pageResp.getData()));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, countRs, ps, countPs, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, countRs, ps, countPs, conn});
        return PageResult.success(list, (Integer)count, (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }

    private String getWhereConditionByParam(GlobalSessionParam param, List<Object> sqlParamList) {
        StringBuilder whereConditionBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((String)param.getXid())) {
            whereConditionBuilder.append(" and xid = ? ");
            sqlParamList.add(param.getXid());
        }
        if (StringUtils.isNotBlank((String)param.getApplicationId())) {
            whereConditionBuilder.append(" and application_id = ? ");
            sqlParamList.add(param.getApplicationId());
        }
        if (param.getStatus() != null) {
            whereConditionBuilder.append(" and status = ? ");
            sqlParamList.add(param.getStatus());
        }
        if (StringUtils.isNotBlank((String)param.getTransactionName())) {
            whereConditionBuilder.append(" and transaction_name = ? ");
            sqlParamList.add(param.getTransactionName());
        }
        if (param.getTimeStart() != null) {
            whereConditionBuilder.append(PageUtil.getTimeStartSql((String)this.dbType, (String)"begin_time"));
            sqlParamList.add(param.getTimeStart() / 1000L);
        }
        if (param.getTimeEnd() != null) {
            whereConditionBuilder.append(PageUtil.getTimeEndSql((String)this.dbType, (String)"begin_time"));
            sqlParamList.add(param.getTimeEnd() / 1000L);
        }
        String whereCondition = whereConditionBuilder.toString();
        return whereCondition.replaceFirst("and", "where");
    }
}

