/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.metrics;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.seata.core.event.ExceptionEvent;
import org.apache.seata.core.event.GlobalTransactionEvent;
import org.apache.seata.core.event.RateLimitEvent;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.metrics.Id;
import org.apache.seata.metrics.registry.Registry;
import org.apache.seata.server.event.EventBusManager;
import org.apache.seata.server.metrics.MeterIdConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsSubscriber.class);
    private final Registry registry;
    private final Map<String, Consumer<GlobalTransactionEvent>> consumers;

    public MetricsSubscriber(Registry registry) {
        this.registry = registry;
        this.consumers = this.initializeConsumers();
    }

    private Map<String, Consumer<GlobalTransactionEvent>> initializeConsumers() {
        HashMap<String, Consumer<GlobalTransactionEvent>> consumerMap = new HashMap<String, Consumer<GlobalTransactionEvent>>();
        consumerMap.put(GlobalStatus.Begin.name(), arg_0 -> this.processGlobalStatusBegin(arg_0));
        consumerMap.put(GlobalStatus.Committed.name(), arg_0 -> this.processGlobalStatusCommitted(arg_0));
        consumerMap.put(GlobalStatus.Rollbacked.name(), arg_0 -> this.processGlobalStatusRollbacked(arg_0));
        consumerMap.put(GlobalStatus.CommitFailed.name(), arg_0 -> this.processGlobalStatusCommitFailed(arg_0));
        consumerMap.put(GlobalStatus.RollbackFailed.name(), arg_0 -> this.processGlobalStatusRollbackFailed(arg_0));
        consumerMap.put(GlobalStatus.TimeoutRollbacked.name(), arg_0 -> this.processGlobalStatusTimeoutRollbacked(arg_0));
        consumerMap.put(GlobalStatus.TimeoutRollbackFailed.name(), arg_0 -> this.processGlobalStatusTimeoutRollbackFailed(arg_0));
        consumerMap.put(GlobalStatus.CommitRetryTimeout.name(), arg_0 -> this.processGlobalStatusCommitRetryTimeout(arg_0));
        consumerMap.put(GlobalStatus.RollbackRetryTimeout.name(), arg_0 -> this.processGlobalStatusTimeoutRollbackRetryTimeout(arg_0));
        consumerMap.put("AfterCommitted", arg_0 -> this.processAfterGlobalCommitted(arg_0));
        consumerMap.put("AfterRollbacked", arg_0 -> this.processAfterGlobalRollbacked(arg_0));
        consumerMap.put(GlobalStatus.CommitRetrying.name(), arg_0 -> this.processGlobalStatusCommitRetrying(arg_0));
        consumerMap.put(GlobalStatus.RollbackRetrying.name(), arg_0 -> this.processGlobalStatusRollbackRetrying(arg_0));
        consumerMap.put(GlobalStatus.TimeoutRollbackRetrying.name(), arg_0 -> this.processGlobalStatusTimeoutRollbackRetrying(arg_0));
        return consumerMap;
    }

    private void increaseCounter(Id counterId, GlobalTransactionEvent event) {
        this.registry.getCounter(counterId.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
    }

    private void decreaseCounter(Id counterId, GlobalTransactionEvent event) {
        this.registry.getCounter(counterId.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).decrease(1L);
    }

    private void increaseSummary(Id summaryId, GlobalTransactionEvent event, long value) {
        this.registry.getSummary(summaryId.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(value);
    }

    private void increaseSummaryWithDetail(Id summaryId, GlobalTransactionEvent event, long value) {
        this.registry.getSummary(summaryId.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup()).withTag("transactionName", event.getName())).increase(value);
    }

    private void increaseTimer(Id timerId, GlobalTransactionEvent event) {
        this.registry.getTimer(timerId.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).record(event.getEndTime() - event.getBeginTime(), TimeUnit.MILLISECONDS);
    }

    private void processGlobalStatusBegin(GlobalTransactionEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("accept new event,xid:{},event:{}", (Object)event.getId(), (Object)event);
            for (Object object : EventBusManager.get().getSubscribers()) {
                LOGGER.debug("subscribe:{},threadName:{}", (Object)object.toString(), (Object)Thread.currentThread().getName());
            }
        }
        this.increaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
    }

    private void processGlobalStatusCommitted(GlobalTransactionEvent event) {
        if (event.isRetryGlobal()) {
            return;
        }
        this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
        this.increaseCounter(MeterIdConstants.COUNTER_COMMITTED, event);
        this.increaseSummary(MeterIdConstants.SUMMARY_COMMITTED, event, 1L);
        this.increaseTimer(MeterIdConstants.TIMER_COMMITTED, event);
    }

    private void processGlobalStatusRollbacked(GlobalTransactionEvent event) {
        if (event.isRetryGlobal()) {
            return;
        }
        this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
        this.increaseCounter(MeterIdConstants.COUNTER_ROLLBACKED, event);
        this.increaseSummary(MeterIdConstants.SUMMARY_ROLLBACKED, event, 1L);
        this.increaseTimer(MeterIdConstants.TIMER_ROLLBACKED, event);
    }

    private void processAfterGlobalRollbacked(GlobalTransactionEvent event) {
        if (event.isRetryGlobal() && event.isRetryBranch()) {
            this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
        }
        this.increaseCounter(MeterIdConstants.COUNTER_AFTER_ROLLBACKED, event);
        this.increaseSummary(MeterIdConstants.SUMMARY_AFTER_ROLLBACKED, event, 1L);
        this.increaseTimer(MeterIdConstants.TIMER_AFTER_ROLLBACKED, event);
    }

    private void processAfterGlobalCommitted(GlobalTransactionEvent event) {
        if (event.isRetryGlobal() && event.isRetryBranch()) {
            this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
        }
        this.increaseCounter(MeterIdConstants.COUNTER_AFTER_COMMITTED, event);
        this.increaseSummary(MeterIdConstants.SUMMARY_AFTER_COMMITTED, event, 1L);
        this.increaseTimer(MeterIdConstants.TIMER_AFTER_COMMITTED, event);
    }

    private void processGlobalStatusCommitFailed(GlobalTransactionEvent event) {
        this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
        this.reportFailed(event);
    }

    private void processGlobalStatusRollbackFailed(GlobalTransactionEvent event) {
        this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
        this.reportFailed(event);
    }

    private void processGlobalStatusTimeoutRollbacked(GlobalTransactionEvent event) {
        this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
    }

    private void processGlobalStatusTimeoutRollbackFailed(GlobalTransactionEvent event) {
        this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
        this.increaseSummary(MeterIdConstants.SUMMARY_TWO_PHASE_TIMEOUT, event, 1L);
        this.reportFailed(event);
    }

    private void processGlobalStatusCommitRetryTimeout(GlobalTransactionEvent event) {
        this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
        this.increaseSummary(MeterIdConstants.SUMMARY_TWO_PHASE_TIMEOUT, event, 1L);
        this.reportFailed(event);
    }

    private void processGlobalStatusTimeoutRollbackRetryTimeout(GlobalTransactionEvent event) {
        this.decreaseCounter(MeterIdConstants.COUNTER_ACTIVE, event);
        this.increaseSummary(MeterIdConstants.SUMMARY_TWO_PHASE_TIMEOUT, event, 1L);
        this.reportFailed(event);
    }

    private void processGlobalStatusCommitRetrying(GlobalTransactionEvent event) {
        this.increaseSummaryWithDetail(MeterIdConstants.SUMMARY_COMMIT_RETRYING, event, 1L);
    }

    private void processGlobalStatusRollbackRetrying(GlobalTransactionEvent event) {
        this.increaseSummaryWithDetail(MeterIdConstants.SUMMARY_ROLLBACK_RETRYING, event, 1L);
    }

    private void processGlobalStatusTimeoutRollbackRetrying(GlobalTransactionEvent event) {
        this.increaseSummaryWithDetail(MeterIdConstants.SUMMARY_TIMEOUT_ROLLBACK_RETRYING, event, 1L);
    }

    private void reportFailed(GlobalTransactionEvent event) {
        this.increaseSummary(MeterIdConstants.SUMMARY_FAILED, event, 1L);
        this.increaseTimer(MeterIdConstants.TIMER_FAILED, event);
    }

    @Subscribe
    public void recordGlobalTransactionEventForMetrics(GlobalTransactionEvent event) {
        if (this.registry != null && this.consumers.containsKey(event.getStatus())) {
            ((Consumer)this.consumers.get(event.getStatus())).accept(event);
        }
    }

    @Subscribe
    public void exceptionEventForMetrics(ExceptionEvent event) {
        this.registry.getSummary(MeterIdConstants.SUMMARY_EXP.withTag("applicationId", event.getName())).increase(1L);
    }

    @Subscribe
    public void recordRateLimitEventForMetrics(RateLimitEvent event) {
        this.registry.getSummary(MeterIdConstants.SUMMARY_RATE_LIMIT.withTag("limitType", event.getLimitType()).withTag("applicationId", event.getApplicationId()).withTag("clientId", event.getClientId()).withTag("hostAndPort", event.getServerIpAddressAndPort())).increase(1L);
    }

    public boolean equals(Object obj) {
        return this.getClass().getName().equals(obj.getClass().getName());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

