/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.db.lock;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.common.util.IOUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationChangeListener;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.store.DistributedLockDO;
import org.apache.seata.core.store.DistributedLocker;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.apache.seata.core.store.db.sql.distributed.lock.DistributedLockSqlFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="db", scope=Scope.SINGLETON)
public class DataBaseDistributedLocker
implements DistributedLocker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataBaseDistributedLocker.class);
    private final String dbType;
    private final String datasourceType;
    private volatile String distributedLockTable;
    private DataSource distributedLockDataSource;
    private static final String LOCK_WAIT_TIMEOUT_MYSQL_MESSAGE = "try restarting transaction";
    private static final int LOCK_WAIT_TIMEOUT_MYSQL_CODE = 1205;
    private static final Set<Integer> IGNORE_MYSQL_CODE = new HashSet();
    private static final Set<String> IGNORE_MYSQL_MESSAGE = new HashSet();
    @Deprecated
    private volatile boolean demotion;

    public DataBaseDistributedLocker() {
        Configuration configuration = ConfigurationFactory.getInstance();
        this.distributedLockTable = configuration.getConfig("store.db.distributedLockTable");
        this.dbType = configuration.getConfig("store.db.dbType");
        this.datasourceType = configuration.getConfig("store.db.datasource");
        if (StringUtils.isBlank((String)this.distributedLockTable)) {
            this.demotion = true;
            configuration.addConfigListener("store.db.distributedLockTable", (ConfigurationChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            LOGGER.error("The distribute lock table is not config, please create the target table and config it");
            return;
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acquireLock(DistributedLockDO distributedLockDO) {
        if (this.demotion) {
            return true;
        }
        Connection connection = null;
        boolean originalAutoCommit = false;
        try {
            connection = this.distributedLockDataSource.getConnection();
            originalAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            DistributedLockDO lockFromDB = this.getDistributedLockDO(connection, distributedLockDO.getLockKey());
            if (null == lockFromDB) {
                boolean ret = this.insertDistribute(connection, distributedLockDO);
                connection.commit();
                boolean bl = ret;
                return bl;
            }
            if (lockFromDB.getExpireTime() >= System.currentTimeMillis()) {
                LOGGER.debug("the distribute lock for key :{} is holding by :{}, acquire lock failure.", (Object)distributedLockDO.getLockKey(), (Object)lockFromDB.getLockValue());
                connection.commit();
                boolean ret = false;
                return ret;
            }
            boolean ret = this.updateDistributedLock(connection, distributedLockDO);
            connection.commit();
            boolean bl = ret;
            return bl;
        }
        catch (SQLException ex) {
            if (!this.ignoreSQLException(ex)) {
                LOGGER.error("execute acquire lock failure, key is: {}", (Object)distributedLockDO.getLockKey(), (Object)ex);
            }
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                LOGGER.warn("rollback fail because of {}", (Object)e.getMessage(), (Object)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (originalAutoCommit) {
                    connection.setAutoCommit(true);
                }
                IOUtil.close((AutoCloseable)connection);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseLock(DistributedLockDO distributedLockDO) {
        boolean bl;
        if (this.demotion) {
            return true;
        }
        Connection connection = null;
        boolean originalAutoCommit = false;
        try {
            connection = this.distributedLockDataSource.getConnection();
            originalAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            DistributedLockDO distributedLockDOFromDB = this.getDistributedLockDO(connection, distributedLockDO.getLockKey());
            if (null == distributedLockDOFromDB) {
                throw new ShouldNeverHappenException("distributedLockDO would not be null when release distribute lock");
            }
            if (distributedLockDOFromDB.getExpireTime() >= System.currentTimeMillis() && !Objects.equals(distributedLockDOFromDB.getLockValue(), distributedLockDO.getLockValue())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("the distribute lock for key :{} is holding by :{}, skip the release lock.", (Object)distributedLockDO.getLockKey(), (Object)distributedLockDOFromDB.getLockValue());
                }
                connection.commit();
                boolean bl2 = true;
                return bl2;
            }
            distributedLockDO.setLockValue(" ");
            distributedLockDO.setExpireTime(Long.valueOf(0L));
            boolean ret = this.updateDistributedLock(connection, distributedLockDO);
            connection.commit();
            bl = ret;
        }
        catch (SQLException ex) {
            if (!this.ignoreSQLException(ex)) {
                LOGGER.error("execute release lock failure, key is: {}", (Object)distributedLockDO.getLockKey(), (Object)ex);
            }
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException e) {
                LOGGER.warn("rollback fail because of {}", (Object)e.getMessage(), (Object)e);
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (originalAutoCommit) {
                    connection.setAutoCommit(true);
                }
                IOUtil.close((AutoCloseable)connection);
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    protected DistributedLockDO getDistributedLockDO(Connection connection, String key) throws SQLException {
        try (PreparedStatement pst = connection.prepareStatement(DistributedLockSqlFactory.getDistributedLogStoreSql((String)this.dbType).getSelectDistributeForUpdateSql(this.distributedLockTable));){
            pst.setString(1, key);
            ResultSet resultSet = pst.executeQuery();
            if (resultSet.next()) {
                DistributedLockDO distributedLock = new DistributedLockDO();
                distributedLock.setExpireTime(Long.valueOf(resultSet.getLong("expire")));
                distributedLock.setLockValue(resultSet.getString("lock_value"));
                distributedLock.setLockKey(key);
                DistributedLockDO distributedLockDO = distributedLock;
                return distributedLockDO;
            }
            DistributedLockDO distributedLockDO = null;
            return distributedLockDO;
        }
    }

    protected boolean insertDistribute(Connection connection, DistributedLockDO distributedLockDO) throws SQLException {
        try (PreparedStatement insertPst = connection.prepareStatement(DistributedLockSqlFactory.getDistributedLogStoreSql((String)this.dbType).getInsertSql(this.distributedLockTable));){
            insertPst.setString(1, distributedLockDO.getLockKey());
            insertPst.setString(2, distributedLockDO.getLockValue());
            if (distributedLockDO.getExpireTime() > 0L) {
                distributedLockDO.setExpireTime(Long.valueOf(distributedLockDO.getExpireTime() + System.currentTimeMillis()));
            }
            insertPst.setLong(3, distributedLockDO.getExpireTime());
            boolean bl = insertPst.executeUpdate() > 0;
            return bl;
        }
    }

    protected boolean updateDistributedLock(Connection connection, DistributedLockDO distributedLockDO) throws SQLException {
        try (PreparedStatement updatePst = connection.prepareStatement(DistributedLockSqlFactory.getDistributedLogStoreSql((String)this.dbType).getUpdateSql(this.distributedLockTable));){
            updatePst.setString(1, distributedLockDO.getLockValue());
            if (distributedLockDO.getExpireTime() > 0L) {
                distributedLockDO.setExpireTime(Long.valueOf(distributedLockDO.getExpireTime() + System.currentTimeMillis()));
            }
            updatePst.setLong(2, distributedLockDO.getExpireTime());
            updatePst.setString(3, distributedLockDO.getLockKey());
            boolean bl = updatePst.executeUpdate() > 0;
            return bl;
        }
    }

    private void init() {
        this.distributedLockDataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)this.datasourceType)).provide();
    }

    private boolean ignoreSQLException(SQLException exception) {
        if (IGNORE_MYSQL_CODE.contains(exception.getErrorCode())) {
            return true;
        }
        if (StringUtils.isNotBlank((String)exception.getMessage())) {
            return IGNORE_MYSQL_MESSAGE.stream().anyMatch(message -> exception.getMessage().contains((CharSequence)message));
        }
        return false;
    }

    static /* synthetic */ String access$002(DataBaseDistributedLocker x0, String x1) {
        x0.distributedLockTable = x1;
        return x0.distributedLockTable;
    }

    static /* synthetic */ void access$100(DataBaseDistributedLocker x0) {
        x0.init();
    }

    static /* synthetic */ boolean access$202(DataBaseDistributedLocker x0, boolean x1) {
        x0.demotion = x1;
        return x0.demotion;
    }

    static {
        IGNORE_MYSQL_CODE.add(1205);
        IGNORE_MYSQL_MESSAGE.add(LOCK_WAIT_TIMEOUT_MYSQL_MESSAGE);
    }
}

