/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.fury.Fury;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.collection.Tuple3;
import org.apache.fury.memory.Platform;
import org.apache.fury.reflect.FieldAccessor;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.resolver.ClassInfo;
import org.apache.fury.resolver.ClassInfoHolder;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.resolver.RefResolver;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.type.Descriptor;
import org.apache.fury.type.DescriptorGrouper;
import org.apache.fury.type.FinalObjectTypeStub;
import org.apache.fury.type.GenericType;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.record.RecordComponent;
import org.apache.fury.util.record.RecordInfo;
import org.apache.fury.util.record.RecordUtils;

public abstract class AbstractObjectSerializer<T>
extends Serializer<T> {
    protected final RefResolver refResolver;
    protected final ClassResolver classResolver;
    protected final boolean isRecord;
    protected final MethodHandle constructor;
    private InternalFieldInfo[] fieldInfos;
    private RecordInfo copyRecordInfo;

    public AbstractObjectSerializer(Fury fury, Class<T> type) {
        this(fury, type, RecordUtils.isRecord(type) ? (MethodHandle)RecordUtils.getRecordConstructor(type).f1 : ReflectionUtils.getCtrHandle(type, false));
    }

    public AbstractObjectSerializer(Fury fury, Class<T> type, MethodHandle constructor) {
        super(fury, type);
        this.refResolver = fury.getRefResolver();
        this.classResolver = fury.getClassResolver();
        this.isRecord = RecordUtils.isRecord(type);
        this.constructor = constructor;
    }

    @Override
    public T copy(T originObj) {
        if (this.immutable) {
            return originObj;
        }
        if (this.isRecord) {
            return this.copyRecord(originObj);
        }
        T newObj = this.newBean();
        if (this.needToCopyRef) {
            this.fury.reference(originObj, newObj);
        }
        this.copyFields(originObj, newObj);
        return newObj;
    }

    private T copyRecord(T originObj) {
        Object[] fieldValues = this.copyFields(originObj);
        try {
            Object t = this.constructor.invokeWithArguments(fieldValues);
            Arrays.fill(this.copyRecordInfo.getRecordComponents(), null);
            this.fury.reference(originObj, t);
            return (T)t;
        }
        catch (Throwable e) {
            Platform.throwException(e);
            return originObj;
        }
    }

    private Object[] copyFields(T originObj) {
        InternalFieldInfo[] fieldInfos = this.fieldInfos;
        if (fieldInfos == null) {
            fieldInfos = this.buildFieldsInfo();
        }
        Object[] fieldValues = new Object[fieldInfos.length];
        for (int i = 0; i < fieldInfos.length; ++i) {
            InternalFieldInfo fieldInfo = fieldInfos[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            long fieldOffset = fieldAccessor.getFieldOffset();
            if (fieldOffset != -1L) {
                fieldValues[i] = this.copyField(originObj, fieldOffset, fieldInfo.classId);
                continue;
            }
            Object fieldValue = fieldAccessor.get(originObj);
            fieldValues[i] = this.fury.copyObject(fieldValue, fieldInfo.classId);
        }
        return RecordUtils.remapping(this.copyRecordInfo, fieldValues);
    }

    private void copyFields(T originObj, T newObj) {
        InternalFieldInfo[] fieldInfos = this.fieldInfos;
        if (fieldInfos == null) {
            fieldInfos = this.buildFieldsInfo();
        }
        block11: for (InternalFieldInfo fieldInfo : fieldInfos) {
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            long fieldOffset = fieldAccessor.getFieldOffset();
            assert (fieldOffset != -1L);
            switch (fieldInfo.classId) {
                case 6: {
                    Platform.putByte(newObj, fieldOffset, Platform.getByte(originObj, fieldOffset));
                    continue block11;
                }
                case 7: {
                    Platform.putChar(newObj, fieldOffset, Platform.getChar(originObj, fieldOffset));
                    continue block11;
                }
                case 8: {
                    Platform.putShort(newObj, fieldOffset, Platform.getShort(originObj, fieldOffset));
                    continue block11;
                }
                case 9: {
                    Platform.putInt(newObj, fieldOffset, Platform.getInt(originObj, fieldOffset));
                    continue block11;
                }
                case 11: {
                    Platform.putLong(newObj, fieldOffset, Platform.getLong(originObj, fieldOffset));
                    continue block11;
                }
                case 10: {
                    Platform.putFloat(newObj, fieldOffset, Platform.getFloat(originObj, fieldOffset));
                    continue block11;
                }
                case 12: {
                    Platform.putDouble(newObj, fieldOffset, Platform.getDouble(originObj, fieldOffset));
                    continue block11;
                }
                case 5: {
                    Platform.putBoolean(newObj, fieldOffset, Platform.getBoolean(originObj, fieldOffset));
                    continue block11;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    Platform.putObject(newObj, fieldOffset, Platform.getObject(originObj, fieldOffset));
                    continue block11;
                }
                default: {
                    Platform.putObject(newObj, fieldOffset, this.fury.copyObject(Platform.getObject(originObj, fieldOffset)));
                }
            }
        }
    }

    private Object copyField(Object targetObject, long fieldOffset, short classId) {
        switch (classId) {
            case 5: {
                return Platform.getBoolean(targetObject, fieldOffset);
            }
            case 6: {
                return Platform.getByte(targetObject, fieldOffset);
            }
            case 7: {
                return Character.valueOf(Platform.getChar(targetObject, fieldOffset));
            }
            case 8: {
                return Platform.getShort(targetObject, fieldOffset);
            }
            case 9: {
                return Platform.getInt(targetObject, fieldOffset);
            }
            case 10: {
                return Float.valueOf(Platform.getFloat(targetObject, fieldOffset));
            }
            case 11: {
                return Platform.getLong(targetObject, fieldOffset);
            }
            case 12: {
                return Platform.getDouble(targetObject, fieldOffset);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return Platform.getObject(targetObject, fieldOffset);
            }
        }
        return this.fury.copyObject(Platform.getObject(targetObject, fieldOffset));
    }

    private InternalFieldInfo[] buildFieldsInfo() {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        if (RecordUtils.isRecord(this.type)) {
            RecordComponent[] components = RecordUtils.getRecordComponents(this.type);
            assert (components != null);
            try {
                for (Object object : components) {
                    Field field = this.type.getDeclaredField(((RecordComponent)object).getName());
                    descriptors.add(new Descriptor(field, TypeRef.of(field.getGenericType()), ((RecordComponent)object).getAccessor(), null));
                }
            }
            catch (NoSuchFieldException e) {
                Platform.throwException(e);
            }
        } else {
            for (Field field : ReflectionUtils.getFields(this.type, true)) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                descriptors.add(new Descriptor(field, TypeRef.of(field.getGenericType()), null, null));
            }
        }
        DescriptorGrouper descriptorGrouper = DescriptorGrouper.createDescriptorGrouper(this.fury.getClassResolver()::isMonomorphic, descriptors, false, this.fury.compressInt(), this.fury.compressLong());
        Tuple3<Tuple2<FinalTypeField[], boolean[]>, GenericTypeField[], GenericTypeField[]> infos = AbstractObjectSerializer.buildFieldInfos(this.fury, descriptorGrouper);
        this.fieldInfos = new InternalFieldInfo[descriptors.size()];
        System.arraycopy(((Tuple2)infos.f0).f0, 0, this.fieldInfos, 0, ((FinalTypeField[])((Tuple2)infos.f0).f0).length);
        System.arraycopy(infos.f1, 0, this.fieldInfos, ((FinalTypeField[])((Tuple2)infos.f0).f0).length, ((GenericTypeField[])infos.f1).length);
        System.arraycopy(infos.f2, 0, this.fieldInfos, this.fieldInfos.length - ((GenericTypeField[])infos.f2).length, ((GenericTypeField[])infos.f2).length);
        if (this.isRecord) {
            List<String> fieldNames = Arrays.stream(this.fieldInfos).map(f -> f.fieldAccessor.getField().getName()).collect(Collectors.toList());
            this.copyRecordInfo = new RecordInfo(this.type, fieldNames);
        }
        return this.fieldInfos;
    }

    protected T newBean() {
        if (this.constructor != null) {
            try {
                return (T)this.constructor.invoke();
            }
            catch (Throwable e) {
                Platform.throwException(e);
            }
        }
        return Platform.newInstance(this.type);
    }

    static Tuple3<Tuple2<FinalTypeField[], boolean[]>, GenericTypeField[], GenericTypeField[]> buildFieldInfos(Fury fury, DescriptorGrouper grouper) {
        Collection<Descriptor> primitives = grouper.getPrimitiveDescriptors();
        Collection<Descriptor> boxed = grouper.getBoxedDescriptors();
        Collection<Descriptor> finals = grouper.getFinalDescriptors();
        FinalTypeField[] finalFields = new FinalTypeField[primitives.size() + boxed.size() + finals.size()];
        int cnt = 0;
        for (Descriptor d : primitives) {
            finalFields[cnt++] = AbstractObjectSerializer.buildFinalTypeField(fury, d);
        }
        for (Descriptor d : boxed) {
            finalFields[cnt++] = AbstractObjectSerializer.buildFinalTypeField(fury, d);
        }
        for (Descriptor d : finals) {
            finalFields[cnt++] = AbstractObjectSerializer.buildFinalTypeField(fury, d);
        }
        boolean[] isFinal = new boolean[finalFields.length];
        for (int i = 0; i < isFinal.length; ++i) {
            ClassInfo classInfo = finalFields[i].classInfo;
            isFinal[i] = classInfo != null && fury.getClassResolver().isMonomorphic(classInfo.getCls());
        }
        cnt = 0;
        GenericTypeField[] otherFields = new GenericTypeField[grouper.getOtherDescriptors().size()];
        for (Descriptor descriptor : grouper.getOtherDescriptors()) {
            GenericTypeField genericTypeField = new GenericTypeField(descriptor.getRawType(), descriptor.getDeclaringClass() + "." + descriptor.getName(), descriptor.getField() != null ? FieldAccessor.createAccessor(descriptor.getField()) : null, fury);
            otherFields[cnt++] = genericTypeField;
        }
        cnt = 0;
        Collection<Descriptor> collections = grouper.getCollectionDescriptors();
        Collection<Descriptor> maps = grouper.getMapDescriptors();
        GenericTypeField[] containerFields = new GenericTypeField[collections.size() + maps.size()];
        for (Descriptor d : collections) {
            containerFields[cnt++] = AbstractObjectSerializer.buildContainerField(fury, d);
        }
        for (Descriptor d : maps) {
            containerFields[cnt++] = AbstractObjectSerializer.buildContainerField(fury, d);
        }
        return Tuple3.of(Tuple2.of(finalFields, isFinal), otherFields, containerFields);
    }

    private static FinalTypeField buildFinalTypeField(Fury fury, Descriptor d) {
        return new FinalTypeField(d.getRawType(), d.getDeclaringClass() + "." + d.getName(), d.getField() != null ? FieldAccessor.createAccessor(d.getField()) : null, fury);
    }

    private static GenericTypeField buildContainerField(Fury fury, Descriptor d) {
        return new GenericTypeField(d.getTypeRef(), d.getDeclaringClass() + "." + d.getName(), d.getField() != null ? FieldAccessor.createAccessor(d.getField()) : null, fury);
    }

    private static short getRegisteredClassId(Fury fury, Class<?> cls) {
        Short classId = fury.getClassResolver().getRegisteredClassId(cls);
        return classId == null ? (short)0 : classId;
    }

    static final class GenericTypeField
    extends InternalFieldInfo {
        final GenericType genericType;
        final ClassInfoHolder classInfoHolder;
        final boolean trackingRef;

        private GenericTypeField(Class<?> cls, String qualifiedFieldName, FieldAccessor accessor, Fury fury) {
            super(AbstractObjectSerializer.getRegisteredClassId(fury, cls), qualifiedFieldName, accessor);
            this.genericType = fury.getClassResolver().buildGenericType(cls);
            this.classInfoHolder = fury.getClassResolver().nilClassInfoHolder();
            this.trackingRef = fury.getClassResolver().needToWriteRef(cls);
        }

        private GenericTypeField(TypeRef<?> typeRef, String qualifiedFieldName, FieldAccessor accessor, Fury fury) {
            super(AbstractObjectSerializer.getRegisteredClassId(fury, TypeUtils.getRawType(typeRef)), qualifiedFieldName, accessor);
            this.genericType = fury.getClassResolver().buildGenericType(typeRef);
            this.classInfoHolder = fury.getClassResolver().nilClassInfoHolder();
            this.trackingRef = fury.getClassResolver().needToWriteRef(TypeUtils.getRawType(typeRef));
        }

        @Override
        public String toString() {
            return "GenericTypeField{genericType=" + this.genericType + ", classId=" + this.classId + ", qualifiedFieldName=" + this.qualifiedFieldName + ", field=" + (this.fieldAccessor != null ? this.fieldAccessor.getField() : null) + '}';
        }
    }

    static final class FinalTypeField
    extends InternalFieldInfo {
        final ClassInfo classInfo;

        private FinalTypeField(Class<?> type, String fieldName, FieldAccessor accessor, Fury fury) {
            super(AbstractObjectSerializer.getRegisteredClassId(fury, type), fieldName, accessor);
            this.classInfo = type == FinalObjectTypeStub.class ? null : fury.getClassResolver().getClassInfo(type);
        }
    }

    static class InternalFieldInfo {
        protected final short classId;
        protected final String qualifiedFieldName;
        protected final FieldAccessor fieldAccessor;

        private InternalFieldInfo(short classId, String qualifiedFieldName, FieldAccessor fieldAccessor) {
            this.classId = classId;
            this.qualifiedFieldName = qualifiedFieldName;
            this.fieldAccessor = fieldAccessor;
        }

        public String toString() {
            return "InternalFieldInfo{classId=" + this.classId + ", fieldName=" + this.qualifiedFieldName + ", field=" + (this.fieldAccessor != null ? this.fieldAccessor.getField() : null) + '}';
        }
    }
}

