/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer.collection;

import java.util.Collection;
import org.apache.fury.Fury;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.serializer.collection.AbstractCollectionSerializer;
import org.apache.fury.util.Preconditions;

public class CollectionSerializer<T extends Collection>
extends AbstractCollectionSerializer<T> {
    public CollectionSerializer(Fury fury, Class<T> type) {
        super(fury, type);
    }

    public CollectionSerializer(Fury fury, Class<T> type, boolean supportCodegenHook) {
        super(fury, type, supportCodegenHook);
    }

    public CollectionSerializer(Fury fury, Class<T> type, boolean supportCodegenHook, boolean immutable) {
        super(fury, type, supportCodegenHook, immutable);
    }

    @Override
    public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
        buffer.writeVarUint32Small7(value.size());
        return value;
    }

    @Override
    public T onCollectionRead(Collection collection) {
        return (T)collection;
    }

    @Override
    public T copy(T originCollection) {
        if (this.isImmutable()) {
            return originCollection;
        }
        Preconditions.checkArgument(this.supportCodegenHook);
        Collection newCollection = this.newCollection((Collection)originCollection);
        if (this.needToCopyRef) {
            this.fury.reference(originCollection, newCollection);
        }
        this.copyElements((Collection)originCollection, newCollection);
        return (T)newCollection;
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Collection collection = this.newCollection(buffer);
        int numElements = this.getAndClearNumElements();
        if (numElements != 0) {
            this.readElements(this.fury, buffer, collection, numElements);
        }
        return (T)this.onCollectionRead(collection);
    }
}

