/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.util.unsafe;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.fury.util.unsafe._JDKAccess;

class _Lookup {
    static final MethodHandles.Lookup IMPL_LOOKUP;
    static volatile MethodHandle CONSTRUCTOR_LOOKUP;
    static volatile boolean CONSTRUCTOR_LOOKUP_ERROR;
    private static volatile Method PRIVATE_LOOKUP_IN;
    private static volatile Method DEFINE_CLASS;

    _Lookup() {
    }

    public static MethodHandles.Lookup _trustedLookup(Class<?> objectClass) {
        MethodHandles.Lookup lookup;
        if (!CONSTRUCTOR_LOOKUP_ERROR) {
            try {
                int trusted = -1;
                MethodHandle constructor = CONSTRUCTOR_LOOKUP;
                if (_JDKAccess.JAVA_VERSION < 14) {
                    if (constructor == null) {
                        CONSTRUCTOR_LOOKUP = constructor = IMPL_LOOKUP.findConstructor(MethodHandles.Lookup.class, MethodType.methodType(Void.TYPE, Class.class, Integer.TYPE));
                    }
                    int fullAccessMask = 31;
                    return constructor.invoke(objectClass, _JDKAccess.IS_OPEN_J9 ? fullAccessMask : trusted);
                }
                if (constructor == null) {
                    CONSTRUCTOR_LOOKUP = constructor = IMPL_LOOKUP.findConstructor(MethodHandles.Lookup.class, MethodType.methodType(Void.TYPE, Class.class, Class.class, Integer.TYPE));
                }
                return constructor.invoke(objectClass, null, trusted);
            }
            catch (Throwable ignored) {
                CONSTRUCTOR_LOOKUP_ERROR = true;
            }
        }
        if (_JDKAccess.JAVA_VERSION < 11 && (lookup = _Lookup.getLookupByReflection(objectClass)) != null) {
            return lookup;
        }
        return IMPL_LOOKUP.in(objectClass);
    }

    private static MethodHandles.Lookup getLookupByReflection(Class<?> cls) {
        try {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            return (MethodHandles.Lookup)constructor.newInstance(cls, -1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static MethodHandles.Lookup privateLookupIn(Class<?> targetClass, MethodHandles.Lookup caller) {
        try {
            if (PRIVATE_LOOKUP_IN == null) {
                Method m = MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                m.setAccessible(true);
                PRIVATE_LOOKUP_IN = m;
            }
            return (MethodHandles.Lookup)PRIVATE_LOOKUP_IN.invoke(null, targetClass, caller);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> defineClass(MethodHandles.Lookup lookup, byte[] bytes) {
        try {
            if (DEFINE_CLASS == null) {
                Method m = MethodHandles.Lookup.class.getDeclaredMethod("defineClass", byte[].class);
                m.setAccessible(true);
                DEFINE_CLASS = m;
            }
            return (Class)DEFINE_CLASS.invoke((Object)lookup, new Object[]{bytes});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        MethodHandles.Lookup trustedLookup = null;
        try {
            Field implLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long fieldOffset = _JDKAccess.UNSAFE.staticFieldOffset(implLookup);
            Object fieldBase = _JDKAccess.UNSAFE.staticFieldBase(implLookup);
            trustedLookup = (MethodHandles.Lookup)_JDKAccess.UNSAFE.getObject(fieldBase, fieldOffset);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (trustedLookup == null) {
            trustedLookup = MethodHandles.lookup();
        }
        IMPL_LOOKUP = trustedLookup;
        PRIVATE_LOOKUP_IN = null;
        DEFINE_CLASS = null;
    }
}

